/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.reader;

import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.reader.OPBReader2010;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;

public class OPBReader2012
extends OPBReader2010 {
    private LexicoDecoratorPB lexico = null;
    private static final long serialVersionUID = 1L;

    public OPBReader2012(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    protected void readMetaData() throws IOException, ParseFormatException {
        super.readMetaData();
        this.skipSpaces();
        char c = this.get();
        if (c != '*') {
            this.putback(c);
            return;
        }
        this.skipSpaces();
        String string = this.readWord();
        if ("#aggregation=".equals(string)) {
            string = this.readWord();
            assert ("lexico".equals(string));
            this.lexico = new LexicoDecoratorPB(this.solver);
        } else {
            this.in.readLine();
            this.get();
        }
    }

    protected void readObjective() throws IOException, ParseFormatException {
        super.readObjective();
        if (this.lexico != null && !this.lits.isEmpty()) {
            this.lexico.addCriterion(this.lits, (IVec<BigInteger>)this.coeffs);
            this.lits.clear();
            this.coeffs.clear();
            this.readObjective();
        }
    }

    public IProblem parseInstance(Reader reader) throws ParseFormatException, ContradictionException {
        IProblem iProblem = super.parseInstance(reader);
        if (this.lexico != null) {
            return this.lexico;
        }
        return iProblem;
    }
}

