/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.ClausalCardinalitiesDecorator;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;
import org.sat4j.tools.encoding.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClausalConstraintsDecorator
extends ClausalCardinalitiesDecorator<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private final IPBSolver solver;

    public ClausalConstraintsDecorator(IPBSolver iPBSolver, EncodingStrategyAdapter encodingStrategyAdapter) {
        super((ISolver)iPBSolver, encodingStrategyAdapter);
        this.solver = iPBSolver;
    }

    public ClausalConstraintsDecorator(IPBSolver iPBSolver) {
        super((ISolver)iPBSolver, (EncodingStrategyAdapter)new Policy());
        this.solver = iPBSolver;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(iVec)) {
            if (bl) {
                return super.addAtLeast(iVecInt, bigInteger.intValue());
            }
            return super.addAtMost(iVecInt, bigInteger.intValue());
        }
        return this.solver.addPseudoBoolean(iVecInt, iVec, bl, bigInteger);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.solver.setObjectiveFunction(objectiveFunction);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.solver.getObjectiveFunction();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(iVecInt2)) {
            return super.addAtMost(iVecInt, n);
        }
        return this.solver.addAtMost(iVecInt, iVecInt2, n);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(iVec)) {
            return super.addAtMost(iVecInt, bigInteger.intValue());
        }
        return this.solver.addAtMost(iVecInt, iVec, bigInteger);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(iVecInt2)) {
            return super.addAtLeast(iVecInt, n);
        }
        return this.solver.addAtLeast(iVecInt, iVecInt2, n);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(iVec)) {
            return super.addAtLeast(iVecInt, bigInteger.intValue());
        }
        return this.solver.addAtLeast(iVecInt, iVec, bigInteger);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(iVecInt2)) {
            return super.addExactly(iVecInt, n);
        }
        return this.solver.addExactly(iVecInt, iVecInt2, n);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        if (ClausalConstraintsDecorator.isCardinality(iVec)) {
            return super.addExactly(iVecInt, bigInteger.intValue());
        }
        return this.solver.addExactly(iVecInt, iVec, bigInteger);
    }

    public static boolean isCardinality(IVecInt iVecInt) {
        boolean bl = true;
        int n = 0;
        while (bl && n < iVecInt.size()) {
            bl = iVecInt.get(n) == 1;
            ++n;
        }
        return bl;
    }

    public static boolean isCardinality(IVec<BigInteger> iVec) {
        boolean bl = true;
        int n = 0;
        while (bl && n < iVec.size()) {
            bl = iVec.get(n) == BigInteger.ONE;
            ++n;
        }
        return bl;
    }
}

