/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.xplain.Xplain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XplainPB
extends Xplain<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;

    public XplainPB(IPBSolver iPBSolver) {
        super((ISolver)iPBSolver);
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        VecInt vecInt = new VecInt(iVecInt.size(), 1);
        int n2 = this.createNewVar(iVecInt);
        iVecInt.push(n2);
        vecInt.push(vecInt.size() - n);
        IConstr iConstr = ((IPBSolver)this.decorated()).addAtLeast(iVecInt, (IVecInt)vecInt, n);
        if (iConstr == null) {
            this.discardLastestVar();
        } else {
            this.getConstrs().put(n2, iConstr);
        }
        return iConstr;
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        VecInt vecInt = new VecInt(iVecInt.size(), 1);
        int n2 = this.createNewVar(iVecInt);
        iVecInt.push(n2);
        vecInt.push(n - vecInt.size());
        IConstr iConstr = ((IPBSolver)this.decorated()).addAtMost(iVecInt, (IVecInt)vecInt, n);
        if (iConstr == null) {
            this.discardLastestVar();
        } else {
            this.getConstrs().put(n2, iConstr);
        }
        return iConstr;
    }

    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        int n2 = this.createNewVar(iVecInt);
        VecInt vecInt = new VecInt(iVecInt.size(), 1);
        iVecInt.push(n2);
        vecInt.push(n - vecInt.size());
        IConstr iConstr = ((IPBSolver)this.decorated()).addAtMost(iVecInt, (IVecInt)vecInt, n);
        vecInt.pop();
        vecInt.push(vecInt.size() - n);
        IConstr iConstr2 = ((IPBSolver)this.decorated()).addAtLeast(iVecInt, (IVecInt)vecInt, n);
        if (iConstr == null && iConstr2 == null) {
            this.discardLastestVar();
            return null;
        }
        ConstrGroup constrGroup = new ConstrGroup();
        constrGroup.add(iConstr);
        constrGroup.add(iConstr2);
        this.getConstrs().put(n2, constrGroup);
        return constrGroup;
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        BigInteger bigInteger2;
        int n = this.createNewVar(iVecInt);
        iVecInt.push(n);
        if (bl && bigInteger.signum() >= 0) {
            iVec.push((Object)bigInteger);
        } else {
            bigInteger2 = BigInteger.ZERO;
            Iterator iterator = iVec.iterator();
            while (iterator.hasNext()) {
                bigInteger2 = bigInteger2.add((BigInteger)iterator.next());
            }
            bigInteger2 = bigInteger2.subtract(bigInteger);
            iVec.push((Object)bigInteger2.negate());
        }
        bigInteger2 = ((IPBSolver)this.decorated()).addPseudoBoolean(iVecInt, iVec, bl, bigInteger);
        if (bigInteger2 == null) {
            this.discardLastestVar();
        } else {
            this.getConstrs().put(n, bigInteger2);
        }
        return bigInteger2;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(objectiveFunction);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

