/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.PrintWriter;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

public class OptToPBSATAdapter
extends PBSolverDecorator {
    private static final long serialVersionUID = 1L;
    IOptimizationProblem problem;
    private final IVecInt assumps = new VecInt();
    private long begin;
    private SolutionFoundListener sfl;

    public OptToPBSATAdapter(IOptimizationProblem problem) {
        this(problem, SolutionFoundListener.VOID);
    }

    public OptToPBSATAdapter(IOptimizationProblem problem, SolutionFoundListener sfl) {
        super((IPBSolver)((Object)problem));
        this.problem = problem;
        this.sfl = sfl;
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt myAssumps, boolean global) throws TimeoutException {
        return this.isSatisfiable(myAssumps);
    }

    public boolean isSatisfiable(IVecInt myAssumps) throws TimeoutException {
        this.assumps.clear();
        myAssumps.copyTo(this.assumps);
        this.begin = System.currentTimeMillis();
        if (this.problem.hasNoObjectiveFunction()) {
            return this.problem.isSatisfiable(myAssumps);
        }
        boolean satisfiable = false;
        try {
            while (this.problem.admitABetterSolution(myAssumps)) {
                satisfiable = true;
                this.sfl.onSolutionFound(this.problem.model());
                this.problem.discardCurrentSolution();
                if (!this.isVerbose()) continue;
                System.out.println(String.valueOf(this.getLogPrefix()) + "Current objective function value: " + this.problem.getObjectiveValue() + "(" + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
            this.sfl.onUnsatTermination();
            if (this.isVerbose()) {
                System.out.println(String.valueOf(this.getLogPrefix()) + "Optimal objective function value: " + this.problem.getObjectiveValue() + "(" + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
        }
        catch (TimeoutException e) {
            if (this.isVerbose()) {
                System.out.println(String.valueOf(this.getLogPrefix()) + "Solver timed out after " + (double)(System.currentTimeMillis() - this.begin) / 1000.0 + "s)");
            }
            if (!satisfiable) {
                throw e;
            }
        }
        catch (ContradictionException contradictionException) {
            this.sfl.onUnsatTermination();
        }
        return satisfiable;
    }

    public int[] model() {
        return this.model(new PrintWriter(System.out, true));
    }

    public int[] model(PrintWriter out) {
        return this.problem.model();
    }

    public boolean model(int var) {
        return this.problem.model(var);
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + "Optimization to Pseudo Boolean adapter\n" + super.toString(prefix);
    }

    public boolean isOptimal() {
        return this.problem.isOptimal();
    }

    public Number getCurrentObjectiveValue() {
        return this.problem.getObjectiveValue();
    }

    public void setTimeoutForFindingBetterSolution(int seconds) {
        this.problem.setTimeoutForFindingBetterSolution(seconds);
    }

    public void setSolutionFoundListener(SolutionFoundListener sfl) {
        this.sfl = sfl;
    }
}

