/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.reader.OPBReader2007;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.GateTranslator;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoBitsAdderDecorator
extends SolverDecorator<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private final GateTranslator gator;
    private final IPBSolver solver;

    public PseudoBitsAdderDecorator(IPBSolver solver) {
        super(solver);
        this.gator = new GateTranslator(solver);
        this.solver = solver;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objf) {
        this.objfct = objf;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        if (this.objfct == null) {
            return this.gator.isSatisfiable(assumps);
        }
        System.out.println("c Original number of variables and constraints");
        System.out.println("c #vars: " + this.gator.nVars() + " #constraints: " + this.gator.nConstraints());
        VecInt bitsLiterals = new VecInt();
        System.out.println("c Creating optimization constraints ....");
        try {
            this.gator.optimisationFunction(this.objfct.getVars(), this.objfct.getCoeffs(), bitsLiterals);
        }
        catch (ContradictionException contradictionException) {
            return false;
        }
        System.out.println("c ... done. " + bitsLiterals);
        System.out.println("c New number of variables and constraints");
        System.out.println("c #vars: " + this.gator.nVars() + " #constraints: " + this.gator.nConstraints());
        VecInt fixedLiterals = new VecInt(bitsLiterals.size());
        VecInt nAssumpts = new VecInt(assumps.size() + bitsLiterals.size());
        int litIndex = bitsLiterals.size() - 1;
        while (litIndex >= 0) {
            assumps.copyTo(nAssumpts);
            fixedLiterals.copyTo(nAssumpts);
            nAssumpts.push(-bitsLiterals.get(litIndex));
            int j = litIndex - 1;
            while (j >= 0) {
                nAssumpts.push(bitsLiterals.get(j));
                --j;
            }
            System.out.println("c assumptions " + nAssumpts);
            boolean result = this.gator.isSatisfiable(nAssumpts, true);
            if (result) {
                fixedLiterals.push(-bitsLiterals.get(litIndex--));
                BigInteger value = this.objfct.calculateDegree(this.gator);
                System.out.println("o " + value);
                System.out.println("c current objective value with fixed lits " + fixedLiterals);
            } else {
                fixedLiterals.push(bitsLiterals.get(litIndex--));
                System.out.println("c unsat. fixed lits " + fixedLiterals);
            }
            nAssumpts.clear();
        }
        assert (fixedLiterals.size() == bitsLiterals.size());
        assumps.copyTo(nAssumpts);
        fixedLiterals.copyTo(nAssumpts);
        return this.gator.isSatisfiable(nAssumpts);
    }

    public static void main(String[] args) {
        PseudoBitsAdderDecorator decorator = new PseudoBitsAdderDecorator(SolverFactory.newDefault());
        decorator.setVerbose(false);
        OPBReader2007 reader = new OPBReader2007(decorator);
        long begin = System.currentTimeMillis();
        try {
            IProblem problem = reader.parseInstance(args[0]);
            if (problem.isSatisfiable()) {
                System.out.println("s OPTIMUM FOUND");
                System.out.println("v " + reader.decode(problem.model()));
                if (decorator.objfct != null) {
                    System.out.println("c objective function=" + decorator.objfct.calculateDegree(decorator.gator));
                }
            } else {
                System.out.println("s UNSAT");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            System.out.println("s UNSAT");
            System.out.println("c trivial inconsistency");
        }
        catch (TimeoutException timeoutException) {
            System.out.println("s UNKNOWN");
        }
        long end = System.currentTimeMillis();
        System.out.println("c Total wall clock time: " + (double)(end - begin) / 1000.0 + " seconds");
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        return this.solver.addPseudoBoolean(lits, coeffs, moreThan, d);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objfct;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

