/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.TimeoutException;

public class PseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private BigInteger objectiveValue;
    private int[] prevmodel;
    private int[] prevmodelwithadditionalvars;
    private boolean[] prevfullmodel;
    private IConstr previousPBConstr;
    private boolean isSolutionOptimal;
    private final boolean nonOptimalMeansSatisfiable;
    private final boolean useAnImplicantForEvaluation;
    private int solverTimeout = Integer.MAX_VALUE;
    private int optimizationTimeout = -1;

    public PseudoOptDecorator(IPBSolver solver) {
        this(solver, true);
    }

    public PseudoOptDecorator(IPBSolver solver, boolean nonOptimalMeansSatisfiable) {
        this(solver, nonOptimalMeansSatisfiable, false);
    }

    public PseudoOptDecorator(IPBSolver solver, boolean nonOptimalMeansSatisfiable, boolean useAnImplicantForEvaluation) {
        super(solver);
        this.nonOptimalMeansSatisfiable = nonOptimalMeansSatisfiable;
        this.useAnImplicantForEvaluation = useAnImplicantForEvaluation;
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        boolean result = super.isSatisfiable(assumps, true);
        if (result) {
            this.prevmodel = super.model();
            this.prevmodelwithadditionalvars = super.modelWithInternalVariables();
            this.prevfullmodel = new boolean[this.nVars()];
            int i = 0;
            while (i < this.nVars()) {
                this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
                ++i;
            }
            if (this.optimizationTimeout > 0) {
                super.expireTimeout();
                super.setTimeout(this.optimizationTimeout);
            }
        } else {
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
            super.setTimeout(this.solverTimeout);
        }
        return result;
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, true);
    }

    public void setObjectiveFunction(ObjectiveFunction objf) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(objf);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        try {
            this.isSolutionOptimal = false;
            boolean result = super.isSatisfiable(assumps, true);
            if (result) {
                this.prevmodel = this.useAnImplicantForEvaluation ? this.modelWithAdaptedNonPrimeLiterals() : super.model();
                this.prevmodelwithadditionalvars = super.modelWithInternalVariables();
                this.prevfullmodel = new boolean[this.nVars()];
                int i = 0;
                while (i < this.nVars()) {
                    this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
                    ++i;
                }
                if (((IPBSolver)this.decorated()).getObjectiveFunction() != null) {
                    this.calculateObjective();
                }
                if (this.optimizationTimeout > 0) {
                    super.expireTimeout();
                    super.setTimeout(this.optimizationTimeout);
                }
            } else {
                this.isSolutionOptimal = true;
                if (this.previousPBConstr != null) {
                    ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                    this.previousPBConstr = null;
                }
            }
            return result;
        }
        catch (TimeoutException te) {
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
            throw te;
        }
    }

    private int[] modelWithAdaptedNonPrimeLiterals() {
        int[] completeModel = new int[this.nVars()];
        int i = 0;
        while (i < this.nVars()) {
            int var = i + 1;
            completeModel[i] = super.model(var) ? var : -var;
            ++i;
        }
        this.primeImplicant();
        ObjectiveFunction obj = this.getObjectiveFunction();
        int i2 = 0;
        while (i2 < obj.getVars().size()) {
            int d = obj.getVars().get(i2);
            BigInteger coeff = obj.getCoeffs().get(i2);
            if (d <= this.nVars() && !this.primeImplicant(d) && !this.primeImplicant(-d)) {
                assert (Math.abs(completeModel[Math.abs(d) - 1]) == d);
                completeModel[Math.abs((int)d) - 1] = coeff.signum() * d < 0 ? Math.abs(d) : -Math.abs(d);
            }
            ++i2;
        }
        return completeModel;
    }

    public boolean hasNoObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction() == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return this.nonOptimalMeansSatisfiable;
    }

    public Number calculateObjective() {
        if (((IPBSolver)this.decorated()).getObjectiveFunction() == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = this.useAnImplicantForEvaluation ? ((IPBSolver)this.decorated()).getObjectiveFunction().calculateDegreeImplicant((ISolver)this.decorated()) : ((IPBSolver)this.decorated()).getObjectiveFunction().calculateDegree((RandomAccessModel)this.decorated());
        return this.getObjectiveValue();
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.previousPBConstr != null) {
            super.removeSubsumedConstr(this.previousPBConstr);
        }
        if (((IPBSolver)this.decorated()).getObjectiveFunction() != null && this.objectiveValue != null) {
            this.previousPBConstr = super.addPseudoBoolean(((IPBSolver)this.decorated()).getObjectiveFunction().getVars(), ((IPBSolver)this.decorated()).getObjectiveFunction().getCoeffs(), false, this.objectiveValue.subtract(BigInteger.ONE));
        }
    }

    public void reset() {
        this.previousPBConstr = null;
        super.reset();
    }

    public int[] model() {
        return this.prevmodel;
    }

    public boolean model(int var) {
        return this.prevfullmodel[var - 1];
    }

    public String toString(String prefix) {
        return String.valueOf(prefix) + "Pseudo Boolean Optimization by upper bound\n" + prefix + (this.useAnImplicantForEvaluation ? "using prime implicants for evaluating the objective function\n" : "") + super.toString(prefix);
    }

    public Number getObjectiveValue() {
        return this.objectiveValue.add(((IPBSolver)this.decorated()).getObjectiveFunction().getCorrection());
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        super.addPseudoBoolean(((IPBSolver)this.decorated()).getObjectiveFunction().getVars(), ((IPBSolver)this.decorated()).getObjectiveFunction().getCoeffs(), false, (BigInteger)forcedValue);
    }

    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }

    public int[] modelWithInternalVariables() {
        return this.prevmodelwithadditionalvars;
    }

    public void setTimeoutForFindingBetterSolution(int seconds) {
        this.optimizationTimeout = seconds;
    }

    public void setTimeout(int t) {
        this.solverTimeout = t;
        super.setTimeout(t);
    }
}

