/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IteratorInt;

public class ConflictMap
extends MapPb
implements IConflict {
    private final ILits voc;
    protected boolean hasBeenReduced = false;
    protected long numberOfReductions = 0L;
    protected BigInteger currentSlack;
    protected int currentLevel;
    protected VecInt[] byLevel;
    protected BigInteger coefMult = BigInteger.ZERO;
    protected BigInteger coefMultCons = BigInteger.ZERO;
    private BigInteger possReducedCoefs = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr cpb, int level) {
        return new ConflictMap(cpb, level);
    }

    ConflictMap(PBConstr cpb, int level) {
        super(cpb);
        this.voc = cpb.getVocabulary();
        this.currentLevel = level;
        this.initStructures();
    }

    private void initStructures() {
        this.currentSlack = BigInteger.ZERO;
        this.byLevel = new VecInt[ConflictMap.levelToIndex(this.currentLevel) + 1];
        int i = 0;
        while (i < this.size()) {
            int index;
            int ilit = this.weightedLits.getLit(i);
            int litLevel = this.voc.getLevel(ilit);
            BigInteger tmp = this.weightedLits.getCoef(i);
            if (!(tmp.signum() <= 0 || this.voc.isFalsified(ilit) && litLevel != this.currentLevel)) {
                this.currentSlack = this.currentSlack.add(tmp);
            }
            if (this.byLevel[index = ConflictMap.levelToIndex(litLevel)] == null) {
                this.byLevel[index] = new VecInt();
            }
            this.byLevel[index].push(ilit);
            ++i;
        }
    }

    private static int levelToIndex(int level) {
        return level + 1;
    }

    private static int indexToLevel(int indLevel) {
        return indLevel - 1;
    }

    public BigInteger resolve(PBConstr cpb, int litImplied, VarActivityListener val) {
        assert (litImplied > 1);
        int nLitImplied = litImplied ^ 1;
        if (cpb == null || !this.weightedLits.containsKey(nLitImplied)) {
            int litLevel = ConflictMap.levelToIndex(this.voc.getLevel(litImplied));
            int lit = 0;
            if (this.byLevel[litLevel] != null) {
                if (this.byLevel[litLevel].contains(litImplied)) {
                    lit = litImplied;
                    assert (this.weightedLits.containsKey(litImplied));
                } else if (this.byLevel[litLevel].contains(nLitImplied)) {
                    lit = nLitImplied;
                    assert (this.weightedLits.containsKey(nLitImplied));
                }
            }
            if (lit > 0) {
                this.byLevel[litLevel].remove(lit);
                if (this.byLevel[0] == null) {
                    this.byLevel[0] = new VecInt();
                }
                this.byLevel[0].push(lit);
            }
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] coefsCons = null;
        BigInteger degreeCons = cpb.getDegree();
        int ind = 0;
        while (cpb.get(ind) != litImplied) {
            ++ind;
        }
        assert (cpb.get(ind) == litImplied);
        assert (cpb.getCoef(ind) != BigInteger.ZERO);
        if (cpb.getCoef(ind).equals(BigInteger.ONE)) {
            this.coefMultCons = this.weightedLits.get(nLitImplied);
            this.coefMult = BigInteger.ONE;
            degreeCons = degreeCons.multiply(this.coefMultCons);
        } else {
            if (this.weightedLits.get(nLitImplied).equals(BigInteger.ONE)) {
                this.coefMult = cpb.getCoef(ind);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                IWatchPb wpb = (IWatchPb)cpb;
                coefsCons = wpb.getCoefs();
                assert (ConflictMap.positiveCoefs(coefsCons));
                degreeCons = this.reduceUntilConflict(litImplied, ind, coefsCons, wpb);
                degreeCons = degreeCons.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            if (!this.coefMult.equals(BigInteger.ONE)) {
                int i = 0;
                while (i < this.size()) {
                    this.changeCoef(i, this.weightedLits.getCoef(i).multiply(this.coefMult));
                    ++i;
                }
            }
        }
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.cuttingPlane(cpb, degreeCons, coefsCons, this.coefMultCons, val);
        assert (!this.weightedLits.containsKey(litImplied));
        assert (!this.weightedLits.containsKey(nLitImplied));
        assert (this.getLevelByLevel(litImplied) == -1);
        assert (this.getLevelByLevel(nLitImplied) == -1);
        assert (this.degree.signum() > 0);
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, IWatchPb wpb) {
        BigInteger slackIndex;
        BigInteger slackResolve = BigInteger.ONE.negate();
        BigInteger slackThis = BigInteger.ZERO;
        BigInteger slackConflict = this.slackConflict();
        BigInteger reducedDegree = wpb.getDegree();
        BigInteger previousCoefLitImplied = BigInteger.ZERO;
        BigInteger coefLitImplied = this.weightedLits.get(litImplied ^ 1);
        this.possReducedCoefs = this.possConstraint(wpb, reducedCoefs);
        do {
            if (slackResolve.signum() >= 0) {
                assert (slackThis.signum() > 0);
                BigInteger tmp = this.reduceInConstraint(wpb, reducedCoefs, ind, reducedDegree);
                assert (tmp.compareTo(reducedDegree) < 0 && tmp.compareTo(BigInteger.ONE) >= 0);
                reducedDegree = tmp;
            }
            assert (this.weightedLits.get(litImplied ^ 1).signum() > 0);
            assert (reducedCoefs[ind].signum() > 0);
            if (!reducedCoefs[ind].equals(previousCoefLitImplied)) {
                assert (coefLitImplied.equals(this.weightedLits.get(litImplied ^ 1)));
                BigInteger ppcm = ConflictMap.ppcm(reducedCoefs[ind], coefLitImplied);
                assert (ppcm.signum() > 0);
                this.coefMult = ppcm.divide(coefLitImplied);
                this.coefMultCons = ppcm.divide(reducedCoefs[ind]);
                assert (this.coefMultCons.signum() > 0);
                assert (this.coefMult.signum() > 0);
                assert (this.coefMult.multiply(coefLitImplied).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
                previousCoefLitImplied = reducedCoefs[ind];
            }
            slackThis = this.possReducedCoefs.subtract(reducedDegree).multiply(this.coefMultCons);
            assert (slackThis.equals(wpb.slackConstraint(reducedCoefs, reducedDegree).multiply(this.coefMultCons)));
            assert (slackConflict.equals(this.slackConflict()));
            slackIndex = slackConflict.multiply(this.coefMult);
            assert (slackIndex.signum() <= 0);
        } while ((slackResolve = slackThis.add(slackIndex)).signum() >= 0);
        assert (this.coefMult.multiply(this.weightedLits.get(litImplied ^ 1)).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
        return reducedDegree;
    }

    private BigInteger possConstraint(IWatchPb wpb, BigInteger[] theCoefs) {
        BigInteger poss = BigInteger.ZERO;
        int i = 0;
        while (i < wpb.size()) {
            if (!this.voc.isFalsified(wpb.get(i))) {
                assert (theCoefs[i].signum() >= 0);
                poss = poss.add(theCoefs[i]);
            }
            ++i;
        }
        return poss;
    }

    public BigInteger slackConflict() {
        BigInteger poss = BigInteger.ZERO;
        int i = 0;
        while (i < this.size()) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            if (tmp.signum() != 0 && !this.voc.isFalsified(this.weightedLits.getLit(i))) {
                assert (tmp.signum() > 0);
                poss = poss.add(tmp);
            }
            ++i;
        }
        return poss.subtract(this.degree);
    }

    public boolean oldIsAssertive(int dl) {
        BigInteger slack = this.computeSlack(dl).subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        int i = 0;
        while (i < this.size()) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            int lit = this.weightedLits.getLit(i);
            if (tmp.signum() > 0 && (this.voc.isUnassigned(lit) || this.voc.getLevel(lit) >= dl) && slack.compareTo(tmp) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private BigInteger computeSlack(int dl) {
        BigInteger slack = BigInteger.ZERO;
        int i = 0;
        while (i < this.size()) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            int lit = this.weightedLits.getLit(i);
            if (!(tmp.signum() <= 0 || this.voc.isFalsified(lit) && this.voc.getLevel(lit) < dl)) {
                slack = slack.add(tmp);
            }
            ++i;
        }
        return slack;
    }

    public boolean isAssertive(int dl) {
        assert (dl <= this.currentLevel);
        assert (dl <= this.currentLevel);
        this.currentLevel = dl;
        BigInteger slack = this.currentSlack.subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(slack);
    }

    private boolean isImplyingLiteral(BigInteger slack) {
        int level;
        int lit;
        int unassigned = ConflictMap.levelToIndex(-1);
        if (this.byLevel[unassigned] != null) {
            IteratorInt iterator = this.byLevel[unassigned].iterator();
            while (iterator.hasNext()) {
                lit = iterator.next();
                if (slack.compareTo(this.weightedLits.get(lit)) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(lit);
                return true;
            }
        }
        if (this.byLevel[level = ConflictMap.levelToIndex(this.currentLevel)] != null) {
            IteratorInt iterator = this.byLevel[level].iterator();
            while (iterator.hasNext()) {
                lit = iterator.next();
                BigInteger tmp = this.weightedLits.get(lit);
                if (tmp == null || slack.compareTo(tmp) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(lit);
                return true;
            }
        }
        return false;
    }

    private boolean isImplyingLiteralOrdered(int dl, BigInteger slack) {
        int i = 0;
        while (i < this.size()) {
            int ilit = this.weightedLits.getLit(i);
            int litLevel = this.voc.getLevel(ilit);
            if ((litLevel >= dl || this.voc.isUnassigned(ilit)) && slack.compareTo(this.weightedLits.getCoef(i)) < 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    public BigInteger reduceInConstraint(IWatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
        assert (degreeBis.compareTo(BigInteger.ONE) > 0);
        int lit = -1;
        int size = wpb.size();
        int ind = 0;
        while (ind < size && lit == -1) {
            if (coefsBis[ind].signum() != 0 && this.voc.isUnassigned(wpb.get(ind))) {
                assert (coefsBis[ind].compareTo(degreeBis) < 0);
                lit = ind;
            }
            ++ind;
        }
        if (lit == -1) {
            ind = 0;
            while (ind < size && lit == -1) {
                if (coefsBis[ind].signum() != 0 && this.voc.isSatisfied(wpb.get(ind)) && ind != indLitImplied) {
                    lit = ind;
                }
                ++ind;
            }
        }
        assert (lit != -1);
        assert (lit != indLitImplied);
        BigInteger degUpdate = degreeBis.subtract(coefsBis[lit]);
        this.possReducedCoefs = this.possReducedCoefs.subtract(coefsBis[lit]);
        coefsBis[lit] = BigInteger.ZERO;
        assert (this.possReducedCoefs.equals(this.possConstraint(wpb, coefsBis)));
        degUpdate = this.saturation(coefsBis, degUpdate, wpb);
        assert (coefsBis[indLitImplied].signum() > 0);
        assert (degreeBis.compareTo(degUpdate) > 0);
        assert (this.possReducedCoefs.equals(this.possConstraint(wpb, coefsBis)));
        return degUpdate;
    }

    private BigInteger saturation(BigInteger[] coefs, BigInteger degree, IWatchPb wpb) {
        assert (degree.signum() > 0);
        BigInteger degreeResult = degree;
        boolean isMinimumEqualsToDegree = true;
        int i = 0;
        while (i < coefs.length) {
            int comparison = coefs[i].compareTo(degree);
            if (comparison > 0) {
                if (!this.voc.isFalsified(wpb.get(i))) {
                    this.possReducedCoefs = this.possReducedCoefs.subtract(coefs[i]);
                    this.possReducedCoefs = this.possReducedCoefs.add(degree);
                }
                coefs[i] = degree;
            } else if (comparison < 0 && coefs[i].signum() > 0) {
                isMinimumEqualsToDegree = false;
            }
            ++i;
        }
        if (isMinimumEqualsToDegree && !degree.equals(BigInteger.ONE)) {
            this.possReducedCoefs = BigInteger.ZERO;
            degreeResult = BigInteger.ONE;
            i = 0;
            while (i < coefs.length) {
                if (coefs[i].signum() > 0) {
                    coefs[i] = BigInteger.ONE;
                    if (!this.voc.isFalsified(wpb.get(i))) {
                        this.possReducedCoefs = this.possReducedCoefs.add(BigInteger.ONE);
                    }
                }
                ++i;
            }
        }
        return degreeResult;
    }

    private static boolean positiveCoefs(BigInteger[] coefsCons) {
        BigInteger[] bigIntegerArray = coefsCons;
        int n = coefsCons.length;
        int n2 = 0;
        while (n2 < n) {
            BigInteger coefsCon = bigIntegerArray[n2];
            if (coefsCon.signum() <= 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int getBacktrackLevel(int maxLevel) {
        int indStop = ConflictMap.levelToIndex(maxLevel) - 1;
        int indStart = ConflictMap.levelToIndex(0);
        BigInteger slack = this.computeSlack(0).subtract(this.degree);
        int previous = 0;
        int indLevel = indStart;
        while (indLevel <= indStop) {
            if (this.byLevel[indLevel] != null) {
                int level = ConflictMap.indexToLevel(indLevel);
                assert (this.computeSlack(level).subtract(this.degree).equals(slack));
                if (this.isImplyingLiteralOrdered(level, slack)) break;
                VecInt lits = this.byLevel[indLevel];
                IteratorInt iterator = lits.iterator();
                while (iterator.hasNext()) {
                    int lit = iterator.next();
                    if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) != ConflictMap.indexToLevel(indLevel)) continue;
                    slack = slack.subtract(this.weightedLits.get(lit));
                }
                if (!lits.isEmpty()) {
                    previous = level;
                }
            }
            ++indLevel;
        }
        assert (previous == this.oldGetBacktrackLevel(maxLevel));
        return previous;
    }

    public int oldGetBacktrackLevel(int maxLevel) {
        int litLevel;
        int borneMax = maxLevel;
        assert (this.oldIsAssertive(borneMax));
        int borneMin = -1;
        int i = 0;
        while (i < this.size()) {
            litLevel = this.voc.getLevel(this.weightedLits.getLit(i));
            if (litLevel < borneMax && litLevel > borneMin && this.oldIsAssertive(litLevel)) {
                borneMax = litLevel;
            }
            ++i;
        }
        int retour = 0;
        int i2 = 0;
        while (i2 < this.size()) {
            litLevel = this.voc.getLevel(this.weightedLits.getLit(i2));
            if (litLevel > retour && litLevel < borneMax) {
                retour = litLevel;
            }
            ++i2;
        }
        return retour;
    }

    public void updateSlack(int level) {
        int dl = ConflictMap.levelToIndex(level);
        if (this.byLevel[dl] != null) {
            IteratorInt iterator = this.byLevel[dl].iterator();
            while (iterator.hasNext()) {
                int lit = iterator.next();
                if (!this.voc.isFalsified(lit)) continue;
                this.currentSlack = this.currentSlack.add(this.weightedLits.get(lit));
            }
        }
    }

    void increaseCoef(int lit, BigInteger incCoef) {
        if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.add(incCoef);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(lit))].contains(lit));
        super.increaseCoef(lit, incCoef);
    }

    void decreaseCoef(int lit, BigInteger decCoef) {
        if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(decCoef);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(lit))].contains(lit));
        super.decreaseCoef(lit, decCoef);
    }

    void setCoef(int lit, BigInteger newValue) {
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            if (this.weightedLits.containsKey(lit)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
            }
            this.currentSlack = this.currentSlack.add(newValue);
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        if (!this.weightedLits.containsKey(lit)) {
            if (this.byLevel[indLitLevel] == null) {
                this.byLevel[indLitLevel] = new VecInt();
            }
            this.byLevel[indLitLevel].push(lit);
        }
        assert (this.byLevel[indLitLevel] != null);
        assert (this.byLevel[indLitLevel].contains(lit));
        super.setCoef(lit, newValue);
    }

    void changeCoef(int indLit, BigInteger newValue) {
        int lit = this.weightedLits.getLit(indLit);
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            if (this.weightedLits.containsKey(lit)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
            }
            this.currentSlack = this.currentSlack.add(newValue);
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        assert (this.weightedLits.containsKey(lit));
        assert (this.byLevel[indLitLevel] != null);
        assert (this.byLevel[indLitLevel].contains(lit));
        super.changeCoef(indLit, newValue);
    }

    void removeCoef(int lit) {
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        assert (indLitLevel < this.byLevel.length);
        assert (this.byLevel[indLitLevel] != null);
        assert (this.byLevel[indLitLevel].contains(lit));
        this.byLevel[indLitLevel].remove(lit);
        super.removeCoef(lit);
    }

    private int getLevelByLevel(int lit) {
        int i = 0;
        while (i < this.byLevel.length) {
            if (this.byLevel[i] != null && this.byLevel[i].contains(lit)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean slackIsCorrect(int dl) {
        return this.currentSlack.equals(this.computeSlack(dl));
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            int lit = this.weightedLits.getLit(i);
            stb.append(this.weightedLits.getCoef(i));
            stb.append(".");
            stb.append(Lits.toString(lit));
            stb.append(" ");
            stb.append("[");
            stb.append(this.voc.valueToString(lit));
            stb.append("@");
            stb.append(this.voc.getLevel(lit));
            stb.append("]");
            ++i;
        }
        return String.valueOf(stb.toString()) + " >= " + this.degree;
    }

    public boolean hasBeenReduced() {
        return this.hasBeenReduced;
    }

    public long getNumberOfReductions() {
        return this.numberOfReductions;
    }
}

