/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalMapPBStructure {
    private final IVecInt lits;
    private final IVec<BigInteger> coefs;
    private IVecInt allLits;

    InternalMapPBStructure(IVecInt lits, IVec<BigInteger> coefs) {
        this.lits = lits;
        this.coefs = coefs;
    }

    InternalMapPBStructure(int size) {
        assert (size > 0);
        this.allLits = new VecInt(size, -1);
        this.coefs = new Vec<BigInteger>();
        this.lits = new VecInt();
    }

    InternalMapPBStructure(PBConstr cpb) {
        this.allLits = new VecInt(cpb.getVocabulary().nVars() * 2 + 2, -1);
        this.coefs = new Vec<BigInteger>(cpb.size());
        this.lits = new VecInt(cpb.size());
        int i = 0;
        while (i < cpb.size()) {
            assert (cpb.get(i) != 0);
            assert (cpb.getCoef(i).signum() > 0);
            int lit = cpb.get(i);
            this.lits.push(lit);
            assert (i + 1 == this.lits.size());
            this.allLits.set(lit, i);
            this.coefs.push(cpb.getCoef(i));
            ++i;
        }
    }

    BigInteger get(int lit) {
        assert (this.allLits.get(lit) != -1);
        return this.coefs.get(this.allLits.get(lit));
    }

    int getFromAllLits(int lit) {
        return this.allLits.get(lit);
    }

    int getLit(int indLit) {
        assert (indLit < this.lits.size());
        return this.lits.get(indLit);
    }

    BigInteger getCoef(int indLit) {
        assert (indLit < this.coefs.size());
        return this.coefs.get(indLit);
    }

    boolean containsKey(int lit) {
        return this.allLits.get(lit) != -1;
    }

    int size() {
        return this.lits.size();
    }

    void put(int lit, BigInteger newValue) {
        int indLit = this.allLits.get(lit);
        if (indLit != -1) {
            this.coefs.set(indLit, newValue);
        } else {
            this.lits.push(lit);
            this.coefs.push(newValue);
            this.allLits.set(lit, this.lits.size() - 1);
        }
    }

    void changeCoef(int indLit, BigInteger newValue) {
        assert (indLit <= this.coefs.size());
        this.coefs.set(indLit, newValue);
    }

    void remove(int lit) {
        int indLit = this.allLits.get(lit);
        if (indLit != -1) {
            int tmp = this.lits.last();
            this.coefs.delete(indLit);
            this.lits.delete(indLit);
            this.allLits.set(tmp, indLit);
            this.allLits.set(lit, -1);
        }
    }

    void copyCoefs(IVec<BigInteger> dest) {
        this.coefs.copyTo(dest);
    }

    void copyCoefs(BigInteger[] dest) {
        this.coefs.copyTo(dest);
    }

    void copyLits(IVecInt dest) {
        this.lits.copyTo(dest);
    }

    void copyLits(int[] dest) {
        this.lits.copyTo(dest);
    }
}

