/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ILits;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pseudos {
    public static IDataStructurePB niceCheckedParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) {
        assert (ps.size() != 0 && ps.size() == bigCoefs.size());
        int[] lits = new int[ps.size()];
        ps.copyTo(lits);
        BigInteger[] bc = new BigInteger[bigCoefs.size()];
        bigCoefs.copyTo(bc);
        BigInteger bigDegree = Pseudos.niceCheckedParametersForCompetition(lits, bc, moreThan, bigDeg);
        MapPb mpb = new MapPb(voc.nVars() * 2 + 2);
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.cuttingPlane(lits, bc, bigDegree);
        }
        if (bigDegree.signum() > 0) {
            bigDegree = mpb.saturation();
        }
        if (bigDegree.signum() <= 0) {
            return null;
        }
        return mpb;
    }

    public static BigInteger niceCheckedParametersForCompetition(int[] lits, BigInteger[] bc, boolean moreThan, BigInteger bigDeg) {
        int i;
        BigInteger bigDegree = bigDeg;
        if (!moreThan) {
            i = 0;
            while (i < lits.length) {
                bc[i] = bc[i].negate();
                ++i;
            }
            bigDegree = bigDegree.negate();
        }
        i = 0;
        while (i < bc.length) {
            if (bc[i].signum() < 0) {
                lits[i] = lits[i] ^ 1;
                bc[i] = bc[i].negate();
                bigDegree = bigDegree.add(bc[i]);
            }
            ++i;
        }
        i = 0;
        while (i < bc.length) {
            if (bc[i].compareTo(bigDegree) > 0) {
                bc[i] = bigDegree;
            }
            ++i;
        }
        return bigDegree;
    }

    public static IDataStructurePB niceParameters(IVecInt ps, IVec<BigInteger> bigCoefs, boolean moreThan, BigInteger bigDeg, ILits voc) throws ContradictionException {
        if (ps.size() == 0 && bigDeg.signum() > 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (ps.size() != bigCoefs.size()) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + ps.size() + " coefs=" + bigCoefs.size() + ".");
        }
        return Pseudos.niceCheckedParameters(ps, bigCoefs, moreThan, bigDeg, voc);
    }

    public static BigInteger niceParametersForCompetition(int[] ps, BigInteger[] bigCoefs, boolean moreThan, BigInteger bigDeg) throws ContradictionException {
        if (ps.length == 0 && bigDeg.signum() > 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (ps.length != bigCoefs.length) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + ps.length + " coefs=" + bigCoefs.length + ".");
        }
        return Pseudos.niceCheckedParametersForCompetition(ps, bigCoefs, moreThan, bigDeg);
    }

    public static IVec<BigInteger> toVecBigInt(IVecInt vec) {
        Vec<BigInteger> bigVec = new Vec<BigInteger>(vec.size());
        int i = 0;
        while (i < vec.size()) {
            bigVec.push(BigInteger.valueOf(vec.get(i)));
            ++i;
        }
        return bigVec;
    }

    public static BigInteger toBigInt(int i) {
        return BigInteger.valueOf(i);
    }

    public static ObjectiveFunction normalizeObjective(ObjectiveFunction initial) {
        IVec<BigInteger> initCoeffs = initial.getCoeffs();
        IVecInt initLits = initial.getVars();
        assert (initCoeffs.size() == initLits.size());
        HashMap<Integer, BigInteger> reduced = new HashMap<Integer, BigInteger>();
        int i = 0;
        while (i < initLits.size()) {
            int lit = initLits.get(i);
            BigInteger oldCoef = (BigInteger)reduced.get(lit);
            if (oldCoef == null) {
                reduced.put(lit, initCoeffs.get(i));
            } else {
                reduced.put(lit, oldCoef.add(initCoeffs.get(i)));
            }
            ++i;
        }
        assert (reduced.size() <= initLits.size());
        if (reduced.size() < initLits.size()) {
            VecInt newLits = new VecInt(reduced.size());
            Vec<BigInteger> newCoefs = new Vec<BigInteger>(reduced.size());
            for (Map.Entry entry : reduced.entrySet()) {
                newLits.push((Integer)entry.getKey());
                newCoefs.push((BigInteger)entry.getValue());
            }
            return new ObjectiveFunction(newLits, newCoefs);
        }
        return initial;
    }
}

