/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLexicoHelper<T, C>
extends DependencyHelper<T, C>
implements SolutionFoundListener {
    private final LexicoDecoratorPB lexico;
    private boolean hasASolution;

    public AbstractLexicoHelper(LexicoDecoratorPB lexico) {
        super(new OptToPBSATAdapter(lexico));
        this.lexico = lexico;
        ((OptToPBSATAdapter)this.getSolver()).setSolutionFoundListener(this);
    }

    public AbstractLexicoHelper(LexicoDecoratorPB lexico, boolean explanationEnabled) {
        super(new OptToPBSATAdapter(lexico), explanationEnabled);
        this.lexico = lexico;
        ((OptToPBSATAdapter)this.getSolver()).setSolutionFoundListener(this);
    }

    public AbstractLexicoHelper(LexicoDecoratorPB lexico, boolean explanationEnabled, boolean canonicalOptFunctionEnabled) {
        super(new OptToPBSATAdapter(lexico), explanationEnabled, canonicalOptFunctionEnabled);
        this.lexico = lexico;
        ((OptToPBSATAdapter)this.getSolver()).setSolutionFoundListener(this);
    }

    public void addCriterion(Collection<T> things) {
        VecInt literals = new VecInt(things.size());
        for (T thing : things) {
            literals.push(this.getIntValue(thing));
        }
        this.lexico.addCriterion(literals);
    }

    public void addWeightedCriterion(Collection<WeightedObject<T>> things) {
        VecInt literals = new VecInt(things.size());
        Vec<BigInteger> coefs = new Vec<BigInteger>(things.size());
        for (WeightedObject<T> wo : things) {
            literals.push(this.getIntValue(wo.thing));
            coefs.push(wo.getWeight());
        }
        this.lexico.addCriterion(literals, coefs);
    }

    @Override
    public boolean hasASolution() throws TimeoutException {
        try {
            return super.hasASolution();
        }
        catch (TimeoutException e) {
            if (this.hasASolution) {
                return true;
            }
            throw e;
        }
    }

    @Override
    public boolean hasASolution(IVec<T> assumps) throws TimeoutException {
        try {
            return super.hasASolution(assumps);
        }
        catch (TimeoutException e) {
            if (this.hasASolution) {
                return true;
            }
            throw e;
        }
    }

    @Override
    public boolean hasASolution(Collection<T> assumps) throws TimeoutException {
        try {
            return super.hasASolution(assumps);
        }
        catch (TimeoutException e) {
            if (this.hasASolution) {
                return true;
            }
            throw e;
        }
    }

    public boolean isOptimal() {
        return ((OptToPBSATAdapter)this.getSolver()).isOptimal();
    }

    @Override
    public void onSolutionFound(int[] solution) {
        this.hasASolution = true;
    }

    @Override
    public void onSolutionFound(IVecInt solution) {
        this.hasASolution = true;
    }

    @Override
    public void onUnsatTermination() {
    }
}

