/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class SteppedTimeoutLexicoDecoratorPB
extends LexicoDecoratorPB {
    private static final long serialVersionUID = 1L;

    public SteppedTimeoutLexicoDecoratorPB(IPBSolver solver) {
        super(solver);
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        block9: {
            ((IPBSolver)this.decorated()).setObjectiveFunction((ObjectiveFunction)this.objs.get(this.currentCriterion));
            this.isSolutionOptimal = false;
            try {
                if (!((IPBSolver)this.decorated()).isSatisfiable(assumps, true)) break block9;
                this.prevboolmodel = new boolean[this.nVars()];
                int i = 0;
                while (i < this.nVars()) {
                    this.prevboolmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
                    ++i;
                }
                this.prevfullmodel = ((IPBSolver)this.decorated()).model();
                this.prevmodelwithinternalvars = ((IPBSolver)this.decorated()).modelWithInternalVariables();
                this.calculateObjective();
                return true;
            }
            catch (TimeoutException te) {
                if (this.currentCriterion == this.numberOfCriteria() - 1) {
                    throw te;
                }
                this.mergeCurrentandNextCriteria();
                if (this.prevConstr != null) {
                    super.removeConstr(this.prevConstr);
                    this.prevConstr = null;
                }
                try {
                    this.fixCriterionValue();
                }
                catch (ContradictionException ce) {
                    throw new IllegalStateException(ce);
                }
                if (this.isVerbose()) {
                    System.out.println(String.valueOf(this.getLogPrefix()) + "Partial timeout criterion number " + (this.currentCriterion + 1));
                }
                ++this.currentCriterion;
                this.calculateObjective();
                ((IPBSolver)this.decorated()).expireTimeout();
                return true;
            }
        }
        ((IPBSolver)this.decorated()).expireTimeout();
        return this.manageUnsatCase();
    }

    private void mergeCurrentandNextCriteria() {
        ObjectiveFunction currentObj = (ObjectiveFunction)this.objs.get(this.currentCriterion);
        int currentObjSize = currentObj.getVars().size();
        ObjectiveFunction nextObj = (ObjectiveFunction)this.objs.get(this.currentCriterion + 1);
        int nextObjSize = nextObj.getVars().size();
        VecInt newLits = new VecInt(currentObjSize + nextObjSize);
        currentObj.getVars().copyTo(newLits);
        nextObj.getVars().copyTo(newLits);
        Vec<BigInteger> newCoeffs = new Vec<BigInteger>(currentObjSize + nextObjSize);
        BigInteger coeffFactor = BigInteger.valueOf(nextObjSize).add(BigInteger.ONE);
        Iterator<BigInteger> it = currentObj.getCoeffs().iterator();
        while (it.hasNext()) {
            newCoeffs.push(it.next().multiply(coeffFactor));
        }
        nextObj.getCoeffs().copyTo(newCoeffs);
        this.objs.set(this.currentCriterion + 1, new ObjectiveFunction(newLits, newCoeffs));
    }
}

