/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.PrintWriter;
import org.sat4j.ExitCode;
import org.sat4j.ILauncherMode;
import org.sat4j.core.VecInt;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.Backbone;

final class DecisionMode
implements ILauncherMode {
    private ExitCode exitCode = ExitCode.UNKNOWN;
    private int nbSolutionFound;
    private PrintWriter out;
    private long beginTime;

    DecisionMode() {
    }

    @Override
    public void displayResult(ISolver solver, IProblem problem, ILogAble logger, PrintWriter out, Reader reader, long beginTime, boolean displaySolutionLine) {
        if (solver != null) {
            out.flush();
            double wallclocktime = (double)(System.currentTimeMillis() - beginTime) / 1000.0;
            solver.printStat(out);
            out.println("s " + this.exitCode);
            if (this.exitCode != ExitCode.UNKNOWN && this.exitCode != ExitCode.UNSATISFIABLE) {
                long endpi;
                int[] model = solver.model();
                if (System.getProperty("prime") != null) {
                    int initiallength = model.length;
                    logger.log("returning a prime implicant ...");
                    long beginpi = System.currentTimeMillis();
                    model = solver.primeImplicant();
                    endpi = System.currentTimeMillis();
                    logger.log("removed " + (initiallength - model.length) + " literals");
                    logger.log("pi computation time: " + (endpi - beginpi) + " ms");
                }
                if (System.getProperty("backbone") != null) {
                    logger.log("computing the backbone of the formula ...");
                    long beginpi = System.currentTimeMillis();
                    model = solver.primeImplicant();
                    try {
                        IVecInt backbone = Backbone.instance().compute(solver, model);
                        endpi = System.currentTimeMillis();
                        out.print(solver.getLogPrefix());
                        reader.decode(backbone.toArray(), out);
                        out.println();
                        logger.log("backbone computation time: " + (endpi - beginpi) + " ms");
                    }
                    catch (TimeoutException e) {
                        logger.log("timeout, cannot compute the backbone.");
                    }
                }
                if (this.nbSolutionFound >= 1) {
                    logger.log("Found " + this.nbSolutionFound + " solution(s)");
                } else {
                    out.print("v ");
                    reader.decode(model, out);
                    out.println();
                }
            }
            logger.log("Total wall clock time (in seconds) : " + wallclocktime);
        }
    }

    @Override
    public void solve(IProblem problem, Reader reader, ILogAble logger, PrintWriter out, long beginTime) {
        this.exitCode = ExitCode.UNKNOWN;
        this.out = out;
        this.nbSolutionFound = 0;
        this.beginTime = beginTime;
        try {
            if (problem.isSatisfiable()) {
                if (this.exitCode == ExitCode.UNKNOWN) {
                    this.exitCode = ExitCode.SATISFIABLE;
                }
            } else if (this.exitCode == ExitCode.UNKNOWN) {
                this.exitCode = ExitCode.UNSATISFIABLE;
            }
        }
        catch (TimeoutException e) {
            logger.log("timeout");
        }
    }

    @Override
    public void setIncomplete(boolean isIncomplete) {
    }

    @Override
    public ExitCode getCurrentExitCode() {
        return this.exitCode;
    }

    @Override
    public void onSolutionFound(int[] solution) {
        ++this.nbSolutionFound;
        this.exitCode = ExitCode.SATISFIABLE;
        this.out.printf("c Found solution #%d  (%.2f)s%n", this.nbSolutionFound, (double)(System.currentTimeMillis() - this.beginTime) / 1000.0);
        if (System.getProperty("printallmodels") != null) {
            this.out.println("v " + new VecInt(solution));
        }
    }

    @Override
    public void onSolutionFound(IVecInt solution) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void onUnsatTermination() {
        if (this.exitCode == ExitCode.SATISFIABLE) {
            this.exitCode = ExitCode.OPTIMUM_FOUND;
        }
    }

    @Override
    public void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }
}

