/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.sat4j.specs.ISolver;

public abstract class ASolverFactory<T extends ISolver>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String[] solverNames() {
        Method[] solvers;
        ArrayList<String> l = new ArrayList<String>();
        for (Method solver : solvers = this.getClass().getDeclaredMethods()) {
            if (solver.getParameterTypes().length != 0 || !solver.getName().startsWith("new")) continue;
            l.add(solver.getName().substring(3));
        }
        String[] names = new String[l.size()];
        l.toArray(names);
        return names;
    }

    public T createSolverByName(String solvername) {
        try {
            Class[] paramtypes = new Class[]{};
            Method m = this.getClass().getMethod("new" + solvername, paramtypes);
            return (T)((ISolver)m.invoke(null, (Object[])null));
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (NoSuchMethodException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            System.err.println(e.getLocalizedMessage());
        }
        return null;
    }

    public abstract T defaultSolver();

    public abstract T lightSolver();
}

