/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.Constr;
import org.sat4j.specs.IVec;

class GlucoseLCDS<D extends DataStructureFactory>
implements LearnedConstraintsDeletionStrategy {
    private final Solver<D> solver;
    private static final long serialVersionUID = 1L;
    private int[] flags = new int[0];
    private int flag = 0;
    private final ConflictTimer timer;

    GlucoseLCDS(Solver<D> solver, ConflictTimer timer) {
        this.solver = solver;
        this.timer = timer;
    }

    @Override
    public void reduce(IVec<Constr> learnedConstrs) {
        int j;
        this.solver.sortOnActivity();
        for (int i = j = learnedConstrs.size() / 2; i < learnedConstrs.size(); ++i) {
            Constr c = learnedConstrs.get(i);
            if (c.locked() || c.getActivity() <= 2.0) {
                learnedConstrs.set(j++, this.solver.learnts.get(i));
                continue;
            }
            c.remove(this.solver);
            this.solver.slistener.delete(c);
        }
        if (this.solver.isVerbose()) {
            this.solver.out.log(this.solver.getLogPrefix() + "cleaning " + (learnedConstrs.size() - j) + " clauses out of " + learnedConstrs.size() + " with flag " + this.flag + "/" + this.solver.stats.conflicts);
        }
        this.solver.learnts.shrinkTo(j);
    }

    @Override
    public ConflictTimer getTimer() {
        return this.timer;
    }

    public String toString() {
        return "Glucose learned constraints deletion strategy with timer " + this.timer;
    }

    @Override
    public void init() {
        int howmany = this.solver.voc.nVars();
        if (this.flags.length <= howmany) {
            this.flags = new int[howmany + 1];
        }
        this.flag = 0;
        this.timer.reset();
    }

    @Override
    public void onClauseLearning(Constr constr) {
        int nblevel = this.computeLBD(constr);
        constr.incActivity(nblevel);
    }

    protected int computeLBD(Constr constr) {
        int nblevel = 1;
        ++this.flag;
        for (int i = 1; i < constr.size(); ++i) {
            int currentLevel = this.solver.voc.getLevel(constr.get(i));
            if (this.flags[currentLevel] == this.flag) continue;
            this.flags[currentLevel] = this.flag;
            ++nblevel;
        }
        return nblevel;
    }

    @Override
    public void onConflictAnalysis(Constr reason) {
    }

    @Override
    public void onPropagation(Constr from) {
    }
}

