/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.learning.LimitedLearning;
import org.sat4j.specs.Constr;

public final class PercentLengthLearning<D extends DataStructureFactory>
extends LimitedLearning<D> {
    private static final long serialVersionUID = 1L;
    private int maxpercent;
    private int bound;

    public PercentLengthLearning() {
        this(10);
    }

    public PercentLengthLearning(int percent) {
        this.maxpercent = percent;
    }

    public void setLimit(int percent) {
        this.maxpercent = percent;
    }

    public int getLimit() {
        return this.maxpercent;
    }

    @Override
    public void init() {
        super.init();
        this.setBound(this.lits.realnVars() * this.maxpercent / 100);
    }

    public String toString() {
        return "Limit learning to clauses of size smaller or equal to " + this.maxpercent + "% of the number of variables";
    }

    protected void setBound(int newbound) {
        this.bound = newbound;
    }

    @Override
    protected boolean learningCondition(Constr constr) {
        return constr.size() <= this.bound;
    }
}

