/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.specs.Constr;

public final class MiniSATRestarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private double nofConflicts;
    private SearchParams params;
    private int conflictcount;

    @Override
    public void init(SearchParams theParams, SolverStats stats) {
        this.params = theParams;
        this.nofConflicts = theParams.getInitConflictBound();
        this.conflictcount = 0;
    }

    @Override
    public long nextRestartNumberOfConflict() {
        return Math.round(this.nofConflicts);
    }

    @Override
    public void onRestart() {
        this.nofConflicts *= this.params.getConflictBoundIncFactor();
    }

    public String toString() {
        return "MiniSAT restarts strategy";
    }

    @Override
    public boolean shouldRestart() {
        return (double)this.conflictcount >= this.nofConflicts;
    }

    @Override
    public void onBackjumpToRootLevel() {
        this.conflictcount = 0;
    }

    @Override
    public void reset() {
        this.conflictcount = 0;
    }

    @Override
    public void newConflict() {
        ++this.conflictcount;
    }

    @Override
    public void newLearnedClause(Constr learned, int trailLevel) {
    }
}

