/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import org.sat4j.AbstractLauncher;
import org.sat4j.ILauncherMode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.LanceurPseudo2005;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PBSolverHandle;
import org.sat4j.pb.reader.OPBReader2012;
import org.sat4j.pb.tools.OptimalModelIterator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class LanceurPseudo2007
extends LanceurPseudo2005 {
    private static final long serialVersionUID = 1L;
    private PBSolverHandle handle;

    public LanceurPseudo2007() {
    }

    public LanceurPseudo2007(ASolverFactory<IPBSolver> factory) {
        super(factory);
    }

    @Override
    protected Reader createReader(ISolver theSolver, String problemname) {
        if (problemname.endsWith(".cnf")) {
            return new DimacsReader(theSolver);
        }
        return new OPBReader2012(this.handle);
    }

    @Override
    protected void configureLauncher() {
        this.handle = new PBSolverHandle((IPBSolver)this.solver);
        String all = System.getProperty("all");
        if (all != null) {
            this.feedWithDecorated = true;
            this.solver = new OptimalModelIterator(new OptToPBSATAdapter(this.handle));
            this.setLauncherMode(ILauncherMode.DECISION);
        }
        super.configureLauncher();
    }

    public static void main(String[] args) {
        LanceurPseudo2007 lanceur = new LanceurPseudo2007();
        if (args.length == 0 || args.length > 3) {
            ((AbstractLauncher)lanceur).usage();
            return;
        }
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }
}

