/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.util.Collection;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.LanceurPseudo2007;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.reader.OPBEclipseReader2007;
import org.sat4j.pb.tools.XplainPB;
import org.sat4j.reader.Reader;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class LanceurPseudo2007Eclipse
extends LanceurPseudo2007 {
    XplainPB quickxplain;
    private static final long serialVersionUID = 1L;

    @Override
    protected ISolver configureSolver(String[] args) {
        IPBSolver theSolver = args.length > 1 ? (IPBSolver)SolverFactory.instance().createSolverByName(args[0]) : SolverFactory.newDefault();
        this.quickxplain = new XplainPB(theSolver);
        theSolver = new PseudoOptDecorator(this.quickxplain);
        if (args.length == 3) {
            theSolver.setTimeout(Integer.valueOf(args[1]));
        }
        this.out.println(theSolver.toString("c "));
        return theSolver;
    }

    @Override
    protected Reader createReader(ISolver theSolver, String problemname) {
        return new OPBEclipseReader2007((IPBSolver)theSolver);
    }

    public static void main(String[] args) {
        LanceurPseudo2007Eclipse lanceur = new LanceurPseudo2007Eclipse();
        if (args.length == 0 || args.length > 2) {
            ((AbstractLauncher)lanceur).usage();
            return;
        }
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }

    @Override
    protected void displayResult() {
        super.displayResult();
        ExitCode exitCode = this.getExitCode();
        if (exitCode == ExitCode.UNSATISFIABLE) {
            try {
                Collection<IConstr> explanation = this.quickxplain.explain();
                this.log("Explanation for inconsistency: " + explanation);
            }
            catch (TimeoutException e) {
                this.log("Timeout ! Need more time to complete");
            }
        }
    }
}

