/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.VarMapper;
import org.sat4j.tools.DimacsStringSolver;

public class OPBStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final String FAKE_I_CONSTR_MSG = "Fake IConstr";
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;
    private static final IConstr FAKE_CONSTR = new IConstr(){

        @Override
        public int size() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        @Override
        public boolean learnt() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        @Override
        public double getActivity() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        @Override
        public int get(int i) {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        @Override
        public boolean canBePropagatedMultipleTimes() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        @Override
        public String toString(VarMapper mapper) {
            return OPBStringSolver.FAKE_I_CONSTR_MSG;
        }
    };

    public OPBStringSolver() {
    }

    public OPBStringSolver(int initSize) {
        super(initSize);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        IteratorInt it = assumps.iterator();
        while (it.hasNext()) {
            int p = it.next();
            if (p > 0) {
                this.getOut().append("+1 x" + p + " >= 1 ;\n");
            } else {
                this.getOut().append("-1 x" + -p + " >= 0 ;\n");
            }
            ++this.nbOfConstraints;
        }
        throw new TimeoutException();
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        if (moreThan) {
            return this.addAtLeast(lits, coeffs, d);
        }
        return this.addAtMost(lits, coeffs, d);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.obj = obj;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            int p = iterator.next();
            assert (p != 0);
            if (p > 0) {
                out.append("+1 x" + p + " ");
                continue;
            }
            out.append("-1 x" + -p + " ");
            ++negationweight;
        }
        out.append(">= " + (degree - negationweight) + " ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            int p = iterator.next();
            assert (p != 0);
            if (p > 0) {
                out.append("-1 x" + p + " ");
                continue;
            }
            out.append("+1 x" + -p + " ");
            ++negationweight;
        }
        out.append(">= " + (-degree + negationweight) + " ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            int lit = iterator.next();
            if (lit > 0) {
                out.append("+1 x" + lit + " ");
                continue;
            }
            out.append("-1 x" + -lit + " ");
            ++negationweight;
        }
        out.append(">= " + (1 - negationweight) + " ;\n");
        return FAKE_CONSTR;
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt listOfVariables) {
    }

    @Override
    public String toString() {
        StringBuffer out = this.getOut();
        if (!this.inserted) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("* #variable= ");
            tmp.append(this.nVars());
            tmp.append(" #constraint= ");
            tmp.append(this.nbOfConstraints);
            if (this.obj != null) {
                tmp.append("\n");
                tmp.append("min: ");
                tmp.append(this.obj);
                tmp.append(";");
            }
            out.insert(this.indxConstrObj, tmp.toString());
            this.inserted = true;
        }
        return out.toString();
    }

    @Override
    public String toString(String prefix) {
        return "OPB output solver";
    }

    @Override
    public int newVar(int howmany) {
        StringBuffer out = this.getOut();
        this.setNbVars(howmany);
        this.indxConstrObj = out.length();
        out.append("\n");
        return howmany;
    }

    @Override
    public void setExpectedNumberOfClauses(int nb) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }

    @Override
    public int nConstraints() {
        return this.nbOfConstraints;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        for (int i = 0; i < literals.size(); ++i) {
            out.append(-coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(-degree);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        for (int i = 0; i < literals.size(); ++i) {
            out.append(coeffs.get(i).negate());
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(degree.negate());
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        for (int i = 0; i < literals.size(); ++i) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(degree);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        for (int i = 0; i < literals.size(); ++i) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append(">= ");
        out.append(degree);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt literals, int weight) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        IteratorInt iterator = literals.iterator();
        while (iterator.hasNext()) {
            int p = iterator.next();
            assert (p != 0);
            if (p > 0) {
                out.append("+1 x" + p + " ");
                continue;
            }
            out.append("-1 x" + -p + " ");
            ++negationweight;
        }
        out.append("= " + (weight - negationweight) + " ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        for (int i = 0; i < literals.size(); ++i) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append("= ");
        out.append(weight);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        for (int i = 0; i < literals.size(); ++i) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
        }
        out.append("= ");
        out.append(weight);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }
}

