/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.lang.reflect.Field;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.card.AtLeast;
import org.sat4j.minisat.constraints.cnf.Clauses;
import org.sat4j.minisat.constraints.cnf.LearntBinaryClause;
import org.sat4j.minisat.constraints.cnf.LearntHTClause;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.cnf.OriginalBinaryClause;
import org.sat4j.minisat.constraints.cnf.OriginalHTClause;
import org.sat4j.minisat.constraints.cnf.UnitClause;
import org.sat4j.minisat.core.ILits;
import org.sat4j.pb.constraints.PBContainer;
import org.sat4j.pb.constraints.pb.AtLeastPB;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.Pseudos;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.specs.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public abstract class AbstractPBDataStructureFactory
extends AbstractDataStructureFactory
implements PBDataStructureFactory {
    public static final INormalizer FOR_COMPETITION = new INormalizer(){

        @Override
        public PBContainer nice(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree, ILits voc) throws ContradictionException {
            if (literals.size() != coefs.size()) {
                throw new IllegalArgumentException("Number of coeff and literals are different!!!");
            }
            VecInt cliterals = new VecInt(literals.size());
            literals.copyTo(cliterals);
            Vec ccoefs = new Vec(literals.size());
            coefs.copyTo(ccoefs);
            int i = 0;
            while (i < cliterals.size()) {
                if (((BigInteger)ccoefs.get(i)).equals(BigInteger.ZERO)) {
                    cliterals.delete(i);
                    ccoefs.delete(i);
                    continue;
                }
                if (voc.isSatisfied(cliterals.get(i))) {
                    degree = degree.subtract((BigInteger)ccoefs.get(i));
                    cliterals.delete(i);
                    ccoefs.delete(i);
                    continue;
                }
                if (voc.isFalsified(cliterals.get(i))) {
                    cliterals.delete(i);
                    ccoefs.delete(i);
                    continue;
                }
                ++i;
            }
            int[] theLits = new int[cliterals.size()];
            cliterals.copyTo(theLits);
            BigInteger[] normCoefs = new BigInteger[ccoefs.size()];
            ccoefs.copyTo(normCoefs);
            BigInteger degRes = Pseudos.niceParametersForCompetition(theLits, normCoefs, moreThan, degree);
            return new PBContainer(theLits, normCoefs, degRes);
        }
    };
    public static final INormalizer NO_COMPETITION = new INormalizer(){

        @Override
        public PBContainer nice(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree, ILits voc) throws ContradictionException {
            VecInt cliterals = new VecInt(literals.size());
            literals.copyTo(cliterals);
            Vec<BigInteger> ccoefs = new Vec<BigInteger>(literals.size());
            coefs.copyTo(ccoefs);
            int i = 0;
            while (i < cliterals.size()) {
                if (voc.isSatisfied(cliterals.get(i))) {
                    degree = degree.subtract((BigInteger)ccoefs.get(i));
                    cliterals.delete(i);
                    ccoefs.delete(i);
                    continue;
                }
                if (voc.isFalsified(cliterals.get(i))) {
                    cliterals.delete(i);
                    ccoefs.delete(i);
                    continue;
                }
                ++i;
            }
            IDataStructurePB res = Pseudos.niceParameters(cliterals, ccoefs, moreThan, degree, voc);
            int size = res.size();
            int[] theLits = new int[size];
            BigInteger[] theCoefs = new BigInteger[size];
            res.buildConstraintFromMapPb(theLits, theCoefs);
            BigInteger theDegree = res.getDegree();
            return new PBContainer(theLits, theCoefs, theDegree);
        }
    };
    private INormalizer norm = FOR_COMPETITION;
    private static final long serialVersionUID = 1L;

    protected INormalizer getNormalizer() {
        return this.norm;
    }

    public void setNormalizer(String simp) {
        try {
            Field f = AbstractPBDataStructureFactory.class.getDeclaredField(simp);
            this.norm = (INormalizer)f.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.norm = FOR_COMPETITION;
        }
    }

    public void setNormalizer(INormalizer normalizer) {
        this.norm = normalizer;
    }

    @Override
    public Constr createClause(IVecInt literals) throws ContradictionException {
        IVecInt v = Clauses.sanityCheck(literals, this.getVocabulary(), this.solver);
        if (v == null) {
            return null;
        }
        if (v.size() == 1) {
            return new UnitClause(v.last());
        }
        if (v.size() == 2) {
            return OriginalBinaryClause.brandNewClause(this.solver, this.getVocabulary(), v);
        }
        return OriginalHTClause.brandNewClause(this.solver, this.getVocabulary(), v);
    }

    @Override
    public Constr createUnregisteredClause(IVecInt literals) {
        if (literals.size() == 1) {
            return new UnitClause(literals.last());
        }
        if (literals.size() == 2) {
            return new LearntBinaryClause(literals, this.getVocabulary());
        }
        return new LearntHTClause(literals, this.getVocabulary());
    }

    @Override
    public Constr createCardinalityConstraint(IVecInt literals, int degree) throws ContradictionException {
        return AtLeastPB.atLeastNew(this.solver, this.getVocabulary(), literals, degree);
    }

    @Override
    public Constr createPseudoBooleanConstraint(IVecInt literals, IVec<BigInteger> coefs, boolean moreThan, BigInteger degree) throws ContradictionException {
        PBContainer res = this.getNormalizer().nice(literals, coefs, moreThan, degree, this.getVocabulary());
        return this.constraintFactory(res.lits, res.coefs, res.degree);
    }

    @Override
    public Constr createAtMostPBConstraint(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) throws ContradictionException {
        return this.createPseudoBooleanConstraint(literals, coefs, false, degree);
    }

    @Override
    public Constr createAtLeastPBConstraint(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) throws ContradictionException {
        return this.createPseudoBooleanConstraint(literals, coefs, true, degree);
    }

    @Override
    public Constr createUnregisteredPseudoBooleanConstraint(IDataStructurePB dspb) {
        return this.learntConstraintFactory(dspb);
    }

    @Override
    public Constr createUnregisteredAtLeastConstraint(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.learntAtLeastConstraintFactory(literals, coefs, degree);
    }

    @Override
    public Constr createUnregisteredAtMostConstraint(IVecInt literals, IVec<BigInteger> coefs, BigInteger degree) {
        return this.learntAtMostConstraintFactory(literals, coefs, degree);
    }

    protected abstract Constr constraintFactory(int[] var1, BigInteger[] var2, BigInteger var3) throws ContradictionException;

    protected abstract Constr learntConstraintFactory(IDataStructurePB var1);

    protected abstract Constr learntAtLeastConstraintFactory(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);

    protected abstract Constr learntAtMostConstraintFactory(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);

    @Override
    protected ILits createLits() {
        return new Lits();
    }

    @Override
    public Constr createUnregisteredCardinalityConstraint(IVecInt literals, int degree) {
        return new AtLeast(this.getVocabulary(), literals, degree);
    }

    static interface INormalizer {
        public PBContainer nice(IVecInt var1, IVec<BigInteger> var2, boolean var3, BigInteger var4, ILits var5) throws ContradictionException;
    }
}

