/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IRemoveSatisfiedLiterals;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IteratorInt;

public class ConflictMap
extends MapPb
implements IConflict {
    private final ILits voc;
    protected boolean hasBeenReduced = false;
    protected long numberOfReductions = 0L;
    protected BigInteger currentSlack;
    protected int currentLevel;
    protected VecInt[] byLevel;
    private final IRemoveSatisfiedLiterals rmSatLit;
    protected BigInteger coefMult = BigInteger.ZERO;
    protected BigInteger coefMultCons = BigInteger.ZERO;
    private BigInteger possReducedCoefs = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr cpb, int level) {
        return new ConflictMap(cpb, level);
    }

    public static IConflict createConflict(PBConstr cpb, int level, boolean noRemove) {
        return new ConflictMap(cpb, level, noRemove);
    }

    ConflictMap(PBConstr cpb, int level) {
        this(cpb, level, false);
    }

    ConflictMap(PBConstr cpb, int level, boolean noRemove) {
        super(cpb, level, noRemove);
        this.voc = cpb.getVocabulary();
        this.currentLevel = level;
        this.initStructures();
        this.rmSatLit = noRemove ? new NoRemoveSatisfied() : new RemoveSatisfied();
    }

    private void initStructures() {
        this.currentSlack = BigInteger.ZERO;
        this.byLevel = new VecInt[ConflictMap.levelToIndex(this.currentLevel) + 1];
        for (int i = 0; i < this.size(); ++i) {
            int index;
            int ilit = this.weightedLits.getLit(i);
            int litLevel = this.voc.getLevel(ilit);
            BigInteger tmp = this.weightedLits.getCoef(i);
            if (!(tmp.signum() <= 0 || this.voc.isFalsified(ilit) && litLevel != this.currentLevel)) {
                this.currentSlack = this.currentSlack.add(tmp);
            }
            if (this.byLevel[index = ConflictMap.levelToIndex(litLevel)] == null) {
                this.byLevel[index] = new VecInt();
            }
            this.byLevel[index].push(ilit);
        }
    }

    private static int levelToIndex(int level) {
        return level + 1;
    }

    private static int indexToLevel(int indLevel) {
        return indLevel - 1;
    }

    @Override
    public BigInteger resolve(PBConstr cpb, int litImplied, VarActivityListener val) {
        assert (litImplied > 1);
        int nLitImplied = litImplied ^ 1;
        if (cpb == null || !this.weightedLits.containsKey(nLitImplied)) {
            int litLevel = ConflictMap.levelToIndex(this.voc.getLevel(litImplied));
            int lit = 0;
            if (this.byLevel[litLevel] != null) {
                if (this.byLevel[litLevel].contains(litImplied)) {
                    lit = litImplied;
                    assert (this.weightedLits.containsKey(litImplied));
                } else if (this.byLevel[litLevel].contains(nLitImplied)) {
                    lit = nLitImplied;
                    assert (this.weightedLits.containsKey(nLitImplied));
                }
            }
            if (lit > 0) {
                this.byLevel[litLevel].remove(lit);
                if (this.byLevel[0] == null) {
                    this.byLevel[0] = new VecInt();
                }
                this.byLevel[0].push(lit);
            }
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] coefsCons = null;
        BigInteger degreeCons = cpb.getDegree();
        int ind = 0;
        while (cpb.get(ind) != litImplied) {
            ++ind;
        }
        assert (cpb.get(ind) == litImplied);
        assert (cpb.getCoef(ind) != BigInteger.ZERO);
        if (cpb.getCoef(ind).equals(BigInteger.ONE)) {
            this.coefMultCons = this.weightedLits.get(nLitImplied);
            this.coefMult = BigInteger.ONE;
            degreeCons = degreeCons.multiply(this.coefMultCons);
        } else {
            IWatchPb wpb = (IWatchPb)cpb;
            coefsCons = wpb.getCoefs();
            degreeCons = this.rmSatLit.removeSatisfiedLiteralsFromHigherDecisionLevels(wpb, coefsCons, this.currentLevel, degreeCons);
            if (this.weightedLits.get(nLitImplied).equals(BigInteger.ONE)) {
                this.coefMult = coefsCons[ind];
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else if (coefsCons[ind].equals(BigInteger.ONE)) {
                this.coefMultCons = this.weightedLits.get(nLitImplied);
                this.coefMult = BigInteger.ONE;
                degreeCons = degreeCons.multiply(this.coefMultCons);
            } else {
                assert (ConflictMap.positiveCoefs(coefsCons));
                degreeCons = this.reduceUntilConflict(litImplied, ind, coefsCons, degreeCons, wpb);
                degreeCons = degreeCons.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            if (!this.coefMult.equals(BigInteger.ONE)) {
                for (int i = 0; i < this.size(); ++i) {
                    this.changeCoef(i, this.weightedLits.getCoef(i).multiply(this.coefMult));
                }
            }
        }
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.cuttingPlane(cpb, degreeCons, coefsCons, this.coefMultCons, val);
        assert (!this.weightedLits.containsKey(litImplied));
        assert (!this.weightedLits.containsKey(nLitImplied));
        assert (this.getLevelByLevel(litImplied) == -1);
        assert (this.getLevelByLevel(nLitImplied) == -1);
        assert (this.degree.signum() > 0);
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, BigInteger degreeReduced, IWatchPb wpb) {
        BigInteger slackIndex;
        BigInteger slackResolve = BigInteger.ONE.negate();
        BigInteger slackThis = BigInteger.ZERO;
        BigInteger slackConflict = this.slackConflict();
        BigInteger reducedDegree = degreeReduced;
        BigInteger previousCoefLitImplied = BigInteger.ZERO;
        BigInteger coefLitImplied = this.weightedLits.get(litImplied ^ 1);
        this.possReducedCoefs = this.possConstraint(wpb, reducedCoefs);
        do {
            if (slackResolve.signum() >= 0) {
                assert (slackThis.signum() > 0);
                BigInteger tmp = this.reduceInConstraint(wpb, reducedCoefs, ind, reducedDegree);
                assert (tmp.compareTo(reducedDegree) < 0 && tmp.compareTo(BigInteger.ONE) >= 0);
                reducedDegree = tmp;
            }
            assert (this.weightedLits.get(litImplied ^ 1).signum() > 0);
            assert (reducedCoefs[ind].signum() > 0);
            if (!reducedCoefs[ind].equals(previousCoefLitImplied)) {
                assert (coefLitImplied.equals(this.weightedLits.get(litImplied ^ 1)));
                BigInteger ppcm = ConflictMap.ppcm(reducedCoefs[ind], coefLitImplied);
                assert (ppcm.signum() > 0);
                this.coefMult = ppcm.divide(coefLitImplied);
                this.coefMultCons = ppcm.divide(reducedCoefs[ind]);
                assert (this.coefMultCons.signum() > 0);
                assert (this.coefMult.signum() > 0);
                assert (this.coefMult.multiply(coefLitImplied).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
                previousCoefLitImplied = reducedCoefs[ind];
            }
            slackThis = this.possReducedCoefs.subtract(reducedDegree).multiply(this.coefMultCons);
            assert (slackThis.equals(wpb.slackConstraint(reducedCoefs, reducedDegree).multiply(this.coefMultCons)));
            assert (slackConflict.equals(this.slackConflict()));
            slackIndex = slackConflict.multiply(this.coefMult);
            assert (slackIndex.signum() <= 0);
        } while ((slackResolve = slackThis.add(slackIndex)).signum() >= 0);
        assert (this.coefMult.multiply(this.weightedLits.get(litImplied ^ 1)).equals(this.coefMultCons.multiply(reducedCoefs[ind])));
        return reducedDegree;
    }

    private BigInteger possConstraint(IWatchPb wpb, BigInteger[] theCoefs) {
        BigInteger poss = BigInteger.ZERO;
        for (int i = 0; i < wpb.size(); ++i) {
            if (this.voc.isFalsified(wpb.get(i))) continue;
            assert (theCoefs[i].signum() >= 0);
            poss = poss.add(theCoefs[i]);
        }
        return poss;
    }

    @Override
    public BigInteger slackConflict() {
        BigInteger poss = BigInteger.ZERO;
        for (int i = 0; i < this.size(); ++i) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            if (tmp.signum() == 0 || this.voc.isFalsified(this.weightedLits.getLit(i))) continue;
            assert (tmp.signum() > 0);
            poss = poss.add(tmp);
        }
        return poss.subtract(this.degree);
    }

    public boolean oldIsAssertive(int dl) {
        BigInteger slack = this.computeSlack(dl).subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            int lit = this.weightedLits.getLit(i);
            if (tmp.signum() <= 0 || !this.voc.isUnassigned(lit) && this.voc.getLevel(lit) < dl || slack.compareTo(tmp) >= 0) continue;
            return true;
        }
        return false;
    }

    private BigInteger computeSlack(int dl) {
        BigInteger slack = BigInteger.ZERO;
        for (int i = 0; i < this.size(); ++i) {
            BigInteger tmp = this.weightedLits.getCoef(i);
            int lit = this.weightedLits.getLit(i);
            if (tmp.signum() <= 0 || this.voc.isFalsified(lit) && this.voc.getLevel(lit) < dl) continue;
            slack = slack.add(tmp);
        }
        return slack;
    }

    @Override
    public boolean isAssertive(int dl) {
        assert (dl <= this.currentLevel);
        assert (dl <= this.currentLevel);
        this.currentLevel = dl;
        BigInteger slack = this.currentSlack.subtract(this.degree);
        if (slack.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(slack);
    }

    private boolean isImplyingLiteral(BigInteger slack) {
        int level;
        int lit;
        int unassigned = ConflictMap.levelToIndex(-1);
        if (this.byLevel[unassigned] != null) {
            IteratorInt iterator = this.byLevel[unassigned].iterator();
            while (iterator.hasNext()) {
                lit = iterator.next();
                if (slack.compareTo(this.weightedLits.get(lit)) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(lit);
                return true;
            }
        }
        if (this.byLevel[level = ConflictMap.levelToIndex(this.currentLevel)] != null) {
            IteratorInt iterator = this.byLevel[level].iterator();
            while (iterator.hasNext()) {
                lit = iterator.next();
                BigInteger tmp = this.weightedLits.get(lit);
                if (tmp == null || slack.compareTo(tmp) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(lit);
                return true;
            }
        }
        return false;
    }

    private boolean isImplyingLiteralOrdered(int dl, BigInteger slack) {
        for (int i = 0; i < this.size(); ++i) {
            int ilit = this.weightedLits.getLit(i);
            int litLevel = this.voc.getLevel(ilit);
            if (litLevel < dl && !this.voc.isUnassigned(ilit) || slack.compareTo(this.weightedLits.getCoef(i)) >= 0) continue;
            return true;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    @Override
    public BigInteger reduceInConstraint(IWatchPb wpb, BigInteger[] coefsBis, int indLitImplied, BigInteger degreeBis) {
        int ind;
        assert (degreeBis.compareTo(BigInteger.ONE) > 0);
        int lit = -1;
        int size = wpb.size();
        for (ind = 0; ind < size && lit == -1; ++ind) {
            if (coefsBis[ind].signum() == 0 || !this.voc.isUnassigned(wpb.get(ind))) continue;
            assert (coefsBis[ind].compareTo(degreeBis) < 0);
            lit = ind;
        }
        if (lit == -1) {
            for (ind = 0; ind < size && lit == -1; ++ind) {
                if (coefsBis[ind].signum() == 0 || !this.voc.isSatisfied(wpb.get(ind)) || ind == indLitImplied) continue;
                lit = ind;
            }
        }
        assert (lit != -1);
        assert (lit != indLitImplied);
        BigInteger degUpdate = degreeBis.subtract(coefsBis[lit]);
        this.possReducedCoefs = this.possReducedCoefs.subtract(coefsBis[lit]);
        coefsBis[lit] = BigInteger.ZERO;
        assert (this.possReducedCoefs.equals(this.possConstraint(wpb, coefsBis)));
        degUpdate = this.saturation(coefsBis, degUpdate, wpb);
        assert (coefsBis[indLitImplied].signum() > 0);
        assert (degreeBis.compareTo(degUpdate) > 0);
        assert (this.possReducedCoefs.equals(this.possConstraint(wpb, coefsBis)));
        return degUpdate;
    }

    private BigInteger saturation(BigInteger[] coefs, BigInteger degree, IWatchPb wpb) {
        int i;
        assert (degree.signum() > 0);
        BigInteger degreeResult = degree;
        boolean isMinimumEqualsToDegree = true;
        for (i = 0; i < coefs.length; ++i) {
            int comparison = coefs[i].compareTo(degree);
            if (comparison > 0) {
                if (!this.voc.isFalsified(wpb.get(i))) {
                    this.possReducedCoefs = this.possReducedCoefs.subtract(coefs[i]);
                    this.possReducedCoefs = this.possReducedCoefs.add(degree);
                }
                coefs[i] = degree;
                continue;
            }
            if (comparison >= 0 || coefs[i].signum() <= 0) continue;
            isMinimumEqualsToDegree = false;
        }
        if (isMinimumEqualsToDegree && !degree.equals(BigInteger.ONE)) {
            this.possReducedCoefs = BigInteger.ZERO;
            degreeResult = BigInteger.ONE;
            for (i = 0; i < coefs.length; ++i) {
                if (coefs[i].signum() <= 0) continue;
                coefs[i] = BigInteger.ONE;
                if (this.voc.isFalsified(wpb.get(i))) continue;
                this.possReducedCoefs = this.possReducedCoefs.add(BigInteger.ONE);
            }
        }
        return degreeResult;
    }

    private static boolean positiveCoefs(BigInteger[] coefsCons) {
        for (BigInteger coefsCon : coefsCons) {
            if (coefsCon.signum() >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getBacktrackLevel(int maxLevel) {
        int indStop = ConflictMap.levelToIndex(maxLevel) - 1;
        int indStart = ConflictMap.levelToIndex(0);
        BigInteger slack = this.computeSlack(0).subtract(this.degree);
        int previous = 0;
        for (int indLevel = indStart; indLevel <= indStop; ++indLevel) {
            if (this.byLevel[indLevel] == null) continue;
            int level = ConflictMap.indexToLevel(indLevel);
            assert (this.computeSlack(level).subtract(this.degree).equals(slack));
            if (this.isImplyingLiteralOrdered(level, slack)) break;
            VecInt lits = this.byLevel[indLevel];
            IteratorInt iterator = lits.iterator();
            while (iterator.hasNext()) {
                int lit = iterator.next();
                if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) != ConflictMap.indexToLevel(indLevel)) continue;
                slack = slack.subtract(this.weightedLits.get(lit));
            }
            if (lits.isEmpty()) continue;
            previous = level;
        }
        assert (previous == this.oldGetBacktrackLevel(maxLevel));
        return previous;
    }

    public int oldGetBacktrackLevel(int maxLevel) {
        int litLevel;
        int borneMax = maxLevel;
        int borneMin = -1;
        for (int i = 0; i < this.size(); ++i) {
            litLevel = this.voc.getLevel(this.weightedLits.getLit(i));
            if (litLevel >= borneMax || litLevel <= borneMin || !this.oldIsAssertive(litLevel)) continue;
            borneMax = litLevel;
        }
        int retour = 0;
        for (int i = 0; i < this.size(); ++i) {
            litLevel = this.voc.getLevel(this.weightedLits.getLit(i));
            if (litLevel <= retour || litLevel >= borneMax) continue;
            retour = litLevel;
        }
        return retour;
    }

    @Override
    public void updateSlack(int level) {
        int dl = ConflictMap.levelToIndex(level);
        if (this.byLevel[dl] != null) {
            IteratorInt iterator = this.byLevel[dl].iterator();
            while (iterator.hasNext()) {
                int lit = iterator.next();
                if (!this.voc.isFalsified(lit)) continue;
                this.currentSlack = this.currentSlack.add(this.weightedLits.get(lit));
            }
        }
    }

    @Override
    void increaseCoef(int lit, BigInteger incCoef) {
        if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.add(incCoef);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(lit))].contains(lit));
        super.increaseCoef(lit, incCoef);
    }

    @Override
    void decreaseCoef(int lit, BigInteger decCoef) {
        if (!this.voc.isFalsified(lit) || this.voc.getLevel(lit) == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(decCoef);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(lit))].contains(lit));
        super.decreaseCoef(lit, decCoef);
    }

    @Override
    void setCoef(int lit, BigInteger newValue) {
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            if (this.weightedLits.containsKey(lit)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
            }
            this.currentSlack = this.currentSlack.add(newValue);
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        if (!this.weightedLits.containsKey(lit)) {
            if (this.byLevel[indLitLevel] == null) {
                this.byLevel[indLitLevel] = new VecInt();
            }
            this.byLevel[indLitLevel].push(lit);
        }
        assert (this.byLevel[indLitLevel] != null);
        assert (this.byLevel[indLitLevel].contains(lit));
        super.setCoef(lit, newValue);
    }

    @Override
    void changeCoef(int indLit, BigInteger newValue) {
        int lit = this.weightedLits.getLit(indLit);
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            if (this.weightedLits.containsKey(lit)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
            }
            this.currentSlack = this.currentSlack.add(newValue);
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        assert (this.weightedLits.containsKey(lit));
        assert (this.byLevel[indLitLevel] != null);
        assert (this.byLevel[indLitLevel].contains(lit));
        super.changeCoef(indLit, newValue);
    }

    @Override
    void removeCoef(int lit) {
        int litLevel = this.voc.getLevel(lit);
        if (!this.voc.isFalsified(lit) || litLevel == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(lit));
        }
        int indLitLevel = ConflictMap.levelToIndex(litLevel);
        assert (indLitLevel < this.byLevel.length);
        assert (this.byLevel[indLitLevel] != null);
        assert (this.byLevel[indLitLevel].contains(lit));
        this.byLevel[indLitLevel].remove(lit);
        super.removeCoef(lit);
    }

    private int getLevelByLevel(int lit) {
        for (int i = 0; i < this.byLevel.length; ++i) {
            if (this.byLevel[i] == null || !this.byLevel[i].contains(lit)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean slackIsCorrect(int dl) {
        return this.currentSlack.equals(this.computeSlack(dl));
    }

    @Override
    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            int lit = this.weightedLits.getLit(i);
            stb.append(this.weightedLits.getCoef(i));
            stb.append(".");
            stb.append(Lits.toString(lit));
            stb.append(" ");
            stb.append("[");
            stb.append(this.voc.valueToString(lit));
            stb.append("@");
            stb.append(this.voc.getLevel(lit));
            stb.append("]");
        }
        return stb.toString() + " >= " + this.degree;
    }

    public boolean hasBeenReduced() {
        return this.hasBeenReduced;
    }

    public long getNumberOfReductions() {
        return this.numberOfReductions;
    }

    private class RemoveSatisfied
    implements IRemoveSatisfiedLiterals {
        private RemoveSatisfied() {
        }

        @Override
        public BigInteger removeSatisfiedLiteralsFromHigherDecisionLevels(IWatchPb wpb, BigInteger[] coefsBis, int currentLevel, BigInteger degreeBis) {
            assert (degreeBis.compareTo(BigInteger.ONE) > 0);
            int size = wpb.size();
            BigInteger degUpdate = degreeBis;
            ConflictMap.this.possReducedCoefs = ConflictMap.this.possConstraint(wpb, coefsBis);
            for (int ind = 0; ind < size; ++ind) {
                int p = wpb.get(ind);
                if (coefsBis[ind].signum() == 0 || !ConflictMap.this.voc.isSatisfied(p) || ConflictMap.this.voc.getLevel(p) >= currentLevel) continue;
                degUpdate = degUpdate.subtract(coefsBis[ind]);
                ConflictMap.this.possReducedCoefs = ConflictMap.this.possReducedCoefs.subtract(coefsBis[ind]);
                coefsBis[ind] = BigInteger.ZERO;
                assert (ConflictMap.this.possReducedCoefs.equals(ConflictMap.this.possConstraint(wpb, coefsBis)));
            }
            degUpdate = ConflictMap.this.saturation(coefsBis, degUpdate, wpb);
            assert (degreeBis.compareTo(degUpdate) >= 0);
            assert (ConflictMap.this.possReducedCoefs.equals(ConflictMap.this.possConstraint(wpb, coefsBis)));
            return degUpdate;
        }
    }

    private static class NoRemoveSatisfied
    implements IRemoveSatisfiedLiterals {
        private NoRemoveSatisfied() {
        }

        @Override
        public BigInteger removeSatisfiedLiteralsFromHigherDecisionLevels(IWatchPb wpb, BigInteger[] coefsBis, int currentLevel, BigInteger degreeBis) {
            return degreeBis;
        }
    }
}

