/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.PBConstr;

public class ConflictMapReduceToCard
extends ConflictMap {
    public static final BigInteger MAXVALUE = BigInteger.valueOf(Long.MAX_VALUE);

    public ConflictMapReduceToCard(PBConstr cpb, int level) {
        super(cpb, level);
    }

    public ConflictMapReduceToCard(PBConstr cpb, int level, boolean noRemove) {
        super(cpb, level, noRemove);
    }

    public static IConflict createConflict(PBConstr cpb, int level) {
        return new ConflictMapReduceToCard(cpb, level);
    }

    public static IConflict createConflict(PBConstr cpb, int level, boolean noRemove) {
        return new ConflictMapReduceToCard(cpb, level, noRemove);
    }

    @Override
    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, BigInteger degreeReduced, IWatchPb wpb) {
        degreeReduced = this.reduceToCard(ind, wpb, reducedCoefs, degreeReduced);
        this.coefMultCons = this.weightedLits.get(litImplied ^ 1);
        this.coefMult = BigInteger.ONE;
        ++this.numberOfReductions;
        return degreeReduced;
    }

    private BigInteger reduceToCard(int ind, IWatchPb wpb, BigInteger[] reducedCoefs, BigInteger degreeReduced) {
        BigInteger[] tmpCoefs = new BigInteger[reducedCoefs.length];
        BigInteger maxCoef = BigInteger.ZERO;
        for (int i = 0; i < reducedCoefs.length; ++i) {
            if (i == ind || wpb.getVocabulary().isFalsified(wpb.get(i))) {
                tmpCoefs[i] = BigInteger.ONE;
                if (reducedCoefs[i].compareTo(maxCoef) <= 0) continue;
                maxCoef = reducedCoefs[i];
                continue;
            }
            tmpCoefs[i] = BigInteger.ZERO;
        }
        int cpt = 0;
        for (int i = 0; i < reducedCoefs.length; ++i) {
            if (tmpCoefs[i].equals(BigInteger.ZERO) && reducedCoefs[i].compareTo(maxCoef) > 1) {
                reducedCoefs[i] = BigInteger.ONE;
                ++cpt;
                continue;
            }
            reducedCoefs[i] = tmpCoefs[i];
        }
        return BigInteger.valueOf(cpt + 1);
    }
}

