/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.PBConstr;

public final class ConflictMapReduceToClause
extends ConflictMap {
    public static final BigInteger MAXVALUE = BigInteger.valueOf(Long.MAX_VALUE);

    public ConflictMapReduceToClause(PBConstr cpb, int level) {
        super(cpb, level);
    }

    public ConflictMapReduceToClause(PBConstr cpb, int level, boolean noRemove) {
        super(cpb, level, noRemove);
    }

    public static IConflict createConflict(PBConstr cpb, int level, boolean noRemove) {
        return new ConflictMapReduceToClause(cpb, level, noRemove);
    }

    public static IConflict createConflict(PBConstr cpb, int level) {
        return new ConflictMapReduceToClause(cpb, level);
    }

    @Override
    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, BigInteger degreeReduced, IWatchPb wpb) {
        BigInteger coefLitImplied = this.weightedLits.get(litImplied ^ 1);
        if (reducedCoefs[0].multiply(coefLitImplied).compareTo(MAXVALUE) > 0 || reducedCoefs[ind].multiply(this.weightedLits.getCoef(0)).compareTo(MAXVALUE) > 0) {
            degreeReduced = this.reduceToClause(ind, wpb, reducedCoefs);
            this.coefMultCons = this.weightedLits.get(litImplied ^ 1);
            this.coefMult = BigInteger.ONE;
            ++this.numberOfReductions;
            return degreeReduced;
        }
        return super.reduceUntilConflict(litImplied, ind, reducedCoefs, degreeReduced, wpb);
    }

    private BigInteger reduceToClause(int ind, IWatchPb wpb, BigInteger[] reducedCoefs) {
        for (int i = 0; i < reducedCoefs.length; ++i) {
            reducedCoefs[i] = i == ind || wpb.getVocabulary().isFalsified(wpb.get(i)) ? BigInteger.ONE : BigInteger.ZERO;
        }
        return BigInteger.ONE;
    }
}

