/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.card.MinWatchCard;
import org.sat4j.minisat.core.ILits;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.UnitClausesPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.UnitPropagationListener;

public final class MinWatchCardPB
extends MinWatchCard
implements PBConstr {
    private static final long serialVersionUID = 1L;
    private final BigInteger bigDegree = BigInteger.valueOf(this.degree);
    private boolean learnt = false;

    public MinWatchCardPB(ILits voc, IVecInt ps, boolean moreThan, int degree) {
        super(voc, ps, moreThan, degree);
    }

    public MinWatchCardPB(ILits voc, IVecInt ps, int degree) {
        super(voc, ps, degree);
    }

    @Override
    public BigInteger getCoef(int literal) {
        return BigInteger.ONE;
    }

    @Override
    public BigInteger getDegree() {
        return this.bigDegree;
    }

    @Override
    public BigInteger[] getCoefs() {
        BigInteger[] tmp = new BigInteger[this.size()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = BigInteger.ONE;
        }
        return tmp;
    }

    public static PBConstr normalizedMinWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, int degree) throws ContradictionException {
        return MinWatchCardPB.minWatchCardPBNew(s, voc, ps, true, degree, true);
    }

    public static PBConstr minWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, boolean moreThan, int degree) throws ContradictionException {
        return MinWatchCardPB.minWatchCardPBNew(s, voc, ps, moreThan, degree, false);
    }

    private static PBConstr minWatchCardPBNew(UnitPropagationListener s, ILits voc, IVecInt ps, boolean moreThan, int degree, boolean normalized) throws ContradictionException {
        int mydegree = degree + MinWatchCardPB.linearisation(voc, ps);
        if (ps.size() < mydegree) {
            throw new ContradictionException();
        }
        if (ps.size() == 0 && mydegree > 0) {
            throw new ContradictionException();
        }
        if (ps.size() == mydegree || ps.size() <= 0) {
            for (int i = 0; i < ps.size(); ++i) {
                if (s.enqueue(ps.get(i))) continue;
                throw new ContradictionException();
            }
            return new UnitClausesPB(ps);
        }
        MinWatchCardPB retour = null;
        retour = normalized ? new MinWatchCardPB(voc, ps, mydegree) : new MinWatchCardPB(voc, ps, moreThan, mydegree);
        if (retour.bigDegree.signum() <= 0) {
            return null;
        }
        retour.computeWatches();
        return (MinWatchCardPB)retour.computePropagation(s);
    }

    @Override
    public boolean learnt() {
        return this.learnt;
    }

    @Override
    public void setLearnt() {
        this.learnt = true;
    }

    @Override
    public void register() {
        assert (this.learnt);
        this.computeWatches();
    }

    @Override
    public void assertConstraint(UnitPropagationListener s) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getVocabulary().isUnassigned(this.get(i))) continue;
            boolean ret = s.enqueue(this.get(i), this);
            assert (ret);
        }
    }

    @Override
    public IVecInt computeAnImpliedClause() {
        return null;
    }
}

