/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolver;
import org.sat4j.specs.Constr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.TimeoutException;

public class PBSolverCP
extends PBSolver {
    private static final long serialVersionUID = 1L;
    protected boolean noRemove = true;
    private final IVec<String> conflictVariables = new Vec<String>();
    private final IVec<String> conflictConstraints = new Vec<String>();

    public PBSolverCP(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, IOrder order) {
        super(learner, dsf, new SearchParams(1.5, 100), order, (RestartStrategy)new MiniSATRestarts());
    }

    public PBSolverCP(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, SearchParams params, IOrder order, RestartStrategy restarter) {
        super(learner, dsf, params, order, restarter);
    }

    public PBSolverCP(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, SearchParams params, IOrder order) {
        super(learner, dsf, params, order, (RestartStrategy)new MiniSATRestarts());
    }

    public PBSolverCP(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, IOrder order, boolean noRemove) {
        this(learner, dsf, order);
        this.noRemove = noRemove;
    }

    public PBSolverCP(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, SearchParams params, IOrder order, RestartStrategy restarter, boolean noRemove) {
        this(learner, dsf, params, order, restarter);
        this.noRemove = noRemove;
    }

    public PBSolverCP(LearningStrategy<PBDataStructureFactory> learner, PBDataStructureFactory dsf, SearchParams params, IOrder order, boolean noRemove) {
        this(learner, dsf, params, order);
        this.noRemove = noRemove;
    }

    @Override
    public void analyze(Constr myconfl, Pair results) throws TimeoutException {
        if (this.someCriteria()) {
            this.analyzeCP(myconfl, results);
        } else {
            super.analyze(myconfl, results);
        }
    }

    public void analyzeCP(Constr myconfl, Pair results) throws TimeoutException {
        int litImplied = this.trail.last();
        int currentLevel = this.voc.getLevel(litImplied);
        IConflict confl = this.chooseConflict((PBConstr)myconfl, currentLevel);
        assert (confl.slackConflict().signum() < 0);
        while (!confl.isAssertive(currentLevel)) {
            if (!this.undertimeout) {
                throw new TimeoutException();
            }
            PBConstr constraint = (PBConstr)this.voc.getReason(litImplied);
            confl.resolve(constraint, litImplied, this);
            this.updateNumberOfReductions(confl);
            assert (confl.slackConflict().signum() <= 0);
            if (this.trail.size() == 1) break;
            this.undoOne();
            if (this.decisionLevel() == 0) break;
            litImplied = this.trail.last();
            if (this.voc.getLevel(litImplied) != currentLevel) {
                this.trailLim.pop();
                this.slistener.backtracking(LiteralsUtils.toDimacs(litImplied));
                confl.updateSlack(this.voc.getLevel(litImplied));
            }
            assert (this.voc.getLevel(litImplied) <= currentLevel);
            currentLevel = this.voc.getLevel(litImplied);
            assert (confl.slackIsCorrect(currentLevel));
            assert (currentLevel == this.decisionLevel());
            assert (litImplied > 1);
        }
        assert (confl.isAssertive(currentLevel) || this.trail.size() == 1 || this.decisionLevel() == 0);
        assert (currentLevel == this.decisionLevel());
        this.undoOne();
        this.qhead = this.trail.size();
        this.updateNumberOfReducedLearnedConstraints(confl);
        if (confl.size() == 0 || (this.decisionLevel() == 0 || this.trail.size() == 0) && confl.slackConflict().signum() < 0) {
            results.reason = null;
            results.backtrackLevel = -1;
            return;
        }
        PBConstr resConstr = (PBConstr)((PBDataStructureFactory)this.dsfactory).createUnregisteredPseudoBooleanConstraint(confl);
        results.reason = resConstr;
        if (this.decisionLevel() == 0 || this.trail.size() == 0 && confl.getBacktrackLevel(currentLevel) > 0) {
            results.backtrackLevel = -1;
            results.reason = null;
        } else {
            results.backtrackLevel = confl.getBacktrackLevel(currentLevel);
        }
    }

    protected IConflict chooseConflict(PBConstr myconfl, int level) {
        return ConflictMap.createConflict(myconfl, level, this.noRemove);
    }

    @Override
    public String toString(String prefix) {
        return prefix + "Cutting planes based inference (" + this.getClass().getName() + ")" + (this.noRemove ? "" : " - removing satisfied literals at a higher level before CP -") + "\n" + super.toString(prefix);
    }

    void initExplanation() {
        this.conflictVariables.clear();
        this.conflictConstraints.clear();
    }

    boolean someCriteria() {
        return true;
    }

    protected void updateNumberOfReductions(IConflict confl) {
    }

    protected void updateNumberOfReducedLearnedConstraints(IConflict confl) {
    }
}

