/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.multiobjective;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IIntegerPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.multiobjective.IMultiObjOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public abstract class AbstractLinMultiObjOptimizer
extends PseudoOptDecorator
implements IMultiObjOptimizationProblem {
    private static final long serialVersionUID = 1L;
    protected final List<ObjectiveFunction> objs = new ArrayList<ObjectiveFunction>();
    protected boolean initConstraintsSet = false;
    protected final IIntegerPBSolver integerSolver;

    public AbstractLinMultiObjOptimizer(IIntegerPBSolver solver) {
        super(solver);
        this.integerSolver = solver;
    }

    @Override
    public void addObjectiveFunction(ObjectiveFunction obj) {
        this.objs.add(obj);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objf) {
        this.addObjectiveFunction(objf);
    }

    @Override
    public BigInteger[] getObjectiveValues() {
        Object[] objValues = new BigInteger[this.objs.size()];
        for (int i = 0; i < this.objs.size(); ++i) {
            objValues[i] = this.objs.get(i).calculateDegree(this);
        }
        Arrays.sort(objValues);
        return objValues;
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        boolean res;
        if (!this.initConstraintsSet) {
            this.setInitConstraints();
            this.setGlobalObj();
            this.initConstraintsSet = true;
        }
        if ((res = super.admitABetterSolution(assumps)) && this.isVerbose()) {
            System.out.println(this.getLogPrefix() + "Current objective functions values: " + Arrays.toString(this.getObjectiveValues()));
        }
        return res;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    protected abstract void setInitConstraints();

    protected abstract void setGlobalObj();
}

