/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.multiobjective;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.tools.ManyCorePB;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

public class CriterionOptimumComputer<S extends IPBSolver> {
    private final ManyCorePB<S> solvers;
    private final List<ObjectiveFunction> objs = new ArrayList<ObjectiveFunction>();
    private BigInteger[] opts;
    protected Semaphore lock;
    protected boolean timeoutOccured = false;

    public CriterionOptimumComputer(ManyCorePB<S> solvers) {
        this.solvers = solvers;
    }

    public void addObjectiveFunction(ObjectiveFunction obj) {
        this.objs.add(obj);
    }

    public void addObjectiveFunctions(Collection<ObjectiveFunction> objs) {
        this.objs.addAll(objs);
    }

    public void compute() {
        this.opts = new BigInteger[this.objs.size()];
        this.lock = new Semaphore(this.objs.size());
        this.timeoutOccured = false;
        for (int i = 0; i < this.objs.size(); ++i) {
            OptToPBSATAdapter optimizer = new OptToPBSATAdapter(new PseudoOptDecorator((IPBSolver)this.solvers.getSolvers().get(i)));
            optimizer.setObjectiveFunction(this.objs.get(i));
            optimizer.setSolutionFoundListener(new OptimumValueWriter(this, i));
            new SolverLauncher(optimizer).start();
            try {
                this.lock.acquire();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public void expireAll() {
        for (int i = 0; i < this.objs.size(); ++i) {
            ((IPBSolver)this.solvers.getSolvers().get(i)).expireTimeout();
        }
        this.opts = null;
    }

    public boolean timeoutOccured() {
        return this.timeoutOccured;
    }

    public BigInteger[] getOptimums() {
        return this.opts;
    }

    public void waitForSolvers() {
        try {
            this.lock.acquire(this.objs.size());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    class SolverLauncher
    extends Thread {
        private final IPBSolver solver;

        SolverLauncher(IPBSolver solver) {
            this.solver = solver;
        }

        @Override
        public void run() {
            try {
                this.solver.isSatisfiable();
            }
            catch (TimeoutException e) {
                CriterionOptimumComputer.this.timeoutOccured = true;
                CriterionOptimumComputer.this.lock.release();
            }
        }
    }

    class OptimumValueWriter
    implements SolutionFoundListener {
        private final CriterionOptimumComputer<S> coc;
        private final int solverIndex;

        OptimumValueWriter(CriterionOptimumComputer<S> coc, int solverIndex) {
            this.coc = coc;
            this.solverIndex = solverIndex;
        }

        @Override
        public synchronized void onSolutionFound(int[] solution) {
            ((CriterionOptimumComputer)this.coc).opts[this.solverIndex] = ((ObjectiveFunction)this.coc.objs.get(this.solverIndex)).calculateDegree((RandomAccessModel)this.coc.solvers.getSolvers().get(this.solverIndex));
        }

        @Override
        public synchronized void onSolutionFound(IVecInt solution) {
            ((CriterionOptimumComputer)this.coc).opts[this.solverIndex] = ((ObjectiveFunction)this.coc.objs.get(this.solverIndex)).calculateDegree((RandomAccessModel)this.coc.solvers.getSolvers().get(this.solverIndex));
        }

        @Override
        public synchronized void onUnsatTermination() {
            this.coc.lock.release();
        }
    }
}

