/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.sat4j.pb.OPBStringSolver;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;

public class DimacsToOpb {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage : dimacs2opb filename.cnf");
            return;
        }
        String cnfFileName = args[0];
        assert (cnfFileName.endsWith("cnf"));
        String opbFileName = cnfFileName.replace("cnf", "opb");
        OPBStringSolver solver = new OPBStringSolver();
        DimacsReader reader = new DimacsReader(solver);
        try {
            reader.parseInstance(cnfFileName);
            PrintWriter out = new PrintWriter(new FileWriter(opbFileName));
            out.println(((Object)solver).toString());
            out.close();
        }
        catch (ParseFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ContradictionException e) {
            e.printStackTrace();
        }
    }
}

