/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.CombinationIterator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.SolverDecorator;

public class PBAdapter
extends SolverDecorator<ISolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;

    public PBAdapter(ISolver solver) {
        super(solver);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        return moreThan ? this.addAtLeast(lits, coeffs, d) : this.addAtMost(lits, coeffs, d);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        BigInteger coeffsSum = BigInteger.ZERO;
        VecInt newLiterals = new VecInt(literals.size());
        IteratorInt it = literals.iterator();
        while (it.hasNext()) {
            newLiterals.push(-it.next());
        }
        VecInt newCoeffs = new VecInt(coeffs.size());
        IteratorInt it2 = coeffs.iterator();
        while (it2.hasNext()) {
            int c = it2.next();
            newCoeffs.push(c);
            coeffsSum = coeffsSum.add(BigInteger.valueOf(c));
        }
        int newDegree = coeffsSum.intValue() - degree;
        return this.addAtLeast((IVecInt)newLiterals, newCoeffs, newDegree);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        BigInteger coeffsSum = BigInteger.ZERO;
        VecInt newLiterals = new VecInt(literals.size());
        IteratorInt it = literals.iterator();
        while (it.hasNext()) {
            newLiterals.push(-it.next());
        }
        Vec<BigInteger> newCoeffs = new Vec<BigInteger>(coeffs.size());
        Iterator<BigInteger> it2 = coeffs.iterator();
        while (it2.hasNext()) {
            BigInteger c = it2.next();
            newCoeffs.push(c);
            coeffsSum = coeffsSum.add(c);
        }
        BigInteger newDegree = coeffsSum.subtract(degree);
        return this.addAtLeast((IVecInt)newLiterals, newCoeffs, newDegree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        this.assertConstraintIsCard(coeffs);
        HashSet<Integer> negLitsSet = new HashSet<Integer>(literals.size());
        IteratorInt it = literals.iterator();
        while (it.hasNext()) {
            negLitsSet.add(-it.next());
        }
        int clausesDegree = literals.size() - degree + 1;
        ConstrGroup group = new ConstrGroup(false);
        CombinationIterator combIt = new CombinationIterator(literals.size() - degree, negLitsSet);
        for (Set<Integer> comb : combIt) {
            IteratorInt it2 = literals.iterator();
            while (it2.hasNext()) {
                int lit = it2.next();
                if (comb.contains(-lit)) continue;
                VecInt clause = new VecInt(clausesDegree);
                clause.push(lit);
                for (Integer negLit : comb) {
                    clause.push(-negLit.intValue());
                }
                group.add(this.addClause(clause));
            }
        }
        return group;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        this.assertConstraintIsCard(coeffs);
        HashSet<Integer> negLitsSet = new HashSet<Integer>(literals.size());
        IteratorInt it = literals.iterator();
        while (it.hasNext()) {
            negLitsSet.add(-it.next());
        }
        int clausesDegree = literals.size() - degree.intValue() + 1;
        ConstrGroup group = new ConstrGroup(false);
        CombinationIterator combIt = new CombinationIterator(literals.size() - degree.intValue(), negLitsSet);
        for (Set<Integer> comb : combIt) {
            IteratorInt it2 = literals.iterator();
            while (it2.hasNext()) {
                int lit = it2.next();
                if (comb.contains(-lit)) continue;
                VecInt clause = new VecInt(clausesDegree);
                clause.push(lit);
                for (Integer negLit : comb) {
                    clause.push(-negLit.intValue());
                }
                group.add(this.addClause(clause));
            }
        }
        return group;
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addAtLeast(literals, coeffs, weight));
        group.add(this.addAtMost(literals, coeffs, weight));
        return group;
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        ConstrGroup group = new ConstrGroup(false);
        group.add(this.addAtLeast(literals, coeffs, weight));
        group.add(this.addAtMost(literals, coeffs, weight));
        return group;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        if (obj == null) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return null;
    }

    private void assertConstraintIsCard(IVecInt weights) {
        IteratorInt it = weights.iterator();
        while (it.hasNext()) {
            if (it.next() == 1) continue;
            throw new UnsupportedOperationException();
        }
    }

    private void assertConstraintIsCard(IVec<BigInteger> weights) {
        Iterator<BigInteger> it = weights.iterator();
        while (it.hasNext()) {
            if (it.next().compareTo(BigInteger.ONE) == 0) continue;
            throw new UnsupportedOperationException();
        }
    }
}

