/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.sat4j.core.VecInt;
import org.sat4j.reader.EfficientScanner;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.GateTranslator;

public class AAGReader
extends Reader {
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private final GateTranslator solver;
    private int maxvarid;
    private int nbinputs;

    AAGReader(ISolver s) {
        this.solver = new GateTranslator(s);
    }

    @Override
    public String decode(int[] model) {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < this.nbinputs; ++i) {
            stb.append(model[i] > 0 ? 1 : 0);
        }
        return stb.toString();
    }

    @Override
    public void decode(int[] model, PrintWriter out) {
        for (int i = 0; i < this.nbinputs; ++i) {
            out.print(model[i] > 0 ? 1 : 0);
        }
    }

    @Override
    public IProblem parseInstance(InputStream in) throws ParseFormatException, ContradictionException, IOException {
        EfficientScanner scanner = new EfficientScanner(in);
        String prefix = scanner.next();
        if (!"aag".equals(prefix)) {
            throw new ParseFormatException("AAG format only!");
        }
        this.maxvarid = scanner.nextInt();
        this.nbinputs = scanner.nextInt();
        int nblatches = scanner.nextInt();
        int nboutputs = scanner.nextInt();
        if (nboutputs > 1) {
            throw new ParseFormatException("CNF conversion allowed for single output circuit only!");
        }
        int nbands = scanner.nextInt();
        this.solver.newVar(this.maxvarid + 1);
        this.solver.setExpectedNumberOfClauses(3 * nbands + 2);
        this.readInput(this.nbinputs, scanner);
        assert (nblatches == 0);
        if (nboutputs > 0) {
            int output0 = this.readOutput(nboutputs, scanner);
            this.readAnd(nbands, output0, scanner);
        }
        return this.solver;
    }

    private void readAnd(int nbands, int output0, EfficientScanner scanner) throws ContradictionException, IOException, ParseFormatException {
        for (int i = 0; i < nbands; ++i) {
            int lhs = scanner.nextInt();
            int rhs0 = scanner.nextInt();
            int rhs1 = scanner.nextInt();
            this.solver.and(this.toDimacs(lhs), this.toDimacs(rhs0), this.toDimacs(rhs1));
        }
        this.solver.gateTrue(this.maxvarid + 1);
        this.solver.gateTrue(this.toDimacs(output0));
    }

    private int toDimacs(int v) {
        if (v == 0) {
            return -(this.maxvarid + 1);
        }
        if (v == 1) {
            return this.maxvarid + 1;
        }
        int var = v >> 1;
        if ((v & 1) == 0) {
            return var;
        }
        return -var;
    }

    private int readOutput(int nboutputs, EfficientScanner scanner) throws IOException, ParseFormatException {
        VecInt outputs = new VecInt(nboutputs);
        for (int i = 0; i < nboutputs; ++i) {
            outputs.push(scanner.nextInt());
        }
        return outputs.get(0);
    }

    private IVecInt readInput(int numberOfInputs, EfficientScanner scanner) throws IOException, ParseFormatException {
        VecInt inputs = new VecInt(numberOfInputs);
        for (int i = 0; i < numberOfInputs; ++i) {
            inputs.push(scanner.nextInt());
        }
        return inputs;
    }
}

