/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.Iterator;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.AbstractMinimalModel;
import org.sat4j.tools.SolutionFoundListener;

public class Minimal4CardinalityModel
extends AbstractMinimalModel {
    private static final long serialVersionUID = 1L;
    private int[] prevfullmodel;

    public Minimal4CardinalityModel(ISolver solver) {
        super(solver);
    }

    public Minimal4CardinalityModel(ISolver solver, IVecInt p, SolutionFoundListener modelListener) {
        super(solver, p, modelListener);
    }

    public Minimal4CardinalityModel(ISolver solver, IVecInt p) {
        super(solver, p);
    }

    public Minimal4CardinalityModel(ISolver solver, SolutionFoundListener modelListener) {
        super(solver, modelListener);
    }

    @Override
    public int[] model() {
        int[] prevmodel = null;
        IConstr lastOne = null;
        VecInt literals = new VecInt(this.pLiterals.size());
        Iterator iterator = this.pLiterals.iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            literals.push(p);
        }
        try {
            do {
                this.prevfullmodel = super.modelWithInternalVariables();
                prevmodel = super.model();
                int counter = 0;
                for (int q : this.prevfullmodel) {
                    if (!this.pLiterals.contains(q)) continue;
                    ++counter;
                }
                lastOne = this.addAtMost(literals, counter - 1);
            } while (this.isSatisfiable());
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Solver timed out");
        }
        catch (ContradictionException contradictionException) {
            // empty catch block
        }
        if (lastOne != null) {
            this.removeConstr(lastOne);
        }
        return prevmodel;
    }

    @Override
    public int[] modelWithInternalVariables() {
        this.model();
        return this.prevfullmodel;
    }
}

