/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class ModelIterator
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    protected boolean trivialfalsity = false;
    private final long bound;
    protected long nbModelFound = 0L;

    public ModelIterator(ISolver solver) {
        this(solver, Long.MAX_VALUE);
    }

    public ModelIterator(ISolver solver, long bound) {
        super(solver);
        this.bound = bound;
    }

    @Override
    public int[] model() {
        int[] last = super.model();
        ++this.nbModelFound;
        try {
            this.discardCurrentModel();
        }
        catch (ContradictionException e) {
            this.trivialfalsity = true;
        }
        return last;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        if (this.trivialfalsity || this.nbModelFound >= this.bound) {
            this.expireTimeout();
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(true);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        if (this.trivialfalsity || this.nbModelFound >= this.bound) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(assumps, true);
    }

    @Override
    public void reset() {
        this.trivialfalsity = false;
        this.nbModelFound = 0L;
        super.reset();
    }

    @Override
    public int[] primeImplicant() {
        int[] last = super.primeImplicant();
        this.nbModelFound = (long)((double)this.nbModelFound + Math.pow(2.0, this.nVars() - last.length));
        VecInt clause = new VecInt(last.length);
        for (int q : last) {
            clause.push(-q);
        }
        try {
            this.addBlockingClause(clause);
        }
        catch (ContradictionException e) {
            this.trivialfalsity = true;
        }
        return last;
    }

    public long numberOfModelsFoundSoFar() {
        return this.nbModelFound;
    }
}

