/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.Collection;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.AbstractClauseSelectorSolver;

public class NegationDecorator<T extends ISolver>
extends AbstractClauseSelectorSolver<T> {
    private static final long serialVersionUID = 1L;
    private final Collection<Integer> addedVars = new ArrayList<Integer>();

    public NegationDecorator(T decorated) {
        super(decorated);
        this.internalState();
    }

    @Override
    public IConstr addClause(IVecInt literals) throws ContradictionException {
        int newVar = this.createNewVar(literals);
        VecInt clause = new VecInt(2);
        clause.push(newVar);
        ConstrGroup group = new ConstrGroup();
        IteratorInt it = literals.iterator();
        while (it.hasNext()) {
            clause.push(-it.next());
            group.add(super.addClause(clause));
            clause.pop();
        }
        this.addedVars.add(newVar);
        return group;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public IConstr addExactly(IVecInt literals, int n) throws ContradictionException {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        VecInt vars = new VecInt();
        for (int var : this.getAddedVars()) {
            vars.push(var);
        }
        try {
            boolean returnValue;
            IConstr constr = super.addClause(vars);
            try {
                returnValue = super.isSatisfiable(assumps, global);
            }
            finally {
                this.removeConstr(constr);
            }
            return returnValue;
        }
        catch (ContradictionException e) {
            return false;
        }
    }

    @Override
    public Collection<Integer> getAddedVars() {
        return this.addedVars;
    }
}

