/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class PseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private BigInteger objectiveValue;
    private int[] prevmodel;
    private int[] prevmodelwithadditionalvars;
    private boolean[] prevfullmodel;
    private IConstr previousPBConstr;
    private boolean isSolutionOptimal;

    public PseudoOptDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, bl);
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        boolean bl2 = super.isSatisfiable(iVecInt, true);
        if (bl2) {
            this.prevmodel = super.model();
            this.prevmodelwithadditionalvars = super.modelWithInternalVariables();
            this.prevfullmodel = new boolean[this.nVars()];
            for (int i = 0; i < this.nVars(); ++i) {
                this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
            }
        } else if (this.previousPBConstr != null) {
            ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
            this.previousPBConstr = null;
        }
        return bl2;
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.isSatisfiable(iVecInt, true);
    }

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(objectiveFunction);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        try {
            this.isSolutionOptimal = false;
            boolean bl = super.isSatisfiable(iVecInt, true);
            if (bl) {
                this.prevmodel = super.model();
                this.prevmodelwithadditionalvars = super.modelWithInternalVariables();
                this.prevfullmodel = new boolean[this.nVars()];
                for (int i = 0; i < this.nVars(); ++i) {
                    this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
                }
                if (((IPBSolver)this.decorated()).getObjectiveFunction() != null) {
                    this.calculateObjective();
                }
            } else {
                this.isSolutionOptimal = true;
                if (this.previousPBConstr != null) {
                    ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                    this.previousPBConstr = null;
                }
            }
            return bl;
        }
        catch (TimeoutException timeoutException) {
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
            throw timeoutException;
        }
    }

    public boolean hasNoObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction() == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        if (((IPBSolver)this.decorated()).getObjectiveFunction() == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = ((IPBSolver)this.decorated()).getObjectiveFunction().calculateDegree((ISolver)this.decorated());
        return this.getObjectiveValue();
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.previousPBConstr != null) {
            super.removeSubsumedConstr(this.previousPBConstr);
        }
        if (((IPBSolver)this.decorated()).getObjectiveFunction() != null && this.objectiveValue != null) {
            this.previousPBConstr = super.addPseudoBoolean(((IPBSolver)this.decorated()).getObjectiveFunction().getVars(), ((IPBSolver)this.decorated()).getObjectiveFunction().getCoeffs(), false, this.objectiveValue.subtract(BigInteger.ONE));
        }
    }

    public void reset() {
        this.previousPBConstr = null;
        super.reset();
    }

    public int[] model() {
        return this.prevmodel;
    }

    public boolean model(int n) {
        return this.prevfullmodel[n - 1];
    }

    public String toString(String string) {
        return string + "Pseudo Boolean Optimization by upper bound\n" + super.toString(string);
    }

    public Number getObjectiveValue() {
        return this.objectiveValue.add(((IPBSolver)this.decorated()).getObjectiveFunction().getCorrection());
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        super.addPseudoBoolean(((IPBSolver)this.decorated()).getObjectiveFunction().getVars(), ((IPBSolver)this.decorated()).getObjectiveFunction().getCoeffs(), false, (BigInteger)number);
    }

    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }

    public int[] modelWithInternalVariables() {
        return this.prevmodelwithadditionalvars;
    }
}

