/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.ClauseOnlyLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;
import org.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import org.sat4j.minisat.orders.UserFixedPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.ArminRestarts;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OPBStringSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.CompetMinHTmixedClauseCardConstrDataStructureFactory;
import org.sat4j.pb.constraints.CompetResolutionMinPBLongMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBLongMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBLongMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBLongMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBLongMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxDataStructure;
import org.sat4j.pb.constraints.PBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMinDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinDataStructure;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolver;
import org.sat4j.pb.core.PBSolverCP;
import org.sat4j.pb.core.PBSolverCautious;
import org.sat4j.pb.core.PBSolverClause;
import org.sat4j.pb.core.PBSolverResCP;
import org.sat4j.pb.core.PBSolverResolution;
import org.sat4j.pb.core.PBSolverWithImpliedClause;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.pb.tools.ManyCorePB;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverFactory
extends ASolverFactory<IPBSolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static PBSolverResolution newPBResAllPB() {
        return SolverFactory.newPBRes(new PBMaxDataStructure());
    }

    public static PBSolverCP newPBCPAllPB() {
        return SolverFactory.newPBCP(new PBMaxDataStructure());
    }

    public static IPBSolver newOPBStringSolver() {
        return new OPBStringSolver();
    }

    public static PBSolverCP newPBCPMixedConstraints() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure());
    }

    public static PBSolverCP newPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsMinObjective() {
        return SolverFactory.newPBCP(new PBMinClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsLongMaxObjective() {
        return SolverFactory.newPBCP(new PBLongMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsLongMinObjective() {
        return SolverFactory.newPBCP(new PBLongMinClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning<PBDataStructureFactory> clauseOnlyLearning = new ClauseOnlyLearning<PBDataStructureFactory>();
        PBSolverCP pBSolverCP = new PBSolverCP(clauseOnlyLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning<PBDataStructureFactory> clauseOnlyLearning = new ClauseOnlyLearning<PBDataStructureFactory>();
        PBSolverCP pBSolverCP = new PBSolverCP(clauseOnlyLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    private static PBSolverCP newPBKiller(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        ClauseOnlyLearning<PBDataStructureFactory> clauseOnlyLearning = new ClauseOnlyLearning<PBDataStructureFactory>();
        PBSolverCP pBSolverCP = new PBSolverCP(clauseOnlyLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(iPhaseSelectionStrategy));
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverCP newPBKillerRSAT() {
        return SolverFactory.newPBKiller(new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP newPBKillerClassic() {
        return SolverFactory.newPBKiller(new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP newPBKillerFixed() {
        return SolverFactory.newPBKiller(new UserFixedPhaseSelectionStrategy());
    }

    private static PBSolverCP newCompetPBKiller(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        ClauseOnlyLearning<PBDataStructureFactory> clauseOnlyLearning = new ClauseOnlyLearning<PBDataStructureFactory>();
        PBSolverCP pBSolverCP = new PBSolverCP(clauseOnlyLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(iPhaseSelectionStrategy));
        clauseOnlyLearning.setSolver(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverCP newCompetPBKillerRSAT() {
        return SolverFactory.newCompetPBKiller(new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP newCompetPBKillerClassic() {
        return SolverFactory.newCompetPBKiller(new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP newCompetPBKillerFixed() {
        return SolverFactory.newCompetPBKiller(new UserFixedPhaseSelectionStrategy());
    }

    public static PBSolverCP newMiniLearningOPBClauseCardConstrMaxSpecificOrderIncrementalReductionToClause() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverClause pBSolverClause = new PBSolverClause(miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        miniSATLearning.setDataStructureFactory(pBSolverClause.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverClause);
        return pBSolverClause;
    }

    public static PBSolverCP newPBCPMixedConstraintsObjectiveNoLearning() {
        NoLearningButHeuristics<PBDataStructureFactory> noLearningButHeuristics = new NoLearningButHeuristics<PBDataStructureFactory>();
        PBSolverCP pBSolverCP = new PBSolverCP(noLearningButHeuristics, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        noLearningButHeuristics.setSolver((Solver)pBSolverCP);
        noLearningButHeuristics.setVarActivityListener(pBSolverCP);
        return pBSolverCP;
    }

    public static PBSolverResolution newPBResMixedConstraintsObjective() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)miniSATLearning, new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverResolution newCompetPBResWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResHTMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBMixedHTClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResLongHTMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBLongMixedHTClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResLongWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBLongMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetMinPBResLongWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionMinPBLongMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjectiveExpSimp(PBDataStructureFactory pBDataStructureFactory) {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)miniSATLearning, pBDataStructureFactory, (IOrder)new VarOrderHeapObjective(new RSATPhaseSelectionStrategy()), (RestartStrategy)new ArminRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResolution);
        pBSolverResolution.setSimplifier(pBSolverResolution.EXPENSIVE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static PBSolverResolution newPBResHTMixedConstraintsObjective() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        CompetResolutionPBMixedHTClauseCardConstrDataStructure competResolutionPBMixedHTClauseCardConstrDataStructure = new CompetResolutionPBMixedHTClauseCardConstrDataStructure();
        competResolutionPBMixedHTClauseCardConstrDataStructure.setNormalizer(AbstractPBDataStructureFactory.NO_COMPETITION);
        PBSolverResolution pBSolverResolution = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)miniSATLearning, competResolutionPBMixedHTClauseCardConstrDataStructure, (IOrder)new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverResolution newCompetPBResMinHTMixedConstraintsObjective() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)miniSATLearning, new CompetMinHTmixedClauseCardConstrDataStructureFactory(), (IOrder)new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverResolution newPBResMinHTMixedConstraintsObjective() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        CompetMinHTmixedClauseCardConstrDataStructureFactory competMinHTmixedClauseCardConstrDataStructureFactory = new CompetMinHTmixedClauseCardConstrDataStructureFactory();
        competMinHTmixedClauseCardConstrDataStructureFactory.setNormalizer(AbstractPBDataStructureFactory.NO_COMPETITION);
        PBSolverResolution pBSolverResolution = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)miniSATLearning, competMinHTmixedClauseCardConstrDataStructureFactory, (IOrder)new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution pBSolverResolution = SolverFactory.newPBResMixedConstraintsObjective();
        pBSolverResolution.setSimplifier(pBSolverResolution.EXPENSIVE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static PBSolverResolution newPBResHTMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution pBSolverResolution = SolverFactory.newPBResHTMixedConstraintsObjective();
        pBSolverResolution.setSimplifier(pBSolverResolution.EXPENSIVE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static PBSolverResolution newCompetPBResMinHTMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution pBSolverResolution = SolverFactory.newCompetPBResMinHTMixedConstraintsObjective();
        pBSolverResolution.setSimplifier(pBSolverResolution.EXPENSIVE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static PBSolverClause newPBCPMixedConstraintsReduceToClause() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverClause pBSolverClause = new PBSolverClause(miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverClause.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverClause);
        return pBSolverClause;
    }

    public static PBSolverCautious newPBCPMixedConstraintsCautious(int n) {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverCautious pBSolverCautious = new PBSolverCautious(miniSATLearning, (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(), n);
        miniSATLearning.setDataStructureFactory(pBSolverCautious.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverCautious);
        return pBSolverCautious;
    }

    public static PBSolverCautious newPBCPMixedConstraintsCautious() {
        return SolverFactory.newPBCPMixedConstraintsCautious(10);
    }

    public static PBSolverResCP newPBCPMixedConstraintsResCP(long l) {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverResCP pBSolverResCP = new PBSolverResCP(miniSATLearning, (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(), l);
        miniSATLearning.setDataStructureFactory(pBSolverResCP.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResCP);
        pBSolverResCP.setSimplifier(pBSolverResCP.EXPENSIVE_SIMPLIFICATION);
        return pBSolverResCP;
    }

    public static PBSolverResCP newPBCPMixedConstraintsResCP() {
        return SolverFactory.newPBCPMixedConstraintsResCP(100000L);
    }

    public static PBSolverWithImpliedClause newPBCPMixedConstrainsImplied() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverWithImpliedClause pBSolverWithImpliedClause = new PBSolverWithImpliedClause(miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverWithImpliedClause.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverWithImpliedClause);
        return pBSolverWithImpliedClause;
    }

    public static PBSolverCP newMiniOPBClauseAtLeastConstrMax() {
        return SolverFactory.newPBCP(new PBMaxClauseAtLeastConstrDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWL() {
        return SolverFactory.newPBRes(new PBMinDataStructure());
    }

    public static PBSolverCP newPBCPAllPBWL() {
        return SolverFactory.newPBCP(new PBMinDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWLPueblo() {
        return SolverFactory.newPBRes(new PuebloPBMinDataStructure());
    }

    private static PBSolverResolution newPBRes(PBDataStructureFactory pBDataStructureFactory) {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)miniSATLearning, pBDataStructureFactory, (IOrder)new VarOrderHeap(), (RestartStrategy)new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResolution);
        return pBSolverResolution;
    }

    public static PBSolverCP newPBCPAllPBWLPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseCardMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseCardMin() {
        return SolverFactory.newPBCP(new PBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseAtLeastMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseAtLeastConstrDataStructure());
    }

    private static PBSolverCP newPBCP(PBDataStructureFactory pBDataStructureFactory, IOrder iOrder) {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverCP pBSolverCP = new PBSolverCP(miniSATLearning, pBDataStructureFactory, iOrder);
        miniSATLearning.setDataStructureFactory(pBSolverCP.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverCP);
        pBSolverCP.setRestartStrategy(new ArminRestarts());
        pBSolverCP.setLearnedConstraintsDeletionStrategy(pBSolverCP.glucose);
        return pBSolverCP;
    }

    private static PBSolverCP newPBCP(PBDataStructureFactory pBDataStructureFactory) {
        return SolverFactory.newPBCP(pBDataStructureFactory, new VarOrderHeap());
    }

    public static IPBSolver newCuttingPlanes() {
        return SolverFactory.newCompetPBCPMixedConstraintsObjective();
    }

    public static IPBSolver newCuttingPlanesAggressiveCleanup() {
        PBSolverCP pBSolverCP = SolverFactory.newCompetPBCPMixedConstraintsObjective();
        pBSolverCP.setLearnedConstraintsDeletionStrategy(pBSolverCP.fixedSize(100));
        return pBSolverCP;
    }

    public static IPBSolver newResolution() {
        return SolverFactory.newResolutionGlucoseExpSimp();
    }

    public static IPBSolver newBoth() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newCuttingPlanes()});
    }

    public static PBSolverResolution newResolutionGlucose() {
        PBSolverResolution pBSolverResolution = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        pBSolverResolution.setSimplifier(Solver.NO_SIMPLIFICATION);
        pBSolverResolution.setLearnedConstraintsDeletionStrategy(pBSolverResolution.glucose);
        return pBSolverResolution;
    }

    public static PBSolverResolution newResolutionGlucoseSimpleSimp() {
        PBSolverResolution pBSolverResolution = SolverFactory.newResolutionGlucose();
        pBSolverResolution.setSimplifier(pBSolverResolution.SIMPLE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static PBSolverResolution newResolutionGlucoseExpSimp() {
        PBSolverResolution pBSolverResolution = SolverFactory.newResolutionGlucose();
        pBSolverResolution.setSimplifier(pBSolverResolution.EXPENSIVE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static IPBSolver newSimpleSimplification() {
        PBSolverResolution pBSolverResolution = SolverFactory.newCompetPBResWLMixedConstraintsObjectiveExpSimp();
        pBSolverResolution.setLearnedConstraintsDeletionStrategy(pBSolverResolution.glucose);
        pBSolverResolution.setSimplifier(pBSolverResolution.SIMPLE_SIMPLIFICATION);
        return pBSolverResolution;
    }

    public static IPBSolver newResolutionSimpleRestarts() {
        PBSolverResolution pBSolverResolution = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        pBSolverResolution.setLearnedConstraintsDeletionStrategy(pBSolverResolution.glucose);
        pBSolverResolution.setRestartStrategy(new MiniSATRestarts());
        return pBSolverResolution;
    }

    public static IPBSolver newResolutionMaxMemory() {
        PBSolverResolution pBSolverResolution = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        pBSolverResolution.setLearnedConstraintsDeletionStrategy(pBSolverResolution.memory_based);
        return pBSolverResolution;
    }

    public static PBSolver newDefault() {
        return SolverFactory.newResolutionGlucose();
    }

    public static IPBSolver newDefaultNonNormalized() {
        return SolverFactory.newPBResHTMixedConstraintsObjectiveExpSimp();
    }

    @Override
    public PBSolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static IPBSolver newLight() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp();
    }

    @Override
    public IPBSolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }

    public static IPBSolver newEclipseP2() {
        MiniSATLearning<PBDataStructureFactory> miniSATLearning = new MiniSATLearning<PBDataStructureFactory>();
        PBSolverResolution pBSolverResolution = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)miniSATLearning, new CompetResolutionPBMixedHTClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(new RSATPhaseSelectionStrategy()), (RestartStrategy)new ArminRestarts());
        miniSATLearning.setDataStructureFactory(pBSolverResolution.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverResolution);
        pBSolverResolution.setTimeoutOnConflicts(300);
        pBSolverResolution.setVerbose(false);
        return new OptToPBSATAdapter(new PseudoOptDecorator(pBSolverResolution));
    }

    @Override
    public /* synthetic */ ISolver lightSolver() {
        return this.lightSolver();
    }

    @Override
    public /* synthetic */ ISolver defaultSolver() {
        return this.defaultSolver();
    }
}

