/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLong;
import org.sat4j.specs.ContradictionException;

public final class MaxWatchPbLong
extends WatchPbLong {
    private static final long serialVersionUID = 1L;
    private long watchCumul = 0L;
    private final Map<Integer, Long> litToCoeffs;
    static final /* synthetic */ boolean $assertionsDisabled;

    private MaxWatchPbLong(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(this.coefs.length);
            for (int i = 0; i < this.coefs.length; ++i) {
                this.litToCoeffs.put(new Integer(this.lits[i]), new Long(this.coefs[i]));
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPbLong(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (bigIntegerArray.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(bigIntegerArray.length);
            for (int i = 0; i < bigIntegerArray.length; ++i) {
                this.litToCoeffs.put(new Integer(nArray[i]), new Long(this.coefs[i]));
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && this.watchCumul != 0L) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (!this.learnt) continue;
                this.voc.undos(this.lits[i] ^ 1).push(this);
                this.voc.watch(this.lits[i] ^ 1, this);
                continue;
            }
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watchCumul += this.coefs[i];
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        if (!this.learnt && this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.coefs.length && this.watchCumul - this.coefs[i] < this.degree; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        long l;
        this.voc.watch(n, this);
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError((Object)("" + this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt));
        }
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            l = this.litToCoeffs.get(new Integer(n ^ 1));
        }
        long l2 = this.watchCumul - l;
        if (l2 < this.degree) {
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        this.voc.undos(n).push(this);
        this.watchCumul = l2;
        long l3 = this.watchCumul - this.degree;
        for (int i = 0; i < this.coefs.length && l3 < this.coefs[i]; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        if (!$assertionsDisabled && !this.learnt && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchCumul < this.computeLeftSide()) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    public void undo(int n) {
        long l;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            l = this.litToCoeffs.get(new Integer(n ^ 1));
        }
        this.watchCumul += l;
    }

    public static MaxWatchPbLong normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MaxWatchPbLong maxWatchPbLong = new MaxWatchPbLong(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (maxWatchPbLong.degree <= 0L) {
            return null;
        }
        maxWatchPbLong.computeWatches();
        maxWatchPbLong.computePropagation(unitPropagationListener);
        return maxWatchPbLong;
    }

    public static WatchPbLong normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MaxWatchPbLong(iLits, iDataStructurePB);
    }

    static {
        $assertionsDisabled = !MaxWatchPbLong.class.desiredAssertionStatus();
    }
}

