/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.math.BigInteger;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverStats;
import org.sat4j.pb.orders.IOrderObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PBSolver
extends Solver<PBDataStructureFactory>
implements IPBCDCLSolver<PBDataStructureFactory> {
    private ObjectiveFunction objf;
    private static final long serialVersionUID = 1L;
    protected PBSolverStats stats;
    public final LearnedConstraintsDeletionStrategy objectiveFunctionBased = new LearnedConstraintsDeletionStrategy(){
        private static final long serialVersionUID = 1L;
        private boolean[] inObjectiveFunction;
        private final ConflictTimer clauseManagement = new ConflictTimerAdapter(1000){
            private static final long serialVersionUID = 1L;
            private int nbconflict;
            private static final int MAX_CLAUSE = 5000;
            private static final int INC_CLAUSE = 1000;
            private int nextbound;
            {
                this.nbconflict = 0;
                this.nextbound = 5000;
            }

            public void run() {
                this.nbconflict += this.bound();
                if (this.nbconflict >= this.nextbound) {
                    this.nextbound += 1000;
                    this.nbconflict = 0;
                    PBSolver.this.setNeedToReduceDB(true);
                }
            }

            public void reset() {
                super.reset();
                this.nextbound = 5000;
                if (this.nbconflict >= this.nextbound) {
                    this.nbconflict = 0;
                    PBSolver.this.setNeedToReduceDB(true);
                }
            }
        };

        @Override
        public void reduce(IVec<Constr> iVec) {
            int n = 0;
            for (int i = 0; i < iVec.size(); ++i) {
                Constr constr = iVec.get(i);
                if (constr.locked() || constr.getActivity() <= 2.0) {
                    iVec.set(n++, (Constr)PBSolver.this.learnts.get(i));
                    continue;
                }
                constr.remove(PBSolver.this);
            }
            if (PBSolver.this.isVerbose()) {
                System.out.println(new StringBuffer().append(PBSolver.this.getLogPrefix()).append("cleaning ").append(iVec.size() - n).append(" clauses out of ").append(iVec.size()).append("/").append(PBSolver.this.stats.conflicts).toString());
                System.out.flush();
            }
            PBSolver.this.learnts.shrinkTo(n);
        }

        @Override
        public ConflictTimer getTimer() {
            return this.clauseManagement;
        }

        public String toString() {
            return "Objective function driven learned constraints deletion strategy";
        }

        @Override
        public void init() {
            this.inObjectiveFunction = new boolean[PBSolver.this.nVars() + 1];
            if (PBSolver.this.objf == null) {
                throw new IllegalStateException("The strategy does not make sense if there is no objective function");
            }
            IteratorInt iteratorInt = PBSolver.this.objf.getVars().iterator();
            while (iteratorInt.hasNext()) {
                this.inObjectiveFunction[Math.abs((int)iteratorInt.next())] = true;
            }
            this.clauseManagement.reset();
        }

        @Override
        public void onConflict(Constr constr) {
            boolean bl = true;
            for (int i = 0; i < constr.size(); ++i) {
                bl = bl && this.inObjectiveFunction[LiteralsUtils.var(constr.get(i))];
            }
            if (bl) {
                constr.incActivity(1.0);
            } else {
                constr.incActivity(constr.size());
            }
        }

        @Override
        public void onConflictAnalysis(Constr constr) {
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$core$PBSolver;

    public PBSolver(LearningStrategy<PBDataStructureFactory> learningStrategy, PBDataStructureFactory pBDataStructureFactory, IOrder iOrder, RestartStrategy restartStrategy) {
        super(learningStrategy, pBDataStructureFactory, iOrder, restartStrategy);
        this.stats = new PBSolverStats();
        this.initStats(this.stats);
    }

    public PBSolver(LearningStrategy<PBDataStructureFactory> learningStrategy, PBDataStructureFactory pBDataStructureFactory, SearchParams searchParams, IOrder iOrder, RestartStrategy restartStrategy) {
        super(learningStrategy, pBDataStructureFactory, searchParams, iOrder, restartStrategy);
        this.stats = new PBSolverStats();
        this.initStats(this.stats);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, bl, bigInteger));
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objf = objectiveFunction;
        IOrder iOrder = this.getOrder();
        if (iOrder instanceof IOrderObjective) {
            ((IOrderObjective)iOrder).setObjectiveFunction(objectiveFunction);
        }
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objf;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt2.size());
        for (int i = 0; i < iVecInt2.size(); ++i) {
            vec.push(BigInteger.valueOf(iVecInt2.get(i)));
        }
        return this.addAtMost(iVecInt, vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, false, bigInteger));
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt2.size());
        for (int i = 0; i < iVecInt2.size(); ++i) {
            vec.push(BigInteger.valueOf(iVecInt2.get(i)));
        }
        return this.addAtLeast(iVecInt, vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, true, bigInteger));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt2.size());
        for (int i = 0; i < iVecInt2.size(); ++i) {
            vec.push(BigInteger.valueOf(iVecInt2.get(i)));
        }
        return this.addExactly(iVecInt, vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        if (!$assertionsDisabled && iVecInt2.size() != iVecInt.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ConstrGroup constrGroup = new ConstrGroup(false);
        constrGroup.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, false, bigInteger)));
        constrGroup.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, true, bigInteger)));
        return constrGroup;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$core$PBSolver == null ? (class$org$sat4j$pb$core$PBSolver = PBSolver.class$("org.sat4j.pb.core.PBSolver")) : class$org$sat4j$pb$core$PBSolver).desiredAssertionStatus();
    }
}

