/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.ICDCLLogger;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.LubyRestarts;
import org.sat4j.minisat.restarts.NoRestarts;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.GnuplotDataFile;
import org.sat4j.sat.GnuplotFunction;
import org.sat4j.sat.GnuplotPreferences;
import org.sat4j.sat.RTSI;
import org.sat4j.sat.RemoteControlStrategy;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.HeuristicsTracing;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.LearnedTracing;
import org.sat4j.tools.MultiTracing;
import org.sat4j.tools.SpeedTracing;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetailedCommandPanel
extends JPanel
implements ICDCLLogger,
SearchListener {
    private static final long serialVersionUID = 1L;
    private static final EmptyBorder border5;
    private String ramdisk;
    private RemoteControlStrategy telecomStrategy;
    private RandomWalkDecorator randomWalk;
    private ICDCL solver;
    private Reader reader;
    private IProblem problem;
    private boolean optimizationMode;
    private boolean useCustomizedSolver;
    private Thread solveurThread;
    private StringWriter stringWriter;
    private MyTabbedPane tabbedPane;
    private JPanel aboutSolverPanel;
    private JTextArea textArea;
    private JPanel instancePanel;
    private static final String INSTANCE_PANEL = "Instance";
    private JLabel instanceLabel;
    private static final String INSTANCE = "Path to instance: ";
    private JTextField instancePathField;
    private String instancePath;
    private JButton browseButton;
    private static final String BROWSE = "Browse";
    private static final String MINISAT_PREFIX = "minisat";
    private static final String PB_PREFIX = "pb";
    private JPanel choixSolverPanel;
    private static final String CHOIX_SOLVER_PANEL = "Solver";
    private JLabel choixSolver;
    private static final String CHOIX_SOLVER = "Choose solver: ";
    private String selectedSolver;
    private JComboBox listeSolvers;
    private static final String OPTMIZATION_MODE = "Use optimization mode";
    private JCheckBox optimisationModeCB;
    private JCheckBox useCustomizedSolverCB;
    private static final String USE_CUSTOMIZED_SOLVER = "Use customized solver";
    private JButton startStopButton;
    private static final String START = "Start";
    private static final String STOP = "Stop";
    private JButton pauseButton;
    private static final String PAUSE = "Pause";
    private static final String RESUME = "Resume";
    private boolean isInterrupted;
    private static final String RESTART_PANEL = "Restart strategy";
    private static final String RESTART = "Restart";
    private JPanel restartPanel;
    private JPanel restartPropertiesPanel;
    private JPanel restartButtonPanel;
    private JLabel chooseRestartStrategyLabel;
    private static final String CHOOSE_RESTART_STRATEGY = "Choose restart strategy: ";
    private static final String NO_PARAMETER_FOR_THIS_STRATEGY = "No paramaters for this strategy";
    private JLabel noParameterLabel;
    private JComboBox listeRestarts;
    private String currentRestart;
    private static final String RESTART_DEFAULT = "NoRestarts";
    private static final String RESTART_STRATEGY_CLASS = "org.sat4j.minisat.core.RestartStrategy";
    private static final String RESTART_PATH = "org.sat4j.minisat.restarts";
    private JLabel factorLabel;
    private static final String FACTOR = "Factor: ";
    private JTextField factorField;
    private JButton restartButton;
    private JPanel rwPanel;
    private JLabel probaRWLabel;
    private JTextField probaRWField;
    private JButton applyRWButton;
    private static final String RW_PANEL = "Random Walk";
    private static final String RW_LABEL = "Probabilty : ";
    private static final String RW_APPLY = "Apply";
    private JPanel cleanPanel;
    private static final String CLEAN_PANEL = "Learned Constraint Deletion Strategy";
    private JSlider cleanSlider;
    private static final String EVALUATION_TYPE = "Clauses evaluation type";
    private static final String ACTIVITY_BASED = "Activity";
    private static final String LBD_BASED = "LBD";
    private JLabel evaluationLabel;
    private ButtonGroup evaluationGroup;
    private JRadioButton activityRadio;
    private JRadioButton lbdRadio;
    private JButton cleanAndEvaluationApplyButton;
    private JButton cleanButton;
    private static final String CLEAN = "Clean now";
    private static final String MANUAL_CLEAN = "Manual clean: ";
    private JLabel manualCleanLabel;
    private final JLabel deleteClauseLabel = new JLabel("Automated clean: ");
    private static final String DELETE_CLAUSES = "Automated clean: ";
    private Hashtable<Integer, JLabel> cleanValuesTable;
    private final JLabel clean5000Label = new JLabel("5000");
    private final JLabel clean10000Label = new JLabel("10000");
    private final JLabel clean20000Label = new JLabel("20000");
    private final JLabel clean50000Label = new JLabel("50000");
    private final JLabel clean100000Label = new JLabel("100000");
    private final JLabel clean500000Label = new JLabel("500000");
    private static final int[] cleanValues;
    private static final int CLEAN_MIN = 0;
    private static final int CLEAN_MAX = 5;
    private static final int CLEAN_INIT = 1;
    private static final int CLEAN_SPACE = 1;
    private static final String CLEAN_5000 = "5000";
    private static final String CLEAN_10000 = "10000";
    private static final String CLEAN_20000 = "20000";
    private static final String CLEAN_50000 = "50000";
    private static final String CLEAN_100000 = "100000";
    private static final String CLEAN_500000 = "500000";
    private JCheckBox cleanUseOriginalStrategyCB;
    private static final String USE_ORIGINAL_STRATEGY = "Use solver's original deletion strategy";
    private JPanel phasePanel;
    private static final String PHASE_PANEL = "Phase Strategy";
    private String currentPhaseSelectionStrategy;
    private JComboBox phaseList;
    private JLabel phaseListLabel;
    private static final String PHASE_STRATEGY = "Choose phase strategy :";
    private JButton phaseApplyButton;
    private static final String PHASE_APPLY = "Apply";
    private static final String PHASE_STRATEGY_CLASS = "org.sat4j.minisat.core.IPhaseSelectionStrategy";
    private static final String PHASE_PATH_SAT = "org.sat4j.minisat.orders";
    private JPanel simplifierPanel;
    private static final String SIMPLIFIER_PANEL = "Simplification strategy";
    private static final String SIMPLIFICATION_APPLY = "Apply";
    private static final String SIMPLIFICATION_NO = "No reason simplification";
    private static final String SIMPLIFICATION_SIMPLE = "Simple reason simplification";
    private static final String SIMPLIFICATION_EXPENSIVE = "Expensive reason simplification";
    private JButton simplificationApplyButton;
    private ButtonGroup simplificationGroup;
    private JRadioButton simplificationNoRadio;
    private JRadioButton simplificationSimpleRadio;
    private JRadioButton simplificationExpensiveRadio;
    private JPanel hotSolverPanel;
    private static final String HOT_SOLVER_PANEL = "Hot solver";
    private JCheckBox keepSolverHotCB;
    private static final String KEEP_SOLVER_HOT = "Keep solver hot";
    private JButton applyHotSolver;
    private static final String HOT_APPLY = "Apply";
    private JTextArea console;
    private JScrollPane scrollPane;
    private boolean isPlotActivated;
    private Process gnuplotProcess;
    private GnuplotPreferences gnuplotPreferences = new GnuplotPreferences();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$sat$DetailedCommandPanel;

    public DetailedCommandPanel(String string) {
        this(string, "");
    }

    public DetailedCommandPanel(String string, String string2) {
        this(string, string2, null);
    }

    public DetailedCommandPanel(String string, String string2, ICDCL iCDCL) {
        this.telecomStrategy = new RemoteControlStrategy(this);
        this.instancePath = string;
        this.ramdisk = string2;
        this.solver = iCDCL;
        this.isPlotActivated = false;
        this.useCustomizedSolver = this.solver != null;
        this.setPreferredSize(new Dimension(750, 800));
        this.setLayout(new BoxLayout(this, 1));
        this.createInstancePanel();
        this.createChoixSolverPanel();
        this.createRestartPanel();
        this.createRWPanel();
        this.createCleanPanel();
        this.createPhasePanel();
        this.createSimplifierPanel();
        this.createHotSolverPanel();
        this.console = new JTextArea();
        this.scrollPane = new JScrollPane(this.console);
        this.scrollPane.setPreferredSize(new Dimension(400, 200));
        this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
        this.initFactorParam();
        this.restartPropertiesPanel.setPreferredSize(new Dimension(100, 50));
        this.tabbedPane = new MyTabbedPane();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.instancePanel);
        jPanel.add(this.choixSolverPanel);
        this.tabbedPane.addTab(CHOIX_SOLVER_PANEL, null, jPanel, "instance & solver options");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.restartPanel);
        this.tabbedPane.addTab(RESTART, null, jPanel2, "restart strategy & options");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(this.rwPanel);
        jPanel3.add(this.phasePanel);
        jPanel3.add(this.hotSolverPanel);
        this.tabbedPane.addTab("Heuristics", null, jPanel3, "random walk and phase strategy");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(this.cleanPanel);
        jPanel4.add(this.simplifierPanel);
        this.tabbedPane.addTab("Learned Constraints", null, jPanel4, "deletion and simplification strategy");
        this.aboutSolverPanel = new JPanel();
        this.textArea = new JTextArea("No solver is running at the moment");
        this.textArea.setColumns(50);
        this.aboutSolverPanel.add(this.textArea);
        this.tabbedPane.addTab("About Solver", null, this.aboutSolverPanel, "information about solver");
        this.add(this.tabbedPane);
        this.add(this.scrollPane);
        this.setRestartPanelEnabled(false);
        this.setRWPanelEnabled(false);
        this.setCleanPanelEnabled(false);
        this.setPhasePanelEnabled(false);
        this.setSimplifierPanelEnabled(false);
        this.setKeepSolverHotPanelEnabled(false);
    }

    public void createInstancePanel() {
        this.instancePanel = new JPanel();
        this.instancePanel.setName(INSTANCE_PANEL);
        this.instancePanel.setBorder(new CompoundBorder(new TitledBorder(null, this.instancePanel.getName(), 1, 2), border5));
        this.instancePanel.setLayout(new BorderLayout(0, 0));
        this.instanceLabel = new JLabel(INSTANCE);
        this.instancePathField = new JTextField(20);
        this.instancePathField.setText(this.instancePath);
        this.instanceLabel.setLabelFor(this.instancePathField);
        JPanel jPanel = new JPanel();
        jPanel.add(this.instanceLabel);
        jPanel.add(this.instancePathField);
        this.browseButton = new JButton(BROWSE);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.openFileChooser();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.browseButton);
        this.instancePanel.add((Component)jPanel, "Center");
        this.instancePanel.add((Component)jPanel2, "South");
    }

    public void createChoixSolverPanel() {
        this.choixSolverPanel = new JPanel();
        this.choixSolverPanel.setName(CHOIX_SOLVER_PANEL);
        this.choixSolverPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.choixSolverPanel.getName(), 1, 2), border5));
        this.choixSolverPanel.setLayout(new BorderLayout());
        this.choixSolver = new JLabel(CHOIX_SOLVER);
        this.updateListOfSolvers();
        this.optimisationModeCB = new JCheckBox(OPTMIZATION_MODE);
        JPanel jPanel = new JPanel();
        jPanel.add(this.choixSolver);
        jPanel.add(this.listeSolvers);
        jPanel.add(this.optimisationModeCB);
        this.optimizationMode = false;
        this.optimisationModeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.optimizationMode = DetailedCommandPanel.this.optimisationModeCB.isSelected();
                DetailedCommandPanel.this.log("use optimization mode: " + DetailedCommandPanel.this.optimizationMode);
            }
        });
        this.startStopButton = new JButton(START);
        this.startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailedCommandPanel.this.startStopButton.getText().equals(DetailedCommandPanel.START)) {
                    DetailedCommandPanel.this.launchSolver();
                    DetailedCommandPanel.this.pauseButton.setEnabled(true);
                    DetailedCommandPanel.this.setInstancePanelEnabled(false);
                    DetailedCommandPanel.this.setRestartPanelEnabled(true);
                    DetailedCommandPanel.this.setRWPanelEnabled(true);
                    DetailedCommandPanel.this.setCleanPanelEnabled(true);
                    DetailedCommandPanel.this.setCleanPanelOriginalStrategyEnabled(true);
                    DetailedCommandPanel.this.setPhasePanelEnabled(true);
                    DetailedCommandPanel.this.setChoixSolverPanelEnabled(false);
                    DetailedCommandPanel.this.setSimplifierPanelEnabled(true);
                    DetailedCommandPanel.this.setKeepSolverHotPanelEnabled(true);
                    DetailedCommandPanel.this.startStopButton.setText(DetailedCommandPanel.STOP);
                    DetailedCommandPanel.this.getThis().paintAll(DetailedCommandPanel.this.getThis().getGraphics());
                } else {
                    ((ISolver)DetailedCommandPanel.this.problem).expireTimeout();
                    DetailedCommandPanel.this.pauseButton.setEnabled(false);
                    DetailedCommandPanel.this.log("Asked the solver to stop");
                    DetailedCommandPanel.this.setInstancePanelEnabled(true);
                    DetailedCommandPanel.this.setChoixSolverPanelEnabled(true);
                    DetailedCommandPanel.this.setRestartPanelEnabled(false);
                    DetailedCommandPanel.this.setRWPanelEnabled(false);
                    DetailedCommandPanel.this.setCleanPanelEnabled(false);
                    DetailedCommandPanel.this.setPhasePanelEnabled(false);
                    DetailedCommandPanel.this.setSimplifierPanelEnabled(false);
                    DetailedCommandPanel.this.setKeepSolverHotPanelEnabled(false);
                    DetailedCommandPanel.this.startStopButton.setText(DetailedCommandPanel.START);
                    DetailedCommandPanel.this.getThis().paintAll(DetailedCommandPanel.this.getThis().getGraphics());
                }
            }
        });
        this.pauseButton = new JButton(PAUSE);
        this.pauseButton.setEnabled(false);
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DetailedCommandPanel.this.pauseButton.getText().equals(DetailedCommandPanel.PAUSE)) {
                    DetailedCommandPanel.this.pauseButton.setText(DetailedCommandPanel.RESUME);
                    DetailedCommandPanel.this.telecomStrategy.setInterrupted(true);
                } else {
                    DetailedCommandPanel.this.pauseButton.setText(DetailedCommandPanel.PAUSE);
                    DetailedCommandPanel.this.telecomStrategy.setInterrupted(false);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(this.startStopButton);
        jPanel2.add(this.pauseButton);
        this.useCustomizedSolverCB = new JCheckBox(USE_CUSTOMIZED_SOLVER);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.useCustomizedSolverCB);
        this.useCustomizedSolverCB.setSelected(this.useCustomizedSolver);
        this.useCustomizedSolverCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.useCustomizedSolver = !DetailedCommandPanel.this.useCustomizedSolver;
                DetailedCommandPanel.this.useCustomizedSolverCB.setEnabled(DetailedCommandPanel.this.useCustomizedSolver);
                DetailedCommandPanel.this.listeSolvers.setEnabled(!DetailedCommandPanel.this.useCustomizedSolver);
                DetailedCommandPanel.this.choixSolverPanel.repaint();
            }
        });
        this.setChoixSolverPanelEnabled(true);
        this.choixSolverPanel.add((Component)jPanel3, "North");
        this.choixSolverPanel.add((Component)jPanel, "Center");
        this.choixSolverPanel.add((Component)jPanel2, "South");
    }

    public void createRestartPanel() {
        this.restartPanel = new JPanel();
        this.restartPanel.setName(RESTART_PANEL);
        this.restartPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.restartPanel.getName(), 1, 2), border5));
        this.restartPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.chooseRestartStrategyLabel = new JLabel(CHOOSE_RESTART_STRATEGY);
        this.listeRestarts = new JComboBox<Object>(this.getListOfRestartStrategies().toArray());
        this.currentRestart = this.telecomStrategy.getRestartStrategy().getClass().getSimpleName();
        this.listeRestarts.setSelectedItem(RESTART_DEFAULT);
        this.listeRestarts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.modifyRestartParamPanel();
            }
        });
        jPanel.add(this.chooseRestartStrategyLabel);
        jPanel.add(this.listeRestarts);
        this.noParameterLabel = new JLabel(NO_PARAMETER_FOR_THIS_STRATEGY);
        Font font = new Font(this.noParameterLabel.getFont().getName(), 2, this.noParameterLabel.getFont().getSize());
        this.noParameterLabel.setFont(font);
        this.restartPropertiesPanel = new JPanel();
        this.restartPropertiesPanel.add(this.noParameterLabel);
        this.restartButton = new JButton(RESTART);
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.hasClickedOnRestart();
            }
        });
        this.restartButtonPanel = new JPanel();
        this.restartButtonPanel.add(this.restartButton);
        this.restartPanel.add((Component)jPanel, "North");
        this.restartPanel.add((Component)this.restartPropertiesPanel, "Center");
        this.restartPanel.add((Component)this.restartButtonPanel, "South");
    }

    public void createRWPanel() {
        this.rwPanel = new JPanel();
        this.rwPanel.setName(RW_PANEL);
        this.rwPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.rwPanel.getName(), 1, 2), border5));
        this.rwPanel.setLayout(new BorderLayout());
        this.probaRWLabel = new JLabel(RW_LABEL);
        this.probaRWField = new JTextField("0", 10);
        this.probaRWLabel.setLabelFor(this.probaRWField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.probaRWLabel);
        jPanel.add(this.probaRWField);
        JPanel jPanel2 = new JPanel();
        this.applyRWButton = new JButton("Apply");
        this.applyRWButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.hasClickedOnApplyRW();
            }
        });
        jPanel2.add(this.applyRWButton);
        this.rwPanel.add((Component)jPanel, "Center");
        this.rwPanel.add((Component)jPanel2, "South");
    }

    public void createCleanPanel() {
        this.cleanPanel = new JPanel();
        this.cleanPanel.setName(CLEAN_PANEL);
        this.cleanPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.cleanPanel.getName(), 1, 2), border5));
        this.cleanPanel.setLayout(new BorderLayout());
        this.cleanSlider = new JSlider(0, 0, 5, 1);
        this.cleanSlider.setMajorTickSpacing(1);
        this.cleanSlider.setPaintTicks(true);
        this.cleanValuesTable = new Hashtable();
        this.cleanValuesTable.put(new Integer(0), this.clean5000Label);
        this.cleanValuesTable.put(new Integer(1), this.clean10000Label);
        this.cleanValuesTable.put(new Integer(2), this.clean20000Label);
        this.cleanValuesTable.put(new Integer(3), this.clean50000Label);
        this.cleanValuesTable.put(new Integer(4), this.clean100000Label);
        this.cleanValuesTable.put(new Integer(5), this.clean500000Label);
        this.cleanSlider.setLabelTable(this.cleanValuesTable);
        this.cleanSlider.setPaintLabels(true);
        this.cleanSlider.setSnapToTicks(true);
        this.cleanSlider.setPreferredSize(new Dimension(400, 50));
        JPanel jPanel = new JPanel();
        jPanel.add(this.deleteClauseLabel);
        jPanel.add(this.cleanSlider);
        JPanel jPanel2 = new JPanel();
        this.evaluationLabel = new JLabel(EVALUATION_TYPE);
        this.evaluationGroup = new ButtonGroup();
        this.activityRadio = new JRadioButton(ACTIVITY_BASED);
        this.lbdRadio = new JRadioButton(LBD_BASED);
        this.evaluationGroup.add(this.activityRadio);
        this.evaluationGroup.add(this.lbdRadio);
        jPanel2.add(this.evaluationLabel);
        jPanel2.add(this.activityRadio);
        jPanel2.add(this.lbdRadio);
        this.cleanAndEvaluationApplyButton = new JButton("Apply changes");
        this.cleanAndEvaluationApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.hasChangedCleaningValue();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.cleanAndEvaluationApplyButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(null, "", 1, 2), border5));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel, "North");
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        JPanel jPanel5 = new JPanel();
        this.manualCleanLabel = new JLabel(MANUAL_CLEAN);
        this.cleanButton = new JButton(CLEAN);
        this.cleanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.hasClickedOnClean();
            }
        });
        jPanel5.add(this.manualCleanLabel);
        jPanel5.add(this.cleanButton);
        JPanel jPanel6 = new JPanel();
        this.cleanUseOriginalStrategyCB = new JCheckBox(USE_ORIGINAL_STRATEGY);
        this.cleanUseOriginalStrategyCB.setSelected(true);
        this.cleanUseOriginalStrategyCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.hasClickedOnUseOriginalStrategy();
            }
        });
        jPanel6.add(this.cleanUseOriginalStrategyCB);
        this.cleanPanel.add((Component)jPanel6, "North");
        this.cleanPanel.add((Component)jPanel5, "Center");
        this.cleanPanel.add((Component)jPanel4, "South");
    }

    public void createPhasePanel() {
        this.phasePanel = new JPanel();
        this.phasePanel.setName(PHASE_PANEL);
        this.phasePanel.setBorder(new CompoundBorder(new TitledBorder(null, this.phasePanel.getName(), 1, 2), border5));
        this.phasePanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.phaseListLabel = new JLabel(PHASE_STRATEGY);
        this.phaseList = new JComboBox<Object>(this.getListOfPhaseStrategies().toArray());
        this.currentPhaseSelectionStrategy = this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName();
        this.phaseList.setSelectedItem(this.currentPhaseSelectionStrategy);
        jPanel.add(this.phaseListLabel);
        jPanel.add(this.phaseList);
        this.phaseApplyButton = new JButton("Apply");
        this.phaseApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.hasClickedOnApplyPhase();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.phaseApplyButton);
        this.phasePanel.add((Component)jPanel, "Center");
        this.phasePanel.add((Component)jPanel2, "South");
    }

    public void createSimplifierPanel() {
        this.simplifierPanel = new JPanel();
        this.simplifierPanel.setName(SIMPLIFIER_PANEL);
        this.simplifierPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.simplifierPanel.getName(), 1, 2), border5));
        this.simplifierPanel.setLayout(new BorderLayout());
        this.simplificationGroup = new ButtonGroup();
        this.simplificationExpensiveRadio = new JRadioButton(SIMPLIFICATION_EXPENSIVE);
        this.simplificationNoRadio = new JRadioButton(SIMPLIFICATION_NO);
        this.simplificationSimpleRadio = new JRadioButton(SIMPLIFICATION_SIMPLE);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.simplificationGroup.add(this.simplificationNoRadio);
        this.simplificationGroup.add(this.simplificationSimpleRadio);
        this.simplificationGroup.add(this.simplificationExpensiveRadio);
        jPanel.add(this.simplificationNoRadio);
        jPanel.add(this.simplificationSimpleRadio);
        jPanel.add(this.simplificationExpensiveRadio);
        this.simplificationApplyButton = new JButton("Apply");
        this.simplificationApplyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.hasClickedOnApplySimplification();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.simplificationApplyButton);
        this.simplifierPanel.add((Component)jPanel, "North");
        this.simplifierPanel.add((Component)jPanel2, "South");
    }

    public void createHotSolverPanel() {
        this.hotSolverPanel = new JPanel();
        this.hotSolverPanel.setName(HOT_SOLVER_PANEL);
        this.hotSolverPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.hotSolverPanel.getName(), 1, 2), border5));
        this.hotSolverPanel.setLayout(new BorderLayout());
        this.keepSolverHotCB = new JCheckBox(KEEP_SOLVER_HOT);
        this.hotSolverPanel.add((Component)this.keepSolverHotCB, "Center");
        JPanel jPanel = new JPanel();
        this.applyHotSolver = new JButton("Apply");
        jPanel.add(this.applyHotSolver);
        this.hotSolverPanel.add((Component)jPanel, "South");
        this.applyHotSolver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetailedCommandPanel.this.solver.setKeepSolverHot(DetailedCommandPanel.this.keepSolverHotCB.isSelected());
                if (DetailedCommandPanel.this.keepSolverHotCB.isSelected()) {
                    DetailedCommandPanel.this.log("Keep hot solver is now activated");
                } else {
                    DetailedCommandPanel.this.log("Keep hot solver is now desactivated");
                }
            }
        });
    }

    public void initFactorParam() {
        this.factorLabel = new JLabel(FACTOR);
        this.factorField = new JTextField("32", 5);
    }

    public void launchSolver() {
        Serializable serializable;
        Object object;
        if (!this.useCustomizedSolver) {
            this.selectedSolver = (String)this.listeSolvers.getSelectedItem();
            object = this.selectedSolver.split("\\.");
            if (!$assertionsDisabled && ((String[])object).length != 2) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || object[0].equals(MINISAT_PREFIX) || object[0].equals(PB_PREFIX))) {
                throw new AssertionError();
            }
            serializable = object[0].equals(MINISAT_PREFIX) ? SolverFactory.instance() : org.sat4j.pb.SolverFactory.instance();
            this.solver = (ICDCL)((ASolverFactory)serializable).createSolverByName(object[1]);
        }
        this.telecomStrategy.setSolver(this.solver);
        this.telecomStrategy.setRestartStrategy(this.solver.getRestartStrategy());
        this.currentRestart = this.telecomStrategy.getRestartStrategy().getClass().getSimpleName();
        this.solver.setRestartStrategy(this.telecomStrategy);
        if (this.solver.getOrder() instanceof RandomWalkDecorator) {
            this.randomWalk = (RandomWalkDecorator)this.solver.getOrder();
            this.randomWalk.setProbability(0.0);
            this.probaRWField.setText("0");
            this.rwPanel.repaint();
        } else {
            this.randomWalk = new RandomWalkDecorator((VarOrderHeap)((Solver)this.solver).getOrder(), 0.0);
        }
        this.solver.setOrder(this.randomWalk);
        this.telecomStrategy.setPhaseSelectionStrategy(this.solver.getOrder().getPhaseSelectionStrategy());
        this.currentPhaseSelectionStrategy = this.telecomStrategy.getPhaseSelectionStrategy().getClass().getSimpleName();
        this.solver.getOrder().setPhaseSelectionStrategy(this.telecomStrategy);
        if (this.solver.getSimplifier().toString().equals(SIMPLIFICATION_EXPENSIVE)) {
            this.simplificationExpensiveRadio.setSelected(true);
        } else if (this.solver.getSimplifier().toString().equals(SIMPLIFICATION_SIMPLE)) {
            this.simplificationSimpleRadio.setSelected(true);
        } else {
            this.simplificationNoRadio.setSelected(true);
        }
        this.phaseList.setSelectedItem(this.currentPhaseSelectionStrategy);
        this.phasePanel.repaint();
        this.updateRestartStrategyPanel();
        object = this.instancePath;
        if (this.ramdisk.length() > 0) {
            serializable = this.instancePath.split("/");
            object = new StringBuffer().append(this.ramdisk).append("/").append((String)((Object)serializable[((SolverFactory)serializable).length - 1])).toString();
        }
        this.solver.setVerbose(true);
        serializable = new ArrayList();
        if (this.gnuplotPreferences.isDisplayClausesEvaluation()) {
            serializable.add(new LearnedTracing(new StringBuffer().append((String)object).append("-learned").toString()));
        }
        if (this.gnuplotPreferences.isDisplayClausesSize()) {
            serializable.add(new LearnedClausesSizeTracing(new StringBuffer().append((String)object).append("-learned-clauses-size").toString()));
        }
        if (this.gnuplotPreferences.isDisplayConflictsDecision()) {
            serializable.add(new ConflictLevelTracing(new StringBuffer().append((String)object).append("-conflict-level").toString()));
        }
        if (this.gnuplotPreferences.isDisplayConflictsTrail()) {
            serializable.add(new ConflictDepthTracing(new StringBuffer().append((String)object).append("-conflict-depth").toString()));
        }
        if (this.gnuplotPreferences.isDisplayDecisionIndexes()) {
            serializable.add(new DecisionTracing(new StringBuffer().append((String)object).append("-decision-indexes").toString()));
        }
        if (this.gnuplotPreferences.isDisplaySpeed()) {
            serializable.add(new SpeedTracing(new StringBuffer().append((String)object).append("-speed").toString()));
        }
        if (this.gnuplotPreferences.isDisplayVariablesEvaluation()) {
            serializable.add(new HeuristicsTracing(new StringBuffer().append((String)object).append("-heuristics").toString()));
        }
        serializable.add(this);
        this.solver.setSearchListener(new MultiTracing((List<SearchListener>)((Object)serializable)));
        this.solver.setLogger(this);
        this.reader = this.createReader(this.solver, this.instancePath);
        try {
            this.problem = this.reader.parseInstance(this.instancePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (ParseFormatException parseFormatException) {
            parseFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            this.log("Unsatisfiable (trivial)!");
        }
        boolean bl = false;
        if (this.reader instanceof PBInstanceReader && (bl = ((PBInstanceReader)this.reader).hasObjectiveFunction())) {
            this.problem = new OptToPBSATAdapter(new PseudoOptDecorator((IPBCDCLSolver)this.solver));
        }
        this.log(new StringBuffer().append("# Started solver ").append(this.solver.getClass().getSimpleName()).toString());
        this.log(new StringBuffer().append("# on instance ").append(this.instancePath).toString());
        this.log(new StringBuffer().append("# Optimisation = ").append(bl).toString());
        this.log(new StringBuffer().append("# Restart strategy = ").append(this.solver.getRestartStrategy().getClass().getSimpleName()).toString());
        this.log(new StringBuffer().append("# Random walk probability = ").append(this.randomWalk.getProbability()).toString());
        this.solveurThread = new Thread(){

            public void run() {
                try {
                    DetailedCommandPanel.this.stringWriter = new StringWriter();
                    if (DetailedCommandPanel.this.problem.isSatisfiable()) {
                        DetailedCommandPanel.this.log("Satisfiable !");
                        if (DetailedCommandPanel.this.problem instanceof OptToPBSATAdapter) {
                            DetailedCommandPanel.this.log(((OptToPBSATAdapter)DetailedCommandPanel.this.problem).getCurrentObjectiveValue() + "");
                            DetailedCommandPanel.this.reader.decode(((OptToPBSATAdapter)DetailedCommandPanel.this.problem).model(new PrintWriter(DetailedCommandPanel.this.stringWriter)), new PrintWriter(DetailedCommandPanel.this.stringWriter));
                        } else {
                            DetailedCommandPanel.this.reader.decode(DetailedCommandPanel.this.problem.model(), new PrintWriter(DetailedCommandPanel.this.stringWriter));
                        }
                        DetailedCommandPanel.this.log(DetailedCommandPanel.this.stringWriter.toString());
                    } else {
                        DetailedCommandPanel.this.log("Unsatisfiable !");
                    }
                }
                catch (TimeoutException timeoutException) {
                    DetailedCommandPanel.this.log("Timeout, sorry!");
                }
            }
        };
        this.solveurThread.start();
        if (this.isPlotActivated) {
            this.traceGnuplot();
        }
    }

    public void hasClickedOnRestart() {
        boolean bl;
        this.telecomStrategy.setHasClickedOnRestart(true);
        String string = (String)this.listeRestarts.getSelectedItem();
        boolean bl2 = bl = !string.equals(this.currentRestart);
        RestartStrategy restartStrategy = new NoRestarts();
        SearchParams searchParams = this.telecomStrategy.getSearchParams();
        if (string.equals("LubyRestarts")) {
            boolean bl3 = false;
            int n = 32;
            if (this.factorField.getText() != null) {
                n = Integer.parseInt(this.factorField.getText());
            }
            if (bl) {
                restartStrategy = new LubyRestarts(n);
                this.telecomStrategy.setRestartStrategy(restartStrategy);
            } else {
                boolean bl4 = bl3 = n != ((LubyRestarts)this.telecomStrategy.getRestartStrategy()).getFactor();
            }
            if (bl3) {
                restartStrategy = this.telecomStrategy.getRestartStrategy();
                ((LubyRestarts)restartStrategy).setFactor(n);
            }
            boolean bl5 = bl2 = bl || bl3;
            if (bl2) {
                restartStrategy.init(searchParams);
                this.log("Init restart");
            }
        } else {
            try {
                restartStrategy = (RestartStrategy)Class.forName(new StringBuffer().append("org.sat4j.minisat.restarts.").append(string).toString()).newInstance();
                if (!$assertionsDisabled && restartStrategy == null) {
                    throw new AssertionError();
                }
                this.telecomStrategy.setRestartStrategy(restartStrategy);
                this.telecomStrategy.init(searchParams);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
        }
        this.currentRestart = string;
    }

    public void hasClickedOnApplyRW() {
        double d = 0.0;
        if (this.probaRWField != null) {
            d = Double.parseDouble(this.probaRWField.getText());
        }
        this.randomWalk.setProbability(d);
        this.log(new StringBuffer().append("Set probability to ").append(d).toString());
    }

    public void hasClickedOnApplyPhase() {
        String string;
        this.currentPhaseSelectionStrategy = string = (String)this.phaseList.getSelectedItem();
        IPhaseSelectionStrategy iPhaseSelectionStrategy = null;
        try {
            iPhaseSelectionStrategy = (IPhaseSelectionStrategy)Class.forName(new StringBuffer().append("org.sat4j.minisat.orders.").append(string).toString()).newInstance();
            iPhaseSelectionStrategy.init(this.solver.nVars() + 1);
            this.telecomStrategy.setPhaseSelectionStrategy(iPhaseSelectionStrategy);
            this.log(new StringBuffer().append("Told the solver to apply a new phase strategy :").append(this.currentPhaseSelectionStrategy).toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
    }

    public void hasChangedCleaningValue() {
        int n = cleanValues[this.cleanSlider.getValue()];
        this.telecomStrategy.setNbClausesAtWhichWeShouldClean(n);
        this.log(new StringBuffer().append("Changed number of conflicts before cleaning to ").append(n).toString());
        if (this.activityRadio.isSelected()) {
            this.solver.setLearnedConstraintsDeletionStrategy(this.telecomStrategy, LearnedConstraintsEvaluationType.ACTIVITY);
            this.log("Changed clauses evaluation type to activity");
        } else {
            this.solver.setLearnedConstraintsDeletionStrategy(this.telecomStrategy, LearnedConstraintsEvaluationType.LBD);
            this.log("Changed clauses evaluation type to lbd");
        }
    }

    public void hasClickedOnClean() {
        this.log("Told the solver to clean");
        this.telecomStrategy.setHasClickedOnClean(true);
    }

    public void hasClickedOnUseOriginalStrategy() {
        int n = cleanValues[this.cleanSlider.getValue()];
        this.telecomStrategy.setNbClausesAtWhichWeShouldClean(n);
        this.telecomStrategy.setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy(true);
        this.solver.setLearnedConstraintsDeletionStrategy(this.telecomStrategy, LearnedConstraintsEvaluationType.ACTIVITY);
        this.activityRadio.setSelected(true);
        this.log(new StringBuffer().append("Solver now cleans clauses every ").append(cleanValues[this.cleanSlider.getValue()]).append(" conflicts and bases evaluation of clauses on activity").toString());
        this.setCleanPanelOriginalStrategyEnabled(false);
    }

    public void hasClickedOnApplySimplification() {
        if (this.simplificationSimpleRadio.isSelected()) {
            this.solver.setSimplifier(SimplificationType.SIMPLE_SIMPLIFICATION);
            this.log("Told the solver to use Simple reason simplification");
        } else if (this.simplificationExpensiveRadio.isSelected()) {
            this.solver.setSimplifier(SimplificationType.EXPENSIVE_SIMPLIFICATION);
            this.log("Told the solver to use Expensive reason simplification");
        } else {
            this.solver.setSimplifier(SimplificationType.NO_SIMPLIFICATION);
            this.log("Told the solver to use No reason simplification");
        }
    }

    public List<String> getListOfRestartStrategies() {
        Vector<String> vector = RTSI.find(RESTART_STRATEGY_CLASS);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : vector) {
            if (string.contains("Remote")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getListOfPhaseStrategies() {
        Vector<String> vector = RTSI.find(PHASE_STRATEGY_CLASS);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : vector) {
            if (string.contains("Remote")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getListOfSolvers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ASolverFactory aSolverFactory = SolverFactory.instance();
        for (String string : aSolverFactory.solverNames()) {
            arrayList.add(new StringBuffer().append("minisat.").append(string).toString());
        }
        aSolverFactory = org.sat4j.pb.SolverFactory.instance();
        for (String string : aSolverFactory.solverNames()) {
            arrayList.add(new StringBuffer().append("pb.").append(string).toString());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<String> getListOfPBSolvers() {
        ArrayList<String> arrayList = new ArrayList<String>();
        org.sat4j.pb.SolverFactory solverFactory = org.sat4j.pb.SolverFactory.instance();
        for (String string : solverFactory.solverNames()) {
            arrayList.add(new StringBuffer().append("pb.").append(string).toString());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void modifyRestartParamPanel() {
        this.restartPropertiesPanel.removeAll();
        if (this.listeRestarts.getSelectedItem().equals("LubyRestarts")) {
            this.restartPropertiesPanel.add(this.factorLabel);
            this.restartPropertiesPanel.add(this.factorField);
        } else {
            this.restartPropertiesPanel.add(this.noParameterLabel);
        }
        this.setRestartPropertiesPanelEnabled(true);
        this.restartPropertiesPanel.repaint();
        this.restartPanel.repaint();
        this.restartPanel.paintAll(this.restartPanel.getGraphics());
        this.repaint();
    }

    @Override
    public void log(String string) {
        this.logsameline(new StringBuffer().append(string).append("\n").toString());
    }

    public void logsameline(String string) {
        this.console.append(string);
        this.console.setCaretPosition(this.console.getDocument().getLength());
        this.console.repaint();
        this.repaint();
    }

    public void openFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showDialog(this, "Choose instance");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.instancePath = file.getAbsolutePath();
            this.instancePathField.setText(this.instancePath);
            this.updateListOfSolvers();
        }
    }

    protected Reader createReader(ICDCL iCDCL, String string) {
        if (iCDCL instanceof IPBSolver) {
            return new PBInstanceReader((IPBSolver)((Object)iCDCL));
        }
        return new InstanceReader(iCDCL);
    }

    public void updateListOfSolvers() {
        if (this.instancePath.endsWith(".opb")) {
            this.listeSolvers = new JComboBox<Object>(this.getListOfPBSolvers().toArray());
            this.listeSolvers.setSelectedItem("pb.Default");
            this.selectedSolver = "pb.Default";
        } else {
            this.listeSolvers = new JComboBox<Object>(this.getListOfSolvers().toArray());
            this.listeSolvers.setSelectedItem("minisat.Default");
            this.selectedSolver = "minisat.Default";
        }
    }

    public void updateRestartStrategyPanel() {
        this.listeRestarts.setSelectedItem(this.currentRestart);
    }

    public void setInstancePanelEnabled(boolean bl) {
        this.instanceLabel.setEnabled(bl);
        this.instancePathField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        this.instancePanel.repaint();
    }

    public void setChoixSolverPanelEnabled(boolean bl) {
        this.listeSolvers.setEnabled(bl && !this.useCustomizedSolver);
        this.choixSolver.setEnabled(bl && !this.useCustomizedSolver);
        this.useCustomizedSolverCB.setEnabled(bl && this.useCustomizedSolver);
        this.optimisationModeCB.setEnabled(bl);
        this.choixSolverPanel.repaint();
    }

    public void setRestartPanelEnabled(boolean bl) {
        this.listeRestarts.setEnabled(bl);
        this.restartButton.setEnabled(bl);
        this.chooseRestartStrategyLabel.setEnabled(bl);
        this.setRestartPropertiesPanelEnabled(bl);
        this.restartPanel.repaint();
    }

    public void setRestartPropertiesPanelEnabled(boolean bl) {
        for (Component component : this.restartPropertiesPanel.getComponents()) {
            component.setEnabled(bl);
        }
        this.restartPropertiesPanel.repaint();
    }

    public void setRWPanelEnabled(boolean bl) {
        this.probaRWLabel.setEnabled(bl);
        this.probaRWField.setEnabled(bl);
        this.applyRWButton.setEnabled(bl);
        this.rwPanel.repaint();
    }

    public void setCleanPanelEnabled(boolean bl) {
        this.manualCleanLabel.setEnabled(bl);
        this.deleteClauseLabel.setEnabled(bl);
        this.cleanSlider.setEnabled(bl);
        this.cleanButton.setEnabled(bl);
        this.evaluationLabel.setEnabled(bl);
        this.activityRadio.setEnabled(bl);
        this.lbdRadio.setEnabled(bl);
        this.cleanAndEvaluationApplyButton.setEnabled(bl);
        this.cleanUseOriginalStrategyCB.setEnabled(bl);
        this.cleanPanel.repaint();
    }

    public void setCleanPanelOriginalStrategyEnabled(boolean bl) {
        this.cleanUseOriginalStrategyCB.setEnabled(bl);
        this.manualCleanLabel.setEnabled(!bl);
        this.deleteClauseLabel.setEnabled(!bl);
        this.activityRadio.setEnabled(!bl);
        this.evaluationLabel.setEnabled(!bl);
        this.lbdRadio.setEnabled(!bl);
        this.cleanAndEvaluationApplyButton.setEnabled(!bl);
        this.cleanSlider.setEnabled(!bl);
        this.cleanButton.setEnabled(!bl);
        this.cleanPanel.repaint();
    }

    public void setPhasePanelEnabled(boolean bl) {
        this.phaseList.setEnabled(bl);
        this.phaseListLabel.setEnabled(bl);
        this.phaseApplyButton.setEnabled(bl);
        this.restartPanel.repaint();
    }

    public void setSimplifierPanelEnabled(boolean bl) {
        this.simplificationNoRadio.setEnabled(bl);
        this.simplificationExpensiveRadio.setEnabled(bl);
        this.simplificationSimpleRadio.setEnabled(bl);
        this.simplificationApplyButton.setEnabled(bl);
        this.simplifierPanel.repaint();
    }

    public void setKeepSolverHotPanelEnabled(boolean bl) {
        this.keepSolverHotCB.setEnabled(bl);
        this.applyHotSolver.setEnabled(bl);
        this.hotSolverPanel.repaint();
    }

    public void activateGnuplotTracing(boolean bl) {
        this.isPlotActivated = bl;
        if (this.startStopButton.getText().equals(STOP)) {
            if (bl) {
                this.traceGnuplot();
            } else {
                this.stopGnuplot();
            }
        } else if (!bl) {
            this.stopGnuplot();
        }
    }

    public void traceGnuplot() {
        int n = this.solver.nVars();
        if (this.gnuplotProcess == null) {
            try {
                Object object;
                Object object2;
                GnuplotDataFile gnuplotDataFile;
                double d = 0.0;
                double d2 = 0.33;
                double d3 = 0.66;
                double d4 = 0.0;
                double d5 = 0.33;
                double d6 = 0.66;
                double d7 = 0.33;
                double d8 = 0.33;
                PrintStream printStream = new PrintStream(new FileOutputStream(new StringBuffer().append(this.instancePath).append("-gnuplot.gnuplot").toString()));
                printStream.println("set terminal x11");
                printStream.println("set multiplot");
                printStream.println("set autoscale x");
                printStream.println("set autoscale y");
                printStream.println("set nologscale x");
                printStream.println("set nologscale y");
                printStream.println("set ytics auto");
                GnuplotFunction gnuplotFunction = new GnuplotFunction("2", Color.black, "");
                if (this.gnuplotPreferences.isDisplayConflictsDecision()) {
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d6).append(",").append(d2).toString());
                    printStream.println("set title \"Decision level at which the conflict occurs\"");
                    printStream.println(new StringBuffer().append("set y2range[0:").append(n).append("]").toString());
                    gnuplotDataFile = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-conflict-level.dat").toString(), Color.magenta, "Conflict Level");
                    printStream.println(this.gnuplotPreferences.generatePlotLine(gnuplotDataFile, gnuplotFunction, new StringBuffer().append(this.instancePath).append("-conflict-level-restart.dat").toString(), true));
                }
                if (this.gnuplotPreferences.isDisplayClausesSize()) {
                    printStream.println("unset autoscale");
                    printStream.println("set autoscale x");
                    printStream.println("set autoscale y");
                    printStream.println(new StringBuffer().append("set y2range[0:").append(n).append("]").toString());
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d4).append(",").append(d3).toString());
                    printStream.println("set title \"Size of the clause learned (after minimization if any)\"");
                    gnuplotDataFile = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-learned-clauses-size.dat").toString(), Color.blue, "Size");
                    printStream.println(this.gnuplotPreferences.generatePlotLine(gnuplotDataFile, gnuplotFunction, new StringBuffer().append(this.instancePath).append("-conflict-level-restart.dat").toString(), true));
                }
                if (this.gnuplotPreferences.isDisplayConflictsDecision()) {
                    printStream.println("set autoscale x");
                    printStream.println("set autoscale y");
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d5).append(",").append(d3).toString());
                    printStream.println("set title \"Value of learned clauses evaluation\"");
                    gnuplotDataFile = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-learned.dat").toString(), Color.blue, "Evaluation");
                    printStream.println(this.gnuplotPreferences.generatePlotLine(gnuplotDataFile, gnuplotFunction, "", false));
                }
                printStream.println("set autoscale x");
                printStream.println("set nologscale x");
                printStream.println("set nologscale y");
                printStream.println("set autoscale y");
                printStream.println(new StringBuffer().append("set yrange [1:").append(n).append("]").toString());
                printStream.println(new StringBuffer().append("set ytics add (1,").append(n).append(")").toString());
                if (this.gnuplotPreferences.isDisplayDecisionIndexes()) {
                    printStream.println("unset autoscale");
                    printStream.println(new StringBuffer().append("if(system(\"head ").append(this.instancePath).append("-decision-indexes-pos.dat | wc -l\")!=0){set autoscale x;}").toString());
                    printStream.println(new StringBuffer().append("if(system(\"head ").append(this.instancePath).append("-decision-indexes-pos.dat | wc -l\")!=0){set yrange [1:").append(n).append("]};").toString());
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d4).append(",").append(d2).toString());
                    printStream.println("set title \"Index of the decision variables\"");
                    gnuplotDataFile = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-decision-indexes-neg.dat").toString(), Color.red, "Negative Decision");
                    printStream.println(this.gnuplotPreferences.generatePlotLine(gnuplotDataFile, gnuplotFunction, new StringBuffer().append(this.instancePath).append("-decision-indexes-restart.dat").toString(), true, this.gnuplotPreferences.getNbLinesRead() * 4));
                    printStream.println("unset autoscale");
                    printStream.println(new StringBuffer().append("if(system(\"head ").append(this.instancePath).append("-decision-indexes-pos.dat | wc -l\")!=0){set autoscale x;set yrange [1:").append(n).append("];}").toString());
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d4).append(",").append(d).toString());
                    printStream.println("set title \"Index of the decision variables\"");
                    object2 = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-decision-indexes-pos.dat").toString(), Color.green, "Positive Decision");
                    printStream.println(this.gnuplotPreferences.generatePlotLine((GnuplotDataFile)object2, gnuplotFunction, new StringBuffer().append(this.instancePath).append("-decision-indexes-restart.dat").toString(), true, this.gnuplotPreferences.getNbLinesRead() * 4));
                }
                if (this.gnuplotPreferences.isDisplayConflictsTrail()) {
                    printStream.println("set autoscale x");
                    printStream.println("set autoscale y");
                    printStream.println("set nologscale x");
                    printStream.println("set nologscale y");
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d6).append(",").append(d3).toString());
                    printStream.println("set title \"Trail level when the conflict occurs\"");
                    gnuplotDataFile = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-conflict-depth.dat").toString(), Color.magenta, "Trail level");
                    object2 = new GnuplotFunction(new StringBuffer().append("").append(n / 2).toString(), Color.green, "#Var/2");
                    printStream.println(this.gnuplotPreferences.generatePlotLine(gnuplotDataFile, (GnuplotFunction)object2, new StringBuffer().append(this.instancePath).append("-conflict-level-restart.dat").toString(), true));
                }
                if (this.gnuplotPreferences.isDisplayVariablesEvaluation()) {
                    printStream.println("unset autoscale");
                    printStream.println("set autoscale y");
                    printStream.println("set nologscale x");
                    printStream.println("set nologscale y");
                    printStream.println(new StringBuffer().append("set yrange [1:").append(n).append("]").toString());
                    printStream.println("set xrange [0.5:*]");
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d5).append(",").append(d2).toString());
                    printStream.println("set title \"Value of variables activity\"");
                    gnuplotDataFile = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-heuristics.dat").toString(), Color.red, ACTIVITY_BASED, "lines");
                    printStream.println(this.gnuplotPreferences.generatePlotLine(gnuplotDataFile, gnuplotFunction, "", false));
                }
                if (this.gnuplotPreferences.isDisplaySpeed()) {
                    printStream.println("set autoscale x");
                    printStream.println("set nologscale x");
                    printStream.println("set nologscale y");
                    printStream.println(new StringBuffer().append("set size ").append(d7).append(",").append(d8).toString());
                    printStream.println(new StringBuffer().append("set origin ").append(d5).append(",").append(d).toString());
                    printStream.println("set title \"Number of propagations per second\"");
                    gnuplotDataFile = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-speed.dat").toString(), Color.cyan, "Speed", "lines");
                    object2 = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-speed-clean.dat").toString(), Color.orange, "Clean", "impulses");
                    object = new GnuplotDataFile(new StringBuffer().append(this.instancePath).append("-speed-restart.dat").toString(), Color.gray, RESTART, "impulses");
                    printStream.println(this.gnuplotPreferences.generatePlotLineOnDifferenteAxes(new GnuplotDataFile[]{gnuplotDataFile}, new GnuplotDataFile[]{object2, object}, true, 50));
                }
                printStream.println("unset multiplot");
                double d9 = this.gnuplotPreferences.getRefreshTime() / 1000;
                printStream.println(new StringBuffer().append("pause ").append(d9).toString());
                printStream.println("reread");
                printStream.close();
                this.log("Gnuplot will start in a few seconds.");
                object = new Thread(){

                    public void run() {
                        try {
                            String string;
                            try {
                                Thread.sleep(DetailedCommandPanel.this.gnuplotPreferences.getTimeBeforeLaunching());
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            DetailedCommandPanel.this.gnuplotProcess = Runtime.getRuntime().exec(DetailedCommandPanel.this.gnuplotPreferences.createCommandLine(DetailedCommandPanel.this.instancePath + "-gnuplot.gnuplot"));
                            DetailedCommandPanel.this.log("Gnuplot should have started now.");
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(DetailedCommandPanel.this.gnuplotProcess.getErrorStream()));
                            while ((string = bufferedReader.readLine()) != null) {
                                if (string.trim().length() <= 0 || string.toLowerCase().contains("warning") || string.toLowerCase().contains("plot")) continue;
                                System.out.println(string);
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                };
                ((Thread)object).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void stopGnuplot() {
        if (this.gnuplotProcess != null) {
            this.gnuplotProcess.destroy();
            this.log("Gnuplot should be deactivated...");
        }
        this.gnuplotProcess = null;
    }

    public GnuplotPreferences getGnuplotPreferences() {
        return this.gnuplotPreferences;
    }

    public void setGnuplotPreferences(GnuplotPreferences gnuplotPreferences) {
        this.gnuplotPreferences = gnuplotPreferences;
    }

    public DetailedCommandPanel getThis() {
        return this;
    }

    public ISolver getSolver() {
        return (ISolver)this.problem;
    }

    public void init(ISolverService iSolverService) {
    }

    @Override
    public void assuming(int n) {
    }

    @Override
    public void propagating(int n, IConstr iConstr) {
    }

    @Override
    public void backtracking(int n) {
    }

    @Override
    public void adding(int n) {
    }

    @Override
    public void learn(IConstr iConstr) {
    }

    @Override
    public void delete(int[] nArray) {
    }

    @Override
    public void conflictFound(IConstr iConstr, int n, int n2) {
    }

    @Override
    public void conflictFound(int n) {
    }

    @Override
    public void solutionFound(int[] nArray) {
        this.log("Found a solution !! ");
        this.logsameline(this.stringWriter.toString());
        this.stringWriter.getBuffer().delete(0, this.stringWriter.getBuffer().length());
    }

    @Override
    public void beginLoop() {
    }

    @Override
    public void start() {
    }

    @Override
    public void end(Lbool lbool) {
    }

    @Override
    public void restarting() {
    }

    @Override
    public void backjump(int n) {
    }

    @Override
    public void cleaning() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$sat$DetailedCommandPanel == null ? (class$org$sat4j$sat$DetailedCommandPanel = DetailedCommandPanel.class$("org.sat4j.sat.DetailedCommandPanel")) : class$org$sat4j$sat$DetailedCommandPanel).desiredAssertionStatus();
        border5 = new EmptyBorder(5, 5, 5, 5);
        cleanValues = new int[]{5000, 10000, 20000, 50000, 100000, 500000};
    }

    public class MyTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = 1L;

        public void setSelectedIndex(int n) {
            if (this.getTabCount() == 5 && n == this.getTabCount() - 1) {
                if (DetailedCommandPanel.this.solver != null && DetailedCommandPanel.this.startStopButton.getText().equals(DetailedCommandPanel.STOP)) {
                    String string = DetailedCommandPanel.this.solver.toString();
                    String string2 = DetailedCommandPanel.this.solver.toString();
                    int n2 = 0;
                    for (int i = 0; i < string.length(); ++i) {
                        n2 = string.charAt(i) != '\n' ? ++n2 : 0;
                        if (n2 <= 80) continue;
                        string2 = new StringBuffer(string2).insert(i, '\n').toString();
                        n2 = 0;
                    }
                    DetailedCommandPanel.this.textArea.setText(string2);
                    DetailedCommandPanel.this.textArea.setEditable(false);
                    DetailedCommandPanel.this.textArea.repaint();
                    DetailedCommandPanel.this.aboutSolverPanel.paint(DetailedCommandPanel.this.aboutSolverPanel.getGraphics());
                    DetailedCommandPanel.this.aboutSolverPanel.repaint();
                } else {
                    DetailedCommandPanel.this.textArea.setText("No solver is running at the moment");
                    DetailedCommandPanel.this.textArea.repaint();
                    DetailedCommandPanel.this.textArea.setEditable(false);
                    DetailedCommandPanel.this.aboutSolverPanel.paint(DetailedCommandPanel.this.aboutSolverPanel.getGraphics());
                    DetailedCommandPanel.this.aboutSolverPanel.repaint();
                }
            }
            super.setSelectedIndex(n);
        }
    }
}

