/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.sat4j.sat.GnuplotPreferences;

public class GnuplotPreferencesFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GnuplotPreferences preferences;
    private JPanel mainPanel;
    private JPanel gnuplotOptionsPanel;
    private JPanel graphPanel;
    private JLabel backgroundColorLabel;
    private static final String BACKGROUND_COLOR = "Background color: ";
    private JButton bgButton;
    private JLabel borderColorLabel;
    private static final String BORDER_COLOR = "Border color: ";
    private JButton borderButton;
    private JLabel nbLinesReadLabel;
    private static final String NB_LINE = "Number of lines that should be displayed: ";
    private JTextField nbLinesTextField;
    private JLabel refreshTimeLabel;
    private static final String REFRESH_TIME = "Refresh Time (in ms): ";
    private JTextField refreshTimeField;
    private JLabel timeBeforeLaunchLabel;
    private static final String TIME_BEFORE_LAUNCHING = "Time before launching gnuplot (in ms): ";
    private JTextField timeBeforeLaunchField;
    private JCheckBox displayRestartsCheckBox;
    private static final String DISPLAY_RESTARTS = "Display restarts";
    private JLabel restartColorLabel;
    private static final String RESTART_COLOR = "Restart color";
    private JButton restartButton;
    private JCheckBox slidingWindows;
    private static final String SLIDING_WINDOWS = "Use sliding windows";
    private JCheckBox displayDecisionIndexesCB;
    private static final String DECISION_INDEX = "Show index of decision variables";
    private JCheckBox displaySpeedCB;
    private static final String SPEED = "Show number of assignments per second";
    private JCheckBox displayConflictsTrailCB;
    private static final String CONFLICTS_TRAIL = "Show trail level when a conflict occurs";
    private JCheckBox displayConflictsDecisionCB;
    private static final String CONFLICTS_DECISION = "Show decision level when a conflict occurs";
    private JCheckBox displayVariablesEvaluationCB;
    private static final String VARIABLE_EVALUATION = "Show variables evaluation";
    private JCheckBox displayClausesEvaluationCB;
    private static final String CLAUSES_EVALUATION = "Show clauses evauluation";
    private JCheckBox displayClausesSizeCB;
    private static final String CLAUSES_SIZE = "Show size of learned clauses";
    private JButton okButton;
    private static final String OK = "OK";

    public GnuplotPreferencesFrame() {
        this(new GnuplotPreferences());
    }

    public GnuplotPreferencesFrame(GnuplotPreferences gnuplotPreferences) {
        super("Gnuplot preferences");
        this.preferences = gnuplotPreferences;
        this.createAndShowGUI();
    }

    public void createAndShowGUI() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.createMainPanel();
        JScrollPane jScrollPane = new JScrollPane(this.mainPanel);
        this.add(jScrollPane);
        this.pack();
        this.setVisible(false);
    }

    public void createMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.gnuplotOptionsPanel = new JPanel();
        this.gnuplotOptionsPanel.setName("Gnuplot options");
        this.gnuplotOptionsPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.gnuplotOptionsPanel.getName(), 1, 2), new EmptyBorder(5, 5, 5, 5)));
        this.gnuplotOptionsPanel.setLayout(new GridLayout(0, 2, 5, 5));
        this.backgroundColorLabel = new JLabel(BACKGROUND_COLOR);
        this.bgButton = new JButton("");
        this.bgButton.setOpaque(true);
        this.bgButton.setBorderPainted(false);
        this.bgButton.setBackground(this.preferences.getBackgroundColor());
        this.bgButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(GnuplotPreferencesFrame.this.getFrame(), "Background Color", GnuplotPreferencesFrame.this.bgButton.getBackground());
                GnuplotPreferencesFrame.this.preferences.setBackgroundColor(color);
                GnuplotPreferencesFrame.this.bgButton.setBackground(color);
            }
        });
        this.gnuplotOptionsPanel.add(this.backgroundColorLabel);
        this.gnuplotOptionsPanel.add(this.bgButton);
        this.borderColorLabel = new JLabel(BORDER_COLOR);
        this.borderButton = new JButton("");
        this.borderButton.setOpaque(true);
        this.borderButton.setBorderPainted(false);
        this.borderButton.setBackground(this.preferences.getBorderColor());
        this.borderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(GnuplotPreferencesFrame.this.getFrame(), "Border Color", GnuplotPreferencesFrame.this.borderButton.getBackground());
                GnuplotPreferencesFrame.this.preferences.setBorderColor(color);
                GnuplotPreferencesFrame.this.borderButton.setBackground(color);
            }
        });
        this.gnuplotOptionsPanel.add(this.borderColorLabel);
        this.gnuplotOptionsPanel.add(this.borderButton);
        this.slidingWindows = new JCheckBox(SLIDING_WINDOWS);
        this.slidingWindows.setSelected(this.preferences.isSlidingWindows());
        this.slidingWindows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.nbLinesReadLabel.setEnabled(GnuplotPreferencesFrame.this.slidingWindows.isSelected());
                GnuplotPreferencesFrame.this.nbLinesTextField.setEnabled(GnuplotPreferencesFrame.this.slidingWindows.isSelected());
                GnuplotPreferencesFrame.this.preferences.setSlidingWindows(GnuplotPreferencesFrame.this.slidingWindows.isSelected());
            }
        });
        this.gnuplotOptionsPanel.add(this.slidingWindows);
        this.gnuplotOptionsPanel.add(new JLabel());
        this.nbLinesReadLabel = new JLabel(NB_LINE);
        this.nbLinesTextField = new JTextField(this.preferences.getNbLinesRead() + "");
        this.nbLinesReadLabel.setEnabled(this.slidingWindows.isSelected());
        this.nbLinesTextField.setEnabled(this.slidingWindows.isSelected());
        this.gnuplotOptionsPanel.add(this.nbLinesReadLabel);
        this.gnuplotOptionsPanel.add(this.nbLinesTextField);
        this.refreshTimeLabel = new JLabel(REFRESH_TIME);
        this.refreshTimeField = new JTextField(this.preferences.getRefreshTime() + "");
        this.gnuplotOptionsPanel.add(this.refreshTimeLabel);
        this.gnuplotOptionsPanel.add(this.refreshTimeField);
        this.timeBeforeLaunchLabel = new JLabel(TIME_BEFORE_LAUNCHING);
        this.timeBeforeLaunchField = new JTextField(this.preferences.getTimeBeforeLaunching() + "");
        this.gnuplotOptionsPanel.add(this.timeBeforeLaunchLabel);
        this.gnuplotOptionsPanel.add(this.timeBeforeLaunchField);
        this.displayRestartsCheckBox = new JCheckBox(DISPLAY_RESTARTS);
        this.displayRestartsCheckBox.setSelected(this.preferences.isDisplayRestarts());
        this.displayRestartsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.restartColorLabel.setEnabled(GnuplotPreferencesFrame.this.displayRestartsCheckBox.isSelected());
                GnuplotPreferencesFrame.this.restartButton.setEnabled(GnuplotPreferencesFrame.this.displayRestartsCheckBox.isSelected());
                GnuplotPreferencesFrame.this.preferences.setDisplayRestarts(GnuplotPreferencesFrame.this.displayRestartsCheckBox.isSelected());
            }
        });
        this.gnuplotOptionsPanel.add(this.displayRestartsCheckBox);
        this.gnuplotOptionsPanel.add(new JLabel());
        this.restartColorLabel = new JLabel(RESTART_COLOR);
        this.restartButton = new JButton("");
        this.restartButton.setOpaque(true);
        this.restartButton.setBorderPainted(false);
        this.restartButton.setBackground(this.preferences.getRestartColor());
        this.restartColorLabel.setEnabled(this.displayRestartsCheckBox.isSelected());
        this.restartButton.setEnabled(this.displayRestartsCheckBox.isSelected());
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(GnuplotPreferencesFrame.this.getFrame(), "Restart Color", GnuplotPreferencesFrame.this.restartButton.getBackground());
                GnuplotPreferencesFrame.this.preferences.setRestartColor(color);
                GnuplotPreferencesFrame.this.restartButton.setBackground(color);
            }
        });
        this.gnuplotOptionsPanel.add(this.restartColorLabel);
        this.gnuplotOptionsPanel.add(this.restartButton);
        this.okButton = new JButton(OK);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.getFrame().setVisible(false);
            }
        });
        this.graphPanel = new JPanel();
        this.graphPanel.setLayout(new BoxLayout(this.graphPanel, 1));
        this.graphPanel.setName("Possible Graphs");
        this.graphPanel.setBorder(new CompoundBorder(new TitledBorder(null, this.graphPanel.getName(), 1, 2), new EmptyBorder(5, 5, 5, 5)));
        this.displayClausesEvaluationCB = new JCheckBox(CLAUSES_EVALUATION);
        this.graphPanel.add(this.displayClausesEvaluationCB);
        this.displayClausesEvaluationCB.setSelected(this.preferences.isDisplayClausesEvaluation());
        this.displayClausesEvaluationCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.preferences.setDisplayClausesEvaluation(GnuplotPreferencesFrame.this.displayClausesEvaluationCB.isSelected());
            }
        });
        this.displayClausesSizeCB = new JCheckBox(CLAUSES_SIZE);
        this.graphPanel.add(this.displayClausesSizeCB);
        this.displayClausesSizeCB.setSelected(this.preferences.isDisplayClausesSize());
        this.displayClausesSizeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.preferences.setDisplayClausesSize(GnuplotPreferencesFrame.this.displayClausesSizeCB.isSelected());
            }
        });
        this.displayConflictsDecisionCB = new JCheckBox(CONFLICTS_DECISION);
        this.graphPanel.add(this.displayConflictsDecisionCB);
        this.displayConflictsDecisionCB.setSelected(this.preferences.isDisplayConflictsDecision());
        this.displayConflictsDecisionCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.preferences.setDisplayConflictsDecision(GnuplotPreferencesFrame.this.displayConflictsDecisionCB.isSelected());
            }
        });
        this.displayConflictsTrailCB = new JCheckBox(CONFLICTS_TRAIL);
        this.graphPanel.add(this.displayConflictsTrailCB);
        this.displayConflictsTrailCB.setSelected(this.preferences.isDisplayConflictsTrail());
        this.displayConflictsTrailCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.preferences.setDisplayConflictsTrail(GnuplotPreferencesFrame.this.displayConflictsTrailCB.isSelected());
            }
        });
        this.displayDecisionIndexesCB = new JCheckBox(DECISION_INDEX);
        this.graphPanel.add(this.displayDecisionIndexesCB);
        this.displayDecisionIndexesCB.setSelected(this.preferences.isDisplayDecisionIndexes());
        this.displayDecisionIndexesCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.preferences.setDisplayDecisionIndexes(GnuplotPreferencesFrame.this.displayDecisionIndexesCB.isSelected());
            }
        });
        this.displaySpeedCB = new JCheckBox(SPEED);
        this.graphPanel.add(this.displaySpeedCB);
        this.displaySpeedCB.setSelected(this.preferences.isDisplaySpeed());
        this.displaySpeedCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.preferences.setDisplaySpeed(GnuplotPreferencesFrame.this.displaySpeedCB.isSelected());
            }
        });
        this.displayVariablesEvaluationCB = new JCheckBox(VARIABLE_EVALUATION);
        this.graphPanel.add(this.displayVariablesEvaluationCB);
        this.displayVariablesEvaluationCB.setSelected(this.preferences.isDisplayVariablesEvaluation());
        this.displayVariablesEvaluationCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GnuplotPreferencesFrame.this.preferences.setDisplayVariablesEvaluation(GnuplotPreferencesFrame.this.displayVariablesEvaluationCB.isSelected());
            }
        });
        this.mainPanel.add((Component)this.gnuplotOptionsPanel, "North");
        this.mainPanel.add((Component)this.graphPanel, "Center");
        this.mainPanel.add((Component)this.okButton, "South");
    }

    public JFrame getFrame() {
        return this;
    }
}

