/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.orders.RandomWalkDecoratorObjective;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.pb.reader.PBInstanceReader;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.sat.RTSI;
import org.sat4j.sat.RemoteControlFrame;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ConflictDepthTracing;
import org.sat4j.tools.ConflictLevelTracing;
import org.sat4j.tools.DecisionTracing;
import org.sat4j.tools.DotSearchTracing;
import org.sat4j.tools.LearnedClausesSizeTracing;
import org.sat4j.tools.MultiTracing;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lanceur
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";
    private static final String PACKAGE_ORDERS = "org.sat4j.minisat.orders";
    private static final String PACKAGE_LEARNING = "org.sat4j.minisat.learning";
    private static final String PACKAGE_RESTARTS = "org.sat4j.minisat.restarts";
    private static final String PACKAGE_PHASE = "org.sat4j.minisat.orders";
    private static final String PACKAGE_PARAMS = "org.sat4j.minisat.core";
    private static final String ORDERS = "ORDERS";
    private static final String LEARNING = "LEARNING";
    private static final String RESTARTS = "RESTARTS";
    private static final String PHASE = "PHASE";
    private static final String PARAMS = "PARAMS";
    private static final String SIMP = "SIMP";
    private static final String RESTART_STRATEGY_NAME = "org.sat4j.minisat.core.RestartStrategy";
    private static final String ORDER_NAME = "org.sat4j.minisat.core.IOrder";
    private static final String LEARNING_NAME = "org.sat4j.minisat.core.LearningStrategy";
    private static final String PHASE_NAME = "org.sat4j.minisat.core.IPhaseSelectionStrategy";
    private static final String PARAMS_NAME = "org.sat4j.minisat.core.SearchParams";
    private static final Map<String, String> qualif;
    private boolean incomplete = false;
    private boolean isModeOptimization = false;
    private IProblem problem;
    private ICDCL cdclSolver;
    private boolean modeTracing = false;
    private boolean launchRemoteControl;
    static AbstractLauncher lanceur;
    protected ASolverFactory<ISolver> factory;
    private String filename;
    private int k = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$sat$Lanceur;

    public static void main(String[] stringArray) {
        lanceur = new Lanceur();
        lanceur.run(stringArray);
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("C", "conflictbased", false, "conflict based timeout (for deterministic behavior)");
        options.addOption("d", "dot", true, "creates a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        options.addOption("k", "kleast", true, "limit the search to models having at least k variables set to false");
        options.addOption("r", "trace", false, "traces the behavior of the solver");
        options.addOption("opt", "optimize", false, "uses solver in optimize mode instead of sat mode (default)");
        options.addOption("rw", "randomWalk", true, "specifies the random walk probability ");
        options.addOption("remote", "remoteControl", false, "launches remote control");
        options.addOption("H", "hot", false, "keep the solver hot (do not reset heuristics) when a model is found");
        options.addOption("y", "simplify", false, "simplify the set of clauses is possible");
        Option option = options.getOption("l");
        option.setArgName("libname");
        option = options.getOption("s");
        option.setArgName("solvername");
        option = options.getOption("S");
        option.setArgName("solverStringDefinition");
        option = options.getOption("t");
        option.setArgName("number");
        option = options.getOption("T");
        option.setArgName("number");
        option = options.getOption("C");
        option.setArgName("number");
        option = options.getOption("k");
        option.setArgName("number");
        option = options.getOption("d");
        option.setArgName("filename");
        option = options.getOption("f");
        option.setArgName("filename");
        option = options.getOption("r");
        option.setArgName("searchlistener");
        option = options.getOption("rw");
        option.setArgName("number");
        return options;
    }

    @Override
    protected ICDCL configureSolver(String[] stringArray) {
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            return null;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Serializable serializable;
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            if (commandLine.hasOption("opt")) {
                this.isModeOptimization = true;
            }
            String string = commandLine.getOptionValue("l");
            if (this.isModeOptimization) {
                string = "pb";
            } else if (string == null) {
                string = "minisat";
            }
            try {
                serializable = Class.forName(new StringBuffer().append("org.sat4j.").append(string).append(".SolverFactory").toString());
                object3 = new Class[]{};
                object2 = ((Class)serializable).getMethod("instance", (Class<?>)object3);
                this.factory = (ASolverFactory)((Method)object2).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                this.log(new StringBuffer().append("Wrong framework: ").append(string).append(". Using minisat instead.").toString());
                this.factory = SolverFactory.instance();
            }
            if (commandLine.hasOption("s")) {
                object3 = commandLine.getOptionValue("s");
                if (object3 == null) {
                    this.log("No solver for option s. Launching default solver.");
                    this.log(new StringBuffer().append("Available solvers: ").append(Arrays.asList(this.factory.solverNames())).toString());
                    serializable = (Solver)this.factory.defaultSolver();
                } else {
                    serializable = (Solver)this.factory.createSolverByName((String)object3);
                }
            } else {
                serializable = (Solver)this.factory.defaultSolver();
            }
            if (commandLine.hasOption("S")) {
                object3 = commandLine.getOptionValue("S");
                if (object3 == null) {
                    this.stringUsage();
                    return null;
                }
                serializable = this.configureFromString((String)object3, (ICDCL)serializable);
            }
            if (commandLine.hasOption("rw")) {
                double d = Double.parseDouble(commandLine.getOptionValue("rw"));
                object = serializable.getOrder();
                object = this.isModeOptimization && object instanceof VarOrderHeapObjective ? new RandomWalkDecoratorObjective((VarOrderHeapObjective)object, d) : new RandomWalkDecorator((VarOrderHeap)object, d);
                serializable.setOrder((IOrder)object);
            }
            this.launchRemoteControl = commandLine.hasOption("remote");
            String string2 = commandLine.getOptionValue("t");
            if (string2 == null) {
                string2 = commandLine.getOptionValue("T");
                if (string2 != null) {
                    serializable.setTimeoutMs(Long.parseLong(string2));
                }
            } else if (commandLine.hasOption("C")) {
                serializable.setTimeoutOnConflicts(Integer.parseInt(string2));
            } else {
                serializable.setTimeout(Integer.parseInt(string2));
            }
            this.filename = commandLine.getOptionValue("f");
            if (commandLine.hasOption("d")) {
                object2 = null;
                if (this.filename != null) {
                    object2 = commandLine.getOptionValue("d");
                }
                if (object2 == null) {
                    object2 = "sat4j.dot";
                }
                serializable.setSearchListener(new DotSearchTracing((String)object2, null));
            }
            if (commandLine.hasOption("m")) {
                this.setSilent(true);
            }
            if (commandLine.hasOption("H")) {
                serializable.setKeepSolverHot(true);
            }
            if (commandLine.hasOption("k") && (object2 = Integer.valueOf(commandLine.getOptionValue("k"))) != null) {
                this.k = (Integer)object2;
            }
            if (commandLine.hasOption("y")) {
                serializable.setDBSimplificationAllowed(true);
            }
            if (this.isModeOptimization) {
                if (!$assertionsDisabled && !(serializable instanceof IPBSolver)) {
                    throw new AssertionError();
                }
                this.problem = new PseudoOptDecorator((IPBCDCLSolver)serializable);
            }
            int n = 0;
            object = commandLine.getArgs();
            if (this.filename == null && ((String[])object).length > 0) {
                this.filename = object[n++];
            }
            if (commandLine.hasOption("r")) {
                this.modeTracing = true;
                serializable.setSearchListener(new MultiTracing(new SearchListener[]{new ConflictLevelTracing(new StringBuffer().append(this.filename).append("-conflict-level").toString()), new DecisionTracing(new StringBuffer().append(this.filename).append("-decision-indexes").toString()), new LearnedClausesSizeTracing(new StringBuffer().append(this.filename).append("-learned-clauses-size").toString()), new ConflictDepthTracing(new StringBuffer().append(this.filename).append("-conflict-depth").toString())}));
            }
            while (n < ((String[])object).length) {
                String[] stringArray2 = object[n].split("=");
                if (!$assertionsDisabled && stringArray2.length != 2) {
                    throw new AssertionError();
                }
                this.log(new StringBuffer().append("setting ").append(stringArray2[0]).append(" to ").append(stringArray2[1]).toString());
                try {
                    BeanUtils.setProperty(serializable, stringArray2[0], stringArray2[1]);
                }
                catch (Exception exception) {
                    this.log(new StringBuffer().append("Cannot set parameter : ").append(stringArray[n]).toString());
                }
                ++n;
            }
            this.getLogWriter().println(serializable.toString("c "));
            return serializable;
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        if (iSolver instanceof IPBSolver) {
            return new PBInstanceReader((IPBSolver)iSolver);
        }
        return new InstanceReader(iSolver);
    }

    @Override
    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    @Override
    public void usage() {
        this.factory = SolverFactory.instance();
        this.showAvailableSolvers(this.factory, "sat");
        this.log("-------------------");
        this.factory = org.sat4j.pb.SolverFactory.instance();
        this.showAvailableSolvers(this.factory, "pb");
        this.showAvailableRestarts();
        this.showAvailableOrders();
        this.showAvailableLearning();
        this.showAvailablePhase();
        this.showParams();
        this.showSimplifiers();
        this.stringUsage();
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        return this.filename;
    }

    private final ICDCL configureFromString(String string, ICDCL iCDCL) {
        String string2;
        SearchParams searchParams;
        String string3;
        RestartStrategy restartStrategy;
        IPhaseSelectionStrategy iPhaseSelectionStrategy;
        IOrder iOrder;
        LearningStrategy learningStrategy;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            String[] stringArray = string4.split("=");
            properties.setProperty(stringArray[0], stringArray[1]);
        }
        Solver solver = (Solver)iCDCL;
        DataStructureFactory dataStructureFactory = (DataStructureFactory)this.setupObject("DSF", properties);
        if (dataStructureFactory != null) {
            iCDCL.setDataStructureFactory(dataStructureFactory);
        }
        if ((learningStrategy = (LearningStrategy)this.setupObject(LEARNING, properties)) != null) {
            iCDCL.setLearner(learningStrategy);
            learningStrategy.setSolver(solver);
        }
        if ((iOrder = (IOrder)this.setupObject(ORDERS, properties)) != null) {
            iCDCL.setOrder(iOrder);
        }
        if ((iPhaseSelectionStrategy = (IPhaseSelectionStrategy)this.setupObject(PHASE, properties)) != null) {
            iCDCL.getOrder().setPhaseSelectionStrategy(iPhaseSelectionStrategy);
        }
        if ((restartStrategy = (RestartStrategy)this.setupObject(RESTARTS, properties)) != null) {
            iCDCL.setRestartStrategy(restartStrategy);
        }
        if ((string3 = properties.getProperty(SIMP)) != null) {
            this.log(new StringBuffer().append("read ").append(string3).toString());
            this.log("configuring SIMP");
            iCDCL.setSimplifier(SimplificationType.valueOf(string3));
        }
        if ((searchParams = (SearchParams)this.setupObject(PARAMS, properties)) != null) {
            iCDCL.setSearchParams(searchParams);
        }
        if ("GLUCOSE".equalsIgnoreCase(string2 = properties.getProperty("MEMORY"))) {
            this.log("configuring MEMORY");
            iCDCL.setLearnedConstraintsDeletionStrategy(solver.glucose);
        }
        return iCDCL;
    }

    private void stringUsage() {
        this.log("Available building blocks: DSF, LEARNING, ORDERS, PHASE, RESTARTS, SIMP, PARAMS");
        this.log("Example: -S RESTARTS=LubyRestarts/factor:512,LEARNING=MiniSATLearning");
    }

    private final <T> T setupObject(String string, Properties properties) {
        try {
            String string2 = properties.getProperty(string);
            String string3 = qualif.get(string);
            if (string2 == null) {
                return null;
            }
            if (string3 != null) {
                this.log(new StringBuffer().append("read ").append(string3).append(".").append(string2).toString());
                if (string2.contains("Objective") && string3.contains("minisat")) {
                    string3 = string3.replaceFirst("minisat", "pb");
                }
                string2 = new StringBuffer().append(string3).append(".").append(string2).toString();
            }
            this.log(new StringBuffer().append("configuring ").append(string).toString());
            String[] stringArray = string2.split("/");
            Object obj = Class.forName(stringArray[0]).newInstance();
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                if (!$assertionsDisabled && stringArray2.length != 2) {
                    throw new AssertionError();
                }
                try {
                    BeanUtils.getProperty(obj, stringArray2[0]);
                    BeanUtils.setProperty(obj, stringArray2[0], stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    this.log(new StringBuffer().append("Problem with component ").append(stringArray[0]).append(" ").append(exception).toString());
                }
            }
            return (T)obj;
        }
        catch (InstantiationException instantiationException) {
            this.log(new StringBuffer().append("Problem with component ").append(string).append(" ").append(instantiationException).toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log(new StringBuffer().append("Problem with component ").append(string).append(" ").append(illegalAccessException).toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log(new StringBuffer().append("Problem with component ").append(string).append(" ").append(classNotFoundException).toString());
        }
        return null;
    }

    @Override
    protected IProblem readProblem(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        ISolver iSolver = (ISolver)super.readProblem(string);
        if (this.k > 0) {
            VecInt vecInt = new VecInt();
            for (int i = 1; i <= iSolver.nVars(); ++i) {
                vecInt.push(-i);
            }
            iSolver.addAtLeast(vecInt, this.k);
            this.log(new StringBuffer().append("Limiting solutions to those having at least ").append(this.k).append(" variables assigned to false").toString());
        }
        return iSolver;
    }

    @Override
    protected void solve(IProblem iProblem) throws TimeoutException {
        block12: {
            if (this.isModeOptimization) {
                boolean bl = false;
                IOptimizationProblem iOptimizationProblem = (IOptimizationProblem)iProblem;
                try {
                    while (iOptimizationProblem.admitABetterSolution()) {
                        if (!bl) {
                            if (iOptimizationProblem.nonOptimalMeansSatisfiable()) {
                                this.setExitCode(ExitCode.SATISFIABLE);
                                if (iOptimizationProblem.hasNoObjectiveFunction()) {
                                    return;
                                }
                                this.log("SATISFIABLE");
                            } else if (this.incomplete) {
                                this.setExitCode(ExitCode.UPPER_BOUND);
                            }
                            bl = true;
                            this.log("OPTIMIZING...");
                        }
                        this.log(new StringBuffer().append("Got one! Elapsed wall clock time (in seconds):").append((double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0).toString());
                        this.getLogWriter().println(new StringBuffer().append(CURRENT_OPTIMUM_VALUE_PREFIX).append(iOptimizationProblem.getObjectiveValue()).toString());
                        iOptimizationProblem.discardCurrentSolution();
                    }
                    if (bl) {
                        this.setExitCode(ExitCode.OPTIMUM_FOUND);
                        break block12;
                    }
                    this.setExitCode(ExitCode.UNSATISFIABLE);
                }
                catch (ContradictionException contradictionException) {
                    if (!$assertionsDisabled && !bl) {
                        throw new AssertionError();
                    }
                    this.setExitCode(ExitCode.OPTIMUM_FOUND);
                }
            } else {
                this.exitCode = iProblem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
            }
        }
    }

    @Override
    protected void displayResult() {
        if (this.isModeOptimization) {
            this.displayAnswer();
            this.log(new StringBuffer().append("Total wall clock time (in seconds): ").append((double)(System.currentTimeMillis() - this.getBeginTime()) / 1000.0).toString());
        } else {
            super.displayResult();
        }
    }

    protected void displayAnswer() {
        if (this.solver == null) {
            return;
        }
        System.out.flush();
        PrintWriter printWriter = this.getLogWriter();
        printWriter.flush();
        this.solver.printStat(printWriter, "c ");
        this.solver.printInfos(printWriter, "c ");
        ExitCode exitCode = this.getExitCode();
        printWriter.println(new StringBuffer().append("s ").append(exitCode).toString());
        if (exitCode == ExitCode.SATISFIABLE || exitCode == ExitCode.OPTIMUM_FOUND || this.incomplete && exitCode == ExitCode.UPPER_BOUND) {
            IOptimizationProblem iOptimizationProblem;
            printWriter.print("v ");
            this.getReader().decode(this.problem.model(), printWriter);
            printWriter.println();
            if (this.isModeOptimization && !(iOptimizationProblem = (IOptimizationProblem)this.problem).hasNoObjectiveFunction()) {
                this.log(new StringBuffer().append("objective function=").append(iOptimizationProblem.getObjectiveValue()).toString());
            }
        }
    }

    protected void showAvailableRestarts() {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = RTSI.find(RESTART_STRATEGY_NAME);
        for (String string : vector2) {
            if (string.contains("Remote")) continue;
            try {
                Set set = BeanUtils.describe(Class.forName(new StringBuffer().append("org.sat4j.minisat.restarts.").append(string).toString()).newInstance()).keySet();
                set.remove("class");
                if (set.size() > 0) {
                    vector.add(new StringBuffer().append(string).append(set).toString());
                    continue;
                }
                vector.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        this.log(new StringBuffer().append("Available restart strategies (RESTARTS): ").append(vector).toString());
    }

    protected void showAvailablePhase() {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = RTSI.find(PHASE_NAME);
        for (String string : vector2) {
            if (string.contains("Remote")) continue;
            try {
                Set set = BeanUtils.describe(Class.forName(new StringBuffer().append("org.sat4j.minisat.orders.").append(string).toString()).newInstance()).keySet();
                set.remove("class");
                if (set.size() > 0) {
                    vector.add(new StringBuffer().append(string).append(set).toString());
                    continue;
                }
                vector.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        this.log(new StringBuffer().append("Available phase strategies (PHASE): ").append(vector).toString());
    }

    protected void showAvailableLearning() {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = RTSI.find(LEARNING_NAME);
        for (String string : vector2) {
            try {
                Set set = BeanUtils.describe(Class.forName(new StringBuffer().append("org.sat4j.minisat.learning.").append(string).toString()).newInstance()).keySet();
                set.remove("class");
                if (set.size() > 0) {
                    vector.add(new StringBuffer().append(string).append(set).toString());
                    continue;
                }
                vector.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                vector.add(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        this.log(new StringBuffer().append("Available learning (LEARNING): ").append(vector).toString());
    }

    protected void showAvailableOrders() {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = RTSI.find(ORDER_NAME);
        Set set = null;
        for (String string : vector2) {
            if (string.contains("Remote")) continue;
            try {
                if (string.contains("Objective")) {
                    String string2 = "org.sat4j.minisat.orders".replaceFirst("minisat", "pb");
                    set = BeanUtils.describe(Class.forName(new StringBuffer().append(string2).append(".").append(string).toString()).newInstance()).keySet();
                } else {
                    set = BeanUtils.describe(Class.forName(new StringBuffer().append("org.sat4j.minisat.orders.").append(string).toString()).newInstance()).keySet();
                }
                set.remove("class");
                if (set.size() > 0) {
                    vector.add(new StringBuffer().append(string).append(set).toString());
                    continue;
                }
                vector.add(string);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        this.log(new StringBuffer().append("Available orders (ORDERS): ").append(vector).toString());
    }

    protected void showParams() {
        Set set = null;
        try {
            set = BeanUtils.describe(Class.forName(PARAMS_NAME).newInstance()).keySet();
            set.remove("class");
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        this.log(new StringBuffer().append("Available search params (PARAMS): [SearchParams").append(set).append("]").toString());
    }

    protected void showSimplifiers() {
        this.log("Available simplifiers : [NO_SIMPLIFICATION, SIMPLE_SIMPLIFICATION, EXPENSIVE_SIMPLIFICATION]");
    }

    @Override
    public void run(String[] stringArray) {
        block13: {
            try {
                String string;
                this.displayHeader();
                this.cdclSolver = this.configureSolver(stringArray);
                this.solver = this.cdclSolver;
                if (this.solver == null) {
                    this.usage();
                    return;
                }
                if (!this.silent) {
                    this.solver.setVerbose(true);
                }
                if ((string = this.getInstanceName(stringArray)) == null) {
                    this.usage();
                    return;
                }
                this.beginTime = System.currentTimeMillis();
                if (!this.launchRemoteControl) {
                    this.readProblem(string);
                    try {
                        if (this.problem != null) {
                            this.solve(this.problem);
                        } else {
                            this.solve(this.solver);
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        this.log("timeout");
                    }
                    System.exit(lanceur.getExitCode().value());
                    break block13;
                }
                RemoteControlFrame remoteControlFrame = new RemoteControlFrame(this.filename, "", this.cdclSolver);
                remoteControlFrame.activateGnuplotTracing(this.modeTracing);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(new StringBuffer().append("FATAL ").append(fileNotFoundException.getLocalizedMessage()).toString());
            }
            catch (IOException iOException) {
                System.err.println(new StringBuffer().append("FATAL ").append(iOException.getLocalizedMessage()).toString());
            }
            catch (ContradictionException contradictionException) {
                this.exitCode = ExitCode.UNSATISFIABLE;
                this.log("(trivial inconsistency)");
            }
            catch (ParseFormatException parseFormatException) {
                System.err.println(new StringBuffer().append("FATAL ").append(parseFormatException.getLocalizedMessage()).toString());
            }
        }
    }

    @Override
    protected /* synthetic */ ISolver configureSolver(String[] stringArray) {
        return this.configureSolver(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$sat$Lanceur == null ? (class$org$sat4j$sat$Lanceur = Lanceur.class$("org.sat4j.sat.Lanceur")) : class$org$sat4j$sat$Lanceur).desiredAssertionStatus();
        qualif = new HashMap<String, String>();
        qualif.put(ORDERS, "org.sat4j.minisat.orders");
        qualif.put(LEARNING, PACKAGE_LEARNING);
        qualif.put(RESTARTS, PACKAGE_RESTARTS);
        qualif.put(PHASE, "org.sat4j.minisat.orders");
        qualif.put(PARAMS, PACKAGE_PARAMS);
    }
}

