/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.ICDCLLogger;
import org.sat4j.minisat.orders.RandomWalkDecorator;
import org.sat4j.sat.DetailedCommandPanel;
import org.sat4j.sat.GnuplotPreferencesFrame;
import org.sat4j.sat.RemoteControlStrategy;

public class RemoteControlFrame
extends JFrame
implements ICDCLLogger {
    private static final long serialVersionUID = 1L;
    private String lookAndFeel;
    public static final Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private JMenuBar barreMenu;
    private JMenu menu;
    private JMenuItem activateTracing;
    private DetailedCommandPanel commandePanel;
    private String filename;
    private String ramdisk;
    private RemoteControlStrategy telecomStrategy;
    private RandomWalkDecorator randomWalk;
    private ICDCL solver;
    private GnuplotPreferencesFrame gnuplotFrame;
    private static final String ACTIVATE = "Activate Gnuplot Tracing";
    private static final String DEACTIVATE = "Deactivate Gnuplot Tracing";

    public RemoteControlFrame(String string, String string2, ICDCL iCDCL) {
        super("Remote Control");
        this.filename = string;
        this.ramdisk = string2;
        this.solver = iCDCL;
        this.initLookAndFeel();
        this.createAndShowGUI();
    }

    public RemoteControlFrame(String string, String string2) {
        this(string, string2, null);
    }

    public RemoteControlFrame(String string) {
        this(string, "", null);
    }

    public RemoteControlFrame(String string, ICDCL iCDCL) {
        this(string, "", iCDCL);
    }

    public void reinitialiser() {
    }

    public void setActivateGnuplot(boolean bl) {
        this.activateTracing.setSelected(bl);
        this.activateGnuplotTracing(bl);
    }

    public void initLookAndFeel() {
        JFrame.setDefaultLookAndFeelDecorated(true);
    }

    public void createAndShowGUI() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.createMenuBar();
        this.commandePanel = new DetailedCommandPanel(this.filename, this.ramdisk, this.solver);
        this.gnuplotFrame = new GnuplotPreferencesFrame(this.commandePanel.getGnuplotPreferences());
        JScrollPane jScrollPane = new JScrollPane(this.commandePanel);
        this.add(jScrollPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RemoteControlFrame.this.commandePanel.stopGnuplot();
                System.exit(0);
            }
        });
        this.pack();
        this.setVisible(true);
    }

    public void clickOnAboutSolver() {
        if (this.commandePanel.getSolver() != null) {
            JOptionPane.showMessageDialog(this, this.commandePanel.getSolver().toString());
        } else {
            JOptionPane.showMessageDialog(this, "No solver is running at the moment. Please start solver.");
        }
    }

    public void createMenuBar() {
        this.barreMenu = new JMenuBar();
        this.menu = new JMenu("File");
        this.barreMenu.add(this.menu);
        this.activateTracing = new JMenuItem(ACTIVATE);
        this.menu.add(this.activateTracing);
        this.activateTracing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.activateGnuplotTracing(RemoteControlFrame.this.activateTracing.getText().equals(RemoteControlFrame.ACTIVATE));
            }
        });
        JMenuItem jMenuItem = new JMenuItem("Exit");
        this.menu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.commandePanel.stopGnuplot();
                System.exit(0);
            }
        });
        JMenu jMenu = new JMenu("Preferences");
        JMenuItem jMenuItem2 = new JMenuItem("Gnuplot preferences");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RemoteControlFrame.this.gnuplotFrame.setVisible(true);
            }
        });
        jMenu.add(jMenuItem2);
        this.barreMenu.add(jMenu);
        this.barreMenu.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(this.getVersion());
        this.barreMenu.add(jLabel);
        this.setJMenuBar(this.barreMenu);
    }

    public void log(String string) {
        this.commandePanel.log(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        URL uRL = RemoteControlFrame.class.getResource("/sat4j.version");
        String string = "";
        if (uRL == null) {
            string = "no version file found!!!";
        } else {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                string = "version " + bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string = "c ERROR: " + iOException.getMessage();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        string = "c ERROR: " + iOException.getMessage();
                    }
                }
            }
        }
        return string;
    }

    public void activateGnuplotTracing(boolean bl) {
        if (bl) {
            this.log("Activated gnuplot");
            this.activateTracing.setText(DEACTIVATE);
        } else {
            this.log("Deactivated Gnuplot.");
            this.activateTracing.setText(ACTIVATE);
        }
        this.commandePanel.activateGnuplotTracing(bl);
    }
}

