/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.sat;

import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.ICDCLLogger;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import org.sat4j.minisat.restarts.NoRestarts;

public class RemoteControlStrategy
implements RestartStrategy,
IPhaseSelectionStrategy {
    private static final long serialVersionUID = 1L;
    private RestartStrategy restart = new NoRestarts();
    private IPhaseSelectionStrategy phaseSelectionStrategy = new RSATPhaseSelectionStrategy();
    private ICDCLLogger logger;
    private boolean isInterrupted;
    private boolean hasClickedOnRestart = false;
    private boolean hasClickedOnClean = false;
    private int conflictNumber;
    private int nbClausesAtWhichWeShouldClean;
    private boolean useTelecomStrategyAsLearnedConstraintsDeletionStrategy;
    private ICDCL solver;

    public RemoteControlStrategy(ICDCLLogger iCDCLLogger) {
        this.logger = iCDCLLogger;
        this.isInterrupted = false;
        this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy = false;
    }

    public RemoteControlStrategy() {
        this(null);
    }

    public boolean isHasClickedOnRestart() {
        return this.hasClickedOnRestart;
    }

    public void setHasClickedOnRestart(boolean bl) {
        this.hasClickedOnRestart = bl;
    }

    public boolean isHasClickedOnClean() {
        return this.hasClickedOnClean;
    }

    public void setHasClickedOnClean(boolean bl) {
        this.hasClickedOnClean = bl;
        this.clickedOnClean();
    }

    public boolean isUseTelecomStrategyAsLearnedConstraintsDeletionStrategy() {
        return this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy;
    }

    public void setUseTelecomStrategyAsLearnedConstraintsDeletionStrategy(boolean bl) {
        this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy = bl;
    }

    public void clickedOnClean() {
        if (this.hasClickedOnClean) {
            this.solver.setNeedToReduceDB(true);
            this.hasClickedOnClean = false;
        }
    }

    public RestartStrategy getRestartStrategy() {
        return this.restart;
    }

    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.phaseSelectionStrategy;
    }

    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        this.phaseSelectionStrategy = iPhaseSelectionStrategy;
    }

    public void setRestartStrategy(RestartStrategy restartStrategy) {
        this.restart = restartStrategy;
    }

    public int getNbClausesAtWhichWeShouldClean() {
        return this.nbClausesAtWhichWeShouldClean;
    }

    public void setNbClausesAtWhichWeShouldClean(int n) {
        this.nbClausesAtWhichWeShouldClean = n;
    }

    public ICDCLLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ICDCLLogger iCDCLLogger) {
        this.logger = iCDCLLogger;
    }

    public void init(SearchParams searchParams) {
        this.restart.init(searchParams);
    }

    public long nextRestartNumberOfConflict() {
        return this.restart.nextRestartNumberOfConflict();
    }

    public boolean shouldRestart() {
        if (this.hasClickedOnRestart) {
            this.hasClickedOnRestart = false;
            this.logger.log("Told the solver to restart with strategy " + this.restart);
            return true;
        }
        return this.restart.shouldRestart();
    }

    public void onRestart() {
        this.restart.onRestart();
    }

    public void onBackjumpToRootLevel() {
        this.restart.onBackjumpToRootLevel();
    }

    public SearchParams getSearchParams() {
        return this.restart.getSearchParams();
    }

    public ICDCL getSolver() {
        return this.solver;
    }

    public void setSolver(ICDCL iCDCL) {
        this.solver = iCDCL;
    }

    public void reset() {
        this.restart.newConflict();
    }

    public void newConflict() {
        this.restart.newConflict();
        ++this.conflictNumber;
        if (this.useTelecomStrategyAsLearnedConstraintsDeletionStrategy && this.conflictNumber > this.nbClausesAtWhichWeShouldClean) {
            this.conflictNumber = 0;
            this.solver.setNeedToReduceDB(true);
        }
    }

    public void updateVar(int n) {
        this.phaseSelectionStrategy.updateVar(n);
    }

    public void init(int n) {
        this.phaseSelectionStrategy.init(n);
    }

    public void init(int n, int n2) {
        this.phaseSelectionStrategy.init(n, n2);
    }

    public void assignLiteral(int n) {
        while (this.isInterrupted) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.phaseSelectionStrategy.assignLiteral(n);
    }

    public int select(int n) {
        return this.phaseSelectionStrategy.select(n);
    }

    public void updateVarAtDecisionLevel(int n) {
        this.phaseSelectionStrategy.updateVarAtDecisionLevel(n);
    }

    public String toString() {
        return "RemoteControlStrategy [restartStrategy = " + this.restart + ", learnedClausesDeletionStrategy = clean after " + this.nbClausesAtWhichWeShouldClean + " conflicts, phaseSelectionStrategy = " + this.phaseSelectionStrategy + "]";
    }

    public void setInterrupted(boolean bl) {
        this.isInterrupted = bl;
        if (this.isInterrupted) {
            this.logger.log("Solver paused");
        } else {
            this.logger.log("Resume solving");
        }
    }
}

