/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionLevelTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private PrintStream out;
    private int counter;

    public DecisionLevelTracing(String string) {
        this.filename = string;
        this.updateWriter();
    }

    private void updateWriter() {
        try {
            this.out = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append(".dat").toString()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out = System.out;
        }
        this.counter = 0;
    }

    @Override
    public void conflictFound(IConstr iConstr, int n, int n2) {
        ++this.counter;
    }

    @Override
    public void end(Lbool lbool) {
        this.out.close();
    }

    @Override
    public void start() {
        this.updateWriter();
    }

    @Override
    public void backjump(int n) {
        this.out.println(new StringBuffer().append(this.counter).append("\t").append(n).toString());
    }
}

