/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeedTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private final String filename;
    private PrintStream out;
    private PrintStream outClean;
    private PrintStream outRestart;
    private long begin;
    private long end;
    private int counter;
    private long index;
    private int nVar;

    public SpeedTracing(String string) {
        this.filename = string;
        this.updateWriter();
    }

    private void updateWriter() {
        try {
            this.out = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append(".dat").toString()));
            this.outClean = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append("-clean.dat").toString()));
            this.outRestart = new PrintStream(new FileOutputStream(new StringBuffer().append(this.filename).append("-restart.dat").toString()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out = System.out;
            this.outClean = System.out;
            this.outRestart = System.out;
        }
        this.begin = System.currentTimeMillis();
        this.counter = 0;
        this.index = 0L;
    }

    @Override
    public void assuming(int n) {
    }

    @Override
    public void propagating(int n, IConstr iConstr) {
        this.end = System.currentTimeMillis();
        if (this.end - this.begin >= 2000L) {
            long l = this.end - this.begin;
            this.index += l;
            this.out.println(new StringBuffer().append((double)this.index / 1000.0).append("\t").append((long)this.counter / l * 1000L).toString());
            this.outClean.println(new StringBuffer().append((double)this.index / 1000.0).append("\t").append(0).toString());
            this.outRestart.println(new StringBuffer().append((double)this.index / 1000.0).append("\t").append(0).toString());
            this.begin = System.currentTimeMillis();
            this.counter = 0;
        }
        ++this.counter;
    }

    @Override
    public void end(Lbool lbool) {
        this.out.close();
        this.outClean.close();
    }

    @Override
    public void cleaning() {
        this.end = System.currentTimeMillis();
        long l = this.index + (this.end - this.begin);
        this.out.println(new StringBuffer().append((double)l / 1000.0).append("\t").append((long)this.counter / (this.end - this.begin) * 1000L).toString());
        this.outClean.println(new StringBuffer().append((double)l / 1000.0).append("\t").append(this.nVar).toString());
        this.outRestart.println("#ignore");
    }

    @Override
    public void restarting() {
        this.end = System.currentTimeMillis();
        long l = this.index + (this.end - this.begin);
        this.out.println(new StringBuffer().append((double)l / 1000.0).append("\t").append((long)this.counter / (this.end - this.begin) * 1000L).toString());
        this.outRestart.println(new StringBuffer().append((double)l / 1000.0).append("\t").append(this.nVar).toString());
        this.outClean.println("#ignore");
    }

    @Override
    public void start() {
        this.updateWriter();
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.nVar = iSolverService.nVars();
    }
}

