/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.LearntWLClause;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.pb.constraints.pb.AtLeastPB;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.IInternalPBConstraintCreator;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.constraints.pb.WLClausePB;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPBDataStructureFactory
extends AbstractDataStructureFactory<ILits>
implements PBDataStructureFactory<ILits>,
IInternalPBConstraintCreator {
    @Override
    public Constr createClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = WLClause.sanityCheck(iVecInt, this.getVocabulary(), this.solver);
        if (iVecInt2 == null) {
            return null;
        }
        return WLClausePB.brandNewClause(this.solver, this.getVocabulary(), iVecInt2);
    }

    @Override
    public Constr createUnregisteredClause(IVecInt iVecInt) {
        return new LearntWLClause(iVecInt, (ILits)this.getVocabulary());
    }

    @Override
    public Constr createCardinalityConstraint(IVecInt iVecInt, int n) throws ContradictionException {
        return AtLeastPB.atLeastNew(this.solver, this.getVocabulary(), iVecInt, n);
    }

    @Override
    public Constr createPseudoBooleanConstraint(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return this.constraintFactory(iVecInt, iVec, bl, bigInteger);
    }

    protected abstract PBConstr constraintFactory(IVecInt var1, IVecInt var2, boolean var3, int var4) throws ContradictionException;

    protected abstract PBConstr constraintFactory(IDataStructurePB var1);

    protected abstract PBConstr constraintFactory(IVecInt var1, IVec<BigInteger> var2, boolean var3, BigInteger var4) throws ContradictionException;

    @Override
    public Constr createUnregisteredPseudoBooleanConstraint(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return this.constraintFactory(iVecInt, iVec, bigInteger);
    }

    @Override
    public Constr createUnregisteredPseudoBooleanConstraint(IDataStructurePB iDataStructurePB) {
        return this.constraintFactory(iDataStructurePB);
    }

    public IConstr createUnregisteredPseudoBooleanConstraint(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return this.constraintFactory(iVecInt, iVec, bl, bigInteger);
    }

    protected abstract PBConstr constraintFactory(IVecInt var1, IVecInt var2, int var3);

    protected abstract PBConstr constraintFactory(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);

    @Override
    protected ILits createLits() {
        return new Lits();
    }

    public /* synthetic */ IConstr createUnregisteredPseudoBooleanConstraint(IVecInt iVecInt, IVec iVec, BigInteger bigInteger) {
        return this.createUnregisteredPseudoBooleanConstraint(iVecInt, iVec, bigInteger);
    }
}

