/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.Messages;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.DotSearchListener;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.PercentLengthLearning;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lanceur
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    protected ASolverFactory<ISolver> factory;
    private String filename;

    public static void main(String[] stringArray) {
        Lanceur lanceur = new Lanceur();
        lanceur.run(stringArray);
        System.exit(lanceur.getExitCode().value());
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("d", "dot", true, "create a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("r", "replay", true, "replay stored results");
        options.addOption("b", "backup", true, "backup results in specified file");
        options.addOption("u", "update", false, "update results file if needed");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        Option option = options.getOption("l");
        option.setArgName("libname");
        option = options.getOption("s");
        option.setArgName("solvername");
        option = options.getOption("t");
        option.setArgName("delay");
        options.getOption("d");
        return options;
    }

    @Override
    protected ISolver configureSolver(String[] stringArray) {
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            return null;
        }
        try {
            Object object;
            Object object2;
            Serializable serializable;
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            String string = commandLine.getOptionValue("l");
            if (string == null) {
                string = "minisat";
            }
            assert ("minisat".equals(string) || "ubcsat".equals(string));
            try {
                serializable = Class.forName("org.sat4j." + string + ".SolverFactory");
                object2 = new Class[]{};
                object = ((Class)serializable).getMethod("instance", (Class<?>)object2);
                this.factory = (ASolverFactory)((Method)object).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                System.err.println(Messages.getString("Lanceur.wrong.framework"));
                exception.printStackTrace();
            }
            serializable = commandLine.hasOption("S") ? this.configureFromString(commandLine.getOptionValue("S")) : ((object2 = commandLine.getOptionValue("s")) == null ? this.factory.defaultSolver() : this.factory.createSolverByName((String)object2));
            object2 = commandLine.getOptionValue("t");
            if (object2 == null) {
                object2 = commandLine.getOptionValue("T");
                if (object2 != null) {
                    serializable.setTimeoutMs(Long.parseLong((String)object2));
                }
            } else {
                serializable.setTimeout(Integer.parseInt((String)object2));
            }
            this.filename = commandLine.getOptionValue("f");
            if (commandLine.hasOption("d")) {
                object = null;
                if (this.filename != null) {
                    object = commandLine.getOptionValue("d");
                }
                if (object == null) {
                    object = "sat4j.dot";
                }
                ((Solver)serializable).setSearchListener(new DotSearchListener((String)object));
            }
            if (commandLine.hasOption("m")) {
                this.setSilent(true);
            }
            int n = 0;
            String[] stringArray2 = commandLine.getArgs();
            if (this.filename == null) {
                this.filename = stringArray2[n++];
            }
            while (n < stringArray2.length) {
                String[] stringArray3 = stringArray2[n].split("=");
                assert (stringArray3.length == 2);
                this.log("setting " + stringArray3[0] + " to " + stringArray3[1]);
                try {
                    BeanUtils.setProperty(serializable, stringArray3[0], stringArray3[1]);
                }
                catch (Exception exception) {
                    this.log("Cannot set parameter : " + stringArray[n]);
                }
                ++n;
            }
            this.log(serializable.toString("c "));
            return serializable;
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        return new InstanceReader(iSolver);
    }

    @Override
    protected void usage() {
        this.showAvailableSolvers(this.factory);
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        return this.filename;
    }

    private final ISolver configureFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = string2.split("=");
            properties.setProperty(stringArray[0], stringArray[1]);
        }
        DataStructureFactory dataStructureFactory = this.setupObject("DSF", properties, new MixedDataStructureDaniel());
        LearningStrategy learningStrategy = this.setupObject("LEARNING", properties, new PercentLengthLearning());
        IOrder iOrder = this.setupObject("ORDER", properties, new VarOrderHeap());
        RestartStrategy restartStrategy = this.setupObject("RESTARTS", properties, new MiniSATRestarts());
        Solver solver = new Solver(new FirstUIP(), learningStrategy, dataStructureFactory, iOrder, restartStrategy);
        learningStrategy.setSolver(solver);
        solver.setSimplifier(properties.getProperty("SIMP", "NO_SIMPLIFICATION"));
        SearchParams searchParams = this.setupObject("PARAMS", properties, new SearchParams());
        solver.setSearchParams(searchParams);
        return solver;
    }

    private final <T> T setupObject(String string, Properties properties, T t) {
        try {
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                this.log("using default component " + t + " for " + string);
                return t;
            }
            this.log("configuring " + string);
            String[] stringArray = string2.split("/");
            Object obj = Class.forName(stringArray[0]).newInstance();
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                assert (stringArray2.length == 2);
                try {
                    BeanUtils.getProperty(obj, stringArray2[0]);
                    BeanUtils.setProperty(obj, stringArray2[0], stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    this.log("Problem with component " + stringArray[0] + " " + exception);
                }
            }
            return (T)obj;
        }
        catch (InstantiationException instantiationException) {
            this.log("Problem with component " + string + " " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log("Problem with component " + string + " " + illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Problem with component " + string + " " + classNotFoundException);
        }
        this.log("using default component " + t + " for " + string);
        return t;
    }
}

