/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LimitedLearning<L extends ILits, D extends DataStructureFactory<L>>
implements LearningStrategy<L, D> {
    private static final long serialVersionUID = 1L;
    private final NoLearningButHeuristics<L, D> none = new NoLearningButHeuristics();
    private final MiniSATLearning<L, D> all = new MiniSATLearning();
    protected L lits;

    @Override
    public void setSolver(Solver<L, D> solver) {
        this.lits = solver.getVocabulary();
        this.setVarActivityListener(solver);
        this.all.setDataStructureFactory(solver.getDSFactory());
    }

    @Override
    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
        }
    }

    protected abstract boolean learningCondition(Constr var1);

    @Override
    public void init() {
        this.all.init();
        this.none.init();
    }

    @Override
    public void setVarActivityListener(VarActivityListener varActivityListener) {
        this.none.setVarActivityListener(varActivityListener);
        this.all.setVarActivityListener(varActivityListener);
    }
}

