/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateTranslator
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;

    public GateTranslator(ISolver iSolver) {
        super(iSolver);
    }

    public IConstr gateFalse(int n) throws ContradictionException {
        VecInt vecInt = new VecInt(2);
        vecInt.push(-n);
        return this.processClause(vecInt);
    }

    public IConstr gateTrue(int n) throws ContradictionException {
        VecInt vecInt = new VecInt(2);
        vecInt.push(n);
        return this.processClause(vecInt);
    }

    public IConstr[] ite(int n, int n2, int n3, int n4) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[6];
        VecInt vecInt = new VecInt(5);
        vecInt.push(-n).push(-n2).push(n3);
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n).push(n2).push(n4);
        iConstrArray[1] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n3).push(n);
        iConstrArray[2] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(-n4).push(n);
        iConstrArray[3] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n3).push(-n4).push(n);
        iConstrArray[4] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n).push(n3).push(n4);
        iConstrArray[5] = this.processClause(vecInt);
        return iConstrArray;
    }

    public IConstr[] and(int n, IVecInt iVecInt) throws ContradictionException {
        int n2;
        IConstr[] iConstrArray = new IConstr[iVecInt.size() + 1];
        VecInt vecInt = new VecInt(iVecInt.size() + 2);
        vecInt.push(n);
        for (n2 = 0; n2 < iVecInt.size(); ++n2) {
            vecInt.push(-iVecInt.get(n2));
        }
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        for (n2 = 0; n2 < iVecInt.size(); ++n2) {
            vecInt.clear();
            vecInt.push(-n);
            vecInt.push(iVecInt.get(n2));
            iConstrArray[n2 + 1] = this.processClause(vecInt);
        }
        return iConstrArray;
    }

    public IConstr[] and(int n, int n2, int n3) throws ContradictionException {
        VecInt vecInt = new VecInt(4);
        IConstr[] iConstrArray = new IConstr[3];
        vecInt.push(-n);
        vecInt.push(n2);
        iConstrArray[0] = this.addClause(vecInt);
        vecInt.clear();
        vecInt.push(-n);
        vecInt.push(n3);
        iConstrArray[1] = this.addClause(vecInt);
        vecInt.clear();
        vecInt.push(n);
        vecInt.push(-n2);
        vecInt.push(-n3);
        iConstrArray[2] = this.addClause(vecInt);
        return iConstrArray;
    }

    public IConstr[] or(int n, IVecInt iVecInt) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[iVecInt.size() + 1];
        VecInt vecInt = new VecInt(iVecInt.size() + 2);
        iVecInt.copyTo(vecInt);
        vecInt.push(-n);
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        for (int i = 0; i < iVecInt.size(); ++i) {
            vecInt.clear();
            vecInt.push(n);
            vecInt.push(-iVecInt.get(i));
            iConstrArray[i + 1] = this.processClause(vecInt);
        }
        return iConstrArray;
    }

    private IConstr processClause(IVecInt iVecInt) throws ContradictionException {
        return this.addClause(iVecInt);
    }

    public IConstr[] not(int n, int n2) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[2];
        VecInt vecInt = new VecInt(3);
        vecInt.push(-n).push(-n2);
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n).push(n2);
        iConstrArray[1] = this.processClause(vecInt);
        return iConstrArray;
    }

    public IConstr[] xor(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(-n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        Vec<IConstr> vec = new Vec<IConstr>();
        this.xor2Clause(nArray, 0, false, vec);
        IConstr[] iConstrArray = new IConstr[vec.size()];
        vec.copyTo(iConstrArray);
        return iConstrArray;
    }

    public IConstr[] iff(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        Vec<IConstr> vec = new Vec<IConstr>();
        this.iff2Clause(nArray, 0, false, vec);
        IConstr[] iConstrArray = new IConstr[vec.size()];
        vec.copyTo(iConstrArray);
        return iConstrArray;
    }

    private void xor2Clause(int[] nArray, int n, boolean bl, IVec<IConstr> iVec) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length + 1);
            for (int i = 0; i < nArray.length - 1; ++i) {
                vecInt.push(nArray[i]);
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            iVec.push(this.processClause(vecInt));
            return;
        }
        if (bl) {
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true, iVec);
        } else {
            this.xor2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true, iVec);
            nArray[n] = -nArray[n];
        }
    }

    private void iff2Clause(int[] nArray, int n, boolean bl, IVec<IConstr> iVec) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length + 1);
            for (int i = 0; i < nArray.length - 1; ++i) {
                vecInt.push(nArray[i]);
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            this.processClause(vecInt);
            return;
        }
        if (bl) {
            this.iff2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true, iVec);
            nArray[n] = -nArray[n];
        } else {
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true, iVec);
        }
    }
}

