/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.QuickXplainStrategy;
import org.sat4j.tools.xplain.XplainStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xplain<T extends ISolver>
extends SolverDecorator<T> {
    protected Map<Integer, IConstr> constrs = new HashMap<Integer, IConstr>();
    protected IVecInt assump;
    private int lastCreatedVar;
    private boolean pooledVarId = false;
    private final IVecInt lastClause = new VecInt();
    private static final XplainStrategy XPLAIN_STRATEGY;
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.xplain.Xplain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        XPLAIN_STRATEGY = new QuickXplainStrategy();
    }

    public Xplain(T t) {
        super(t);
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        if (iVecInt.equals(this.lastClause)) {
            return null;
        }
        this.lastClause.clear();
        iVecInt.copyTo(this.lastClause);
        int n = this.createNewVar(iVecInt);
        iVecInt.push(n);
        IConstr iConstr = super.addClause(iVecInt);
        if (iConstr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(n), iConstr);
        }
        return iConstr;
    }

    protected int createNewVar(IVecInt iVecInt) {
        if (this.pooledVarId) {
            this.pooledVarId = false;
            return this.lastCreatedVar;
        }
        this.lastCreatedVar = this.nextFreeVarId(true);
        return this.lastCreatedVar;
    }

    protected void discardLastestVar() {
        this.pooledVarId = true;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    public Collection<IConstr> explain() throws TimeoutException {
        if (!$assertionsDisabled && this.isSatisfiable(this.assump)) {
            throw new AssertionError();
        }
        Object t = this.decorated();
        if (t instanceof IOptimizationProblem) {
            t = ((SolverDecorator)t).decorated();
        }
        IVecInt iVecInt = XPLAIN_STRATEGY.explain((ISolver)t, this.constrs, this.assump);
        ArrayList<IConstr> arrayList = new ArrayList<IConstr>(iVecInt.size());
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            arrayList.add(this.constrs.get(new Integer(iteratorInt.next())));
        }
        return arrayList;
    }

    public void cancelExplanation() {
        XPLAIN_STRATEGY.cancelExplanationComputation();
    }

    public Collection<IConstr> getConstraints() {
        return this.constrs.values();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (Integer n : this.constrs.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (Integer n : this.constrs.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (Integer n : this.constrs.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        for (Integer n : this.constrs.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (Integer n : this.constrs.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        for (Integer n : this.constrs.keySet()) {
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    @Override
    public int[] model() {
        int[] nArray = super.model();
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length - this.constrs.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (this.constrs.get(new Integer(Math.abs(nArray[n2]))) == null) {
                nArray2[n++] = nArray[n2];
            }
            ++n2;
        }
        return nArray2;
    }
}

