/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class PseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private BigInteger objectiveValue;
    private int[] prevmodel;
    private boolean[] prevfullmodel;
    private IConstr previousPBConstr;

    public PseudoOptDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, bl);
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        boolean bl2 = super.isSatisfiable(iVecInt, true);
        if (bl2) {
            this.prevmodel = super.model();
            this.prevfullmodel = new boolean[this.nVars()];
            int n = 0;
            while (n < this.nVars()) {
                this.prevfullmodel[n] = ((IPBSolver)this.decorated()).model(n + 1);
                ++n;
            }
        } else if (this.previousPBConstr != null) {
            ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
            this.previousPBConstr = null;
        }
        return bl2;
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.isSatisfiable(iVecInt, true);
    }

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objfct = objectiveFunction;
        ((IPBSolver)this.decorated()).setObjectiveFunction(objectiveFunction);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        try {
            boolean bl = super.isSatisfiable(iVecInt, true);
            if (bl) {
                this.prevmodel = super.model();
                this.prevfullmodel = new boolean[this.nVars()];
                int n = 0;
                while (n < this.nVars()) {
                    this.prevfullmodel[n] = ((IPBSolver)this.decorated()).model(n + 1);
                    ++n;
                }
                if (this.objfct != null) {
                    this.calculateObjective();
                }
            } else if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
            return bl;
        }
        catch (TimeoutException timeoutException) {
            if (this.previousPBConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
                this.previousPBConstr = null;
            }
            throw timeoutException;
        }
    }

    public boolean hasNoObjectiveFunction() {
        return this.objfct == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        if (this.objfct == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = this.objfct.calculateDegree(this.prevmodel);
        return this.objectiveValue;
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.previousPBConstr != null) {
            super.removeSubsumedConstr(this.previousPBConstr);
        }
        if (this.objfct != null && this.objectiveValue != null) {
            this.previousPBConstr = super.addPseudoBoolean(this.objfct.getVars(), this.objfct.getCoeffs(), false, this.objectiveValue.subtract(BigInteger.ONE));
        }
    }

    public void reset() {
        this.previousPBConstr = null;
        super.reset();
    }

    public int[] model() {
        return this.prevmodel;
    }

    public boolean model(int n) {
        return this.prevfullmodel[n - 1];
    }

    public String toString(String string) {
        return String.valueOf(string) + "Pseudo Boolean Optimization\n" + super.toString(string);
    }

    public Number getObjectiveValue() {
        return this.objectiveValue;
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        super.addPseudoBoolean(this.objfct.getVars(), this.objfct.getCoeffs(), false, (BigInteger)number);
    }
}

